/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Media;
import com.github.sommeri.less4j.core.ast.MediaQuery;
import com.github.sommeri.less4j.core.compiler.stages.ASTManipulator;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class NestedMediaCollector {
    private final ASTManipulator manipulator = new ASTManipulator();
    private Stack<List<MediaQuery>> mediums;
    private LinkedList<Media> finalMedia;
    private ProblemsHandler problemsHandler;

    public NestedMediaCollector(ProblemsHandler problemsHandler) {
        this.problemsHandler = problemsHandler;
    }

    public List<Media> collectMedia(Media kid) {
        this.mediums = new Stack();
        this.finalMedia = new LinkedList();
        this.pushMediums(kid);
        this.collectChildMedia(kid);
        this.popMediums();
        return this.finalMedia;
    }

    private void collectChildMedia(ASTCssNode node) {
        ArrayList<? extends ASTCssNode> childs = new ArrayList<ASTCssNode>(node.getChilds());
        for (ASTCssNode aSTCssNode : childs) {
            switch (aSTCssNode.getType()) {
                case MEDIA: {
                    Media nestedMedia = (Media)aSTCssNode;
                    this.manipulator.removeFromBody(nestedMedia);
                    this.collect(nestedMedia);
                    this.pushMediums(nestedMedia);
                    this.collectChildMedia(nestedMedia.getBody());
                    this.popMediums();
                    break;
                }
                case GENERAL_BODY: {
                    this.collectChildMedia(aSTCssNode);
                    break;
                }
            }
        }
    }

    private void collect(Media media) {
        this.combine(media, this.mediums.peek());
        this.finalMedia.add(media);
    }

    public void combine(Media media, List<MediaQuery> previousMediaQueries) {
        ArrayList<MediaQuery> result = new ArrayList<MediaQuery>();
        for (MediaQuery mediaQuery : media.getMediums()) {
            for (MediaQuery previousMediaQuery : previousMediaQueries) {
                result.add(this.combine(previousMediaQuery, mediaQuery));
            }
        }
        media.replaceMediaQueries(result);
        media.configureParentToAllChilds();
    }

    private MediaQuery combine(MediaQuery previousMediaQuery, MediaQuery mediaQuery) {
        MediaQuery previousMediaQueryClone = previousMediaQuery.clone();
        if (mediaQuery.getMedium() != null) {
            this.problemsHandler.warnMerginMediaQueryWithMedium(mediaQuery);
        }
        previousMediaQueryClone.addExpressions(ArraysUtils.deeplyClonedList(mediaQuery.getExpressions()));
        previousMediaQueryClone.configureParentToAllChilds();
        return previousMediaQueryClone;
    }

    private void pushMediums(Media kid) {
        this.mediums.push(new ArrayList<MediaQuery>(kid.getMediums()));
    }

    private void popMediums() {
        this.mediums.pop();
    }
}

