/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.scriptengine.Command;
import org.apache.manifoldcf.scriptengine.RewindableTokenStream;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.ScriptParser;
import org.apache.manifoldcf.scriptengine.Token;
import org.apache.manifoldcf.scriptengine.TokenStream;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class WhileCommand
implements Command {
    @Override
    public boolean parseAndExecute(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        block4: {
            RewindableTokenStream rts = new RewindableTokenStream(currentStream);
            boolean breakFromLoop = false;
            while (true) {
                Token t;
                rts.reset();
                if (breakFromLoop) {
                    sp.skipStatements(rts);
                    break block4;
                }
                VariableReference whileCondition = sp.evaluateExpression(rts);
                if (whileCondition == null) {
                    ScriptParser.syntaxError(rts, "Missing while expression");
                }
                if ((t = rts.peek()) == null || t.getToken() == null || !t.getToken().equals("do")) {
                    ScriptParser.syntaxError(rts, "Missing 'do' in while statement");
                }
                rts.skip();
                if (!ScriptParser.resolveMustExist(rts, whileCondition).getBooleanValue()) break;
                breakFromLoop = sp.parseStatements(rts);
            }
            sp.skipStatements(rts);
        }
        return false;
    }

    @Override
    public void parseAndSkip(ScriptParser sp, TokenStream currentStream) throws ScriptException {
        Token t;
        if (!sp.skipExpression(currentStream)) {
            ScriptParser.syntaxError(currentStream, "Missing while expression");
        }
        if ((t = currentStream.peek()) == null || t.getToken() == null || !t.getToken().equals("do")) {
            ScriptParser.syntaxError(currentStream, "Missing 'do' in if statement");
        }
        currentStream.skip();
        sp.skipStatements(currentStream);
    }
}

