/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.jira;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.XThreadStringBuffer;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.jira.JiraIssue;
import org.apache.manifoldcf.crawler.connectors.jira.JiraSession;
import org.apache.manifoldcf.crawler.connectors.jira.Messages;
import org.apache.manifoldcf.crawler.connectors.jira.ResponseException;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class JiraRepositoryConnector
extends BaseRepositoryConnector {
    protected static final String ACTIVITY_READ = "read document";
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    private static final String JOB_STARTPOINT_NODE_TYPE = "startpoint";
    private static final String JOB_QUERY_ATTRIBUTE = "query";
    private static final String JOB_SECURITY_NODE_TYPE = "security";
    private static final String JOB_VALUE_ATTRIBUTE = "value";
    private static final String JOB_ACCESS_NODE_TYPE = "access";
    private static final String JOB_TOKEN_ATTRIBUTE = "token";
    private static final String JIRA_SERVER_TAB_PROPERTY = "JiraRepositoryConnector.Server";
    private static final String JIRA_PROXY_TAB_PROPERTY = "JiraRepositoryConnector.Proxy";
    private static final String JIRA_QUERY_TAB_PROPERTY = "JiraRepositoryConnector.JiraQuery";
    private static final String JIRA_SECURITY_TAB_PROPERTY = "JiraRepositoryConnector.Security";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration_jira.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_jira_server.html";
    private static final String EDIT_CONFIG_FORWARD_PROXY = "editConfiguration_jira_proxy.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration_jira.html";
    private static final String EDIT_SPEC_HEADER_FORWARD = "editSpecification_jira.js";
    private static final String EDIT_SPEC_FORWARD_JIRAQUERY = "editSpecification_jiraQuery.html";
    private static final String EDIT_SPEC_FORWARD_SECURITY = "editSpecification_jiraSecurity.html";
    private static final String VIEW_SPEC_FORWARD = "viewSpecification_jira.html";
    protected JiraSession session = null;
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;
    protected String jiraprotocol = null;
    protected String jirahost = null;
    protected String jiraport = null;
    protected String jirapath = null;
    protected String clientid = null;
    protected String clientsecret = null;
    protected String jiraproxyhost = null;
    protected String jiraproxyport = null;
    protected String jiraproxydomain = null;
    protected String jiraproxyusername = null;
    protected String jiraproxypassword = null;

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_READ};
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.jirahost};
    }

    public void disconnect() throws ManifoldCFException {
        if (this.session != null) {
            this.session.close();
            this.session = null;
            this.lastSessionFetch = -1L;
        }
        this.jiraprotocol = null;
        this.jirahost = null;
        this.jiraport = null;
        this.jirapath = null;
        this.clientid = null;
        this.clientsecret = null;
        this.jiraproxyhost = null;
        this.jiraproxyport = null;
        this.jiraproxydomain = null;
        this.jiraproxyusername = null;
        this.jiraproxypassword = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.jiraprotocol = this.params.getParameter("jiraprotocol");
        this.jirahost = this.params.getParameter("jirahost");
        this.jiraport = this.params.getParameter("jiraport");
        this.jirapath = this.params.getParameter("jirapath");
        this.clientid = this.params.getParameter("clientid");
        this.clientsecret = this.params.getObfuscatedParameter("clientsecret");
        this.jiraproxyhost = this.params.getParameter("jiraproxyhost");
        this.jiraproxyport = this.params.getParameter("jiraproxyport");
        this.jiraproxydomain = this.params.getParameter("jiraproxydomain");
        this.jiraproxyusername = this.params.getParameter("jiraproxyusername");
        this.jiraproxypassword = this.params.getObfuscatedParameter("jiraproxypassword");
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected JiraSession getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            int proxyPortInt;
            int portInt;
            if (StringUtils.isEmpty((String)this.jiraprotocol)) {
                throw new ManifoldCFException("Parameter jiraprotocol required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JIRA: jiraprotocol = '" + this.jiraprotocol + "'"));
            }
            if (StringUtils.isEmpty((String)this.jirahost)) {
                throw new ManifoldCFException("Parameter jirahost required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JIRA: jirahost = '" + this.jirahost + "'"));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JIRA: jiraport = '" + this.jiraport + "'"));
            }
            if (StringUtils.isEmpty((String)this.jirapath)) {
                throw new ManifoldCFException("Parameter jirapath required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JIRA: jirapath = '" + this.jirapath + "'"));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JIRA: Clientid = '" + this.clientid + "'"));
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("JIRA: Clientsecret = '" + this.clientsecret + "'"));
            }
            if (this.jiraport != null && this.jiraport.length() > 0) {
                try {
                    portInt = Integer.parseInt(this.jiraport);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                portInt = this.jiraprotocol.toLowerCase(Locale.ROOT).equals("http") ? 80 : 443;
            }
            if (this.jiraproxyport != null && this.jiraproxyport.length() > 0) {
                try {
                    proxyPortInt = Integer.parseInt(this.jiraproxyport);
                }
                catch (NumberFormatException e) {
                    throw new ManifoldCFException("Bad number: " + e.getMessage(), (Throwable)e);
                }
            } else {
                proxyPortInt = 8080;
            }
            this.session = new JiraSession(this.clientid, this.clientsecret, this.jiraprotocol, this.jirahost, portInt, this.jirapath, this.jiraproxyhost, proxyPortInt, this.jiraproxydomain, this.jiraproxyusername, this.jiraproxypassword);
        }
        this.lastSessionFetch = System.currentTimeMillis();
        return this.session;
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            this.session.close();
            this.session = null;
            this.lastSessionFetch = -1L;
        }
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public String[] getRelationshipTypes() {
        return new String[0];
    }

    private static void fillInServerConfigurationMap(Map<String, Object> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String jiraprotocol = parameters.getParameter("jiraprotocol");
        String jirahost = parameters.getParameter("jirahost");
        String jiraport = parameters.getParameter("jiraport");
        String jirapath = parameters.getParameter("jirapath");
        String clientid = parameters.getParameter("clientid");
        String clientsecret = parameters.getObfuscatedParameter("clientsecret");
        if (jiraprotocol == null) {
            jiraprotocol = "http";
        }
        if (jirahost == null) {
            jirahost = "";
        }
        if (jiraport == null) {
            jiraport = "";
        }
        if (jirapath == null) {
            jirapath = "/rest/api/2/";
        }
        if (clientid == null) {
            clientid = "";
        }
        clientsecret = clientsecret == null ? "" : mapper.mapPasswordToKey(clientsecret);
        newMap.put("JIRAPROTOCOL", jiraprotocol);
        newMap.put("JIRAHOST", jirahost);
        newMap.put("JIRAPORT", jiraport);
        newMap.put("JIRAPATH", jirapath);
        newMap.put("CLIENTID", clientid);
        newMap.put("CLIENTSECRET", clientsecret);
    }

    private static void fillInProxyConfigurationMap(Map<String, Object> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String jiraproxyhost = parameters.getParameter("jiraproxyhost");
        String jiraproxyport = parameters.getParameter("jiraproxyport");
        String jiraproxydomain = parameters.getParameter("jiraproxydomain");
        String jiraproxyusername = parameters.getParameter("jiraproxyusername");
        String jiraproxypassword = parameters.getObfuscatedParameter("jiraproxypassword");
        if (jiraproxyhost == null) {
            jiraproxyhost = "";
        }
        if (jiraproxyport == null) {
            jiraproxyport = "";
        }
        if (jiraproxydomain == null) {
            jiraproxydomain = "";
        }
        if (jiraproxyusername == null) {
            jiraproxyusername = "";
        }
        jiraproxypassword = jiraproxypassword == null ? "" : mapper.mapPasswordToKey(jiraproxypassword);
        newMap.put("JIRAPROXYHOST", jiraproxyhost);
        newMap.put("JIRAPROXYPORT", jiraproxyport);
        newMap.put("JIRAPROXYDOMAIN", jiraproxydomain);
        newMap.put("JIRAPROXYUSERNAME", jiraproxyusername);
        newMap.put("JIRAPROXYPASSWORD", jiraproxypassword);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        JiraRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        JiraRepositoryConnector.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, JIRA_SERVER_TAB_PROPERTY));
        tabsArray.add(Messages.getString(locale, JIRA_PROXY_TAB_PROPERTY));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        JiraRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        JiraRepositoryConnector.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        JiraRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        JiraRepositoryConnector.fillInProxyConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_SERVER, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_PROXY, paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String jiraproxypassword;
        String jiraproxyusername;
        String jiraproxydomain;
        String jiraproxyport;
        String jiraproxyhost;
        String clientsecret;
        String clientid;
        String jirapath;
        String jiraport;
        String jirahost;
        String jiraprotocol = variableContext.getParameter("jiraprotocol");
        if (jiraprotocol != null) {
            parameters.setParameter("jiraprotocol", jiraprotocol);
        }
        if ((jirahost = variableContext.getParameter("jirahost")) != null) {
            parameters.setParameter("jirahost", jirahost);
        }
        if ((jiraport = variableContext.getParameter("jiraport")) != null) {
            parameters.setParameter("jiraport", jiraport);
        }
        if ((jirapath = variableContext.getParameter("jirapath")) != null) {
            parameters.setParameter("jirapath", jirapath);
        }
        if ((clientid = variableContext.getParameter("clientid")) != null) {
            parameters.setParameter("clientid", clientid);
        }
        if ((clientsecret = variableContext.getParameter("clientsecret")) != null) {
            parameters.setObfuscatedParameter("clientsecret", variableContext.mapKeyToPassword(clientsecret));
        }
        if ((jiraproxyhost = variableContext.getParameter("jiraproxyhost")) != null) {
            parameters.setParameter("jiraproxyhost", jiraproxyhost);
        }
        if ((jiraproxyport = variableContext.getParameter("jiraproxyport")) != null) {
            parameters.setParameter("jiraproxyport", jiraproxyport);
        }
        if ((jiraproxydomain = variableContext.getParameter("jiraproxydomain")) != null) {
            parameters.setParameter("jiraproxydomain", jiraproxydomain);
        }
        if ((jiraproxyusername = variableContext.getParameter("jiraproxyusername")) != null) {
            parameters.setParameter("jiraproxyusername", jiraproxyusername);
        }
        if ((jiraproxypassword = variableContext.getParameter("jiraproxypassword")) != null) {
            parameters.setObfuscatedParameter("jiraproxypassword", variableContext.mapKeyToPassword(jiraproxypassword));
        }
        return null;
    }

    private static void fillInJIRAQuerySpecificationMap(Map<String, Object> newMap, Specification ds) {
        String JiraQuery = "ORDER BY createdDate Asc";
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
            JiraQuery = sn.getAttributeValue(JOB_QUERY_ATTRIBUTE);
        }
        newMap.put("JIRAQUERY", JiraQuery);
    }

    private static void fillInJIRASecuritySpecificationMap(Map<String, Object> newMap, Specification ds) {
        ArrayList accessTokenList = new ArrayList();
        String securityValue = "on";
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (sn.getType().equals(JOB_ACCESS_NODE_TYPE)) {
                String token = sn.getAttributeValue(JOB_TOKEN_ATTRIBUTE);
                HashMap<String, String> accessMap = new HashMap<String, String>();
                accessMap.put("TOKEN", token);
                accessTokenList.add(accessMap);
                continue;
            }
            if (!sn.getType().equals(JOB_SECURITY_NODE_TYPE)) continue;
            securityValue = sn.getAttributeValue(JOB_VALUE_ATTRIBUTE);
        }
        newMap.put("ACCESSTOKENS", accessTokenList);
        newMap.put("SECURITYON", securityValue);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        JiraRepositoryConnector.fillInJIRAQuerySpecificationMap(paramMap, ds);
        JiraRepositoryConnector.fillInJIRASecuritySpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPEC_FORWARD, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String xc;
        String securityOn;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String jiraDriveQuery = variableContext.getParameter(seqPrefix + "jiraquery");
        if (jiraDriveQuery != null) {
            for (int i = 0; i < ds.getChildCount(); ++i) {
                SpecificationNode oldNode = ds.getChild(i);
                if (!oldNode.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
                ds.removeChild(i);
                break;
            }
            SpecificationNode node = new SpecificationNode(JOB_STARTPOINT_NODE_TYPE);
            node.setAttribute(JOB_QUERY_ATTRIBUTE, jiraDriveQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        if ((securityOn = variableContext.getParameter(seqPrefix + "specsecurity")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals(JOB_SECURITY_NODE_TYPE)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            SpecificationNode node = new SpecificationNode(JOB_SECURITY_NODE_TYPE);
            node.setAttribute(JOB_VALUE_ATTRIBUTE, securityOn);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals(JOB_ACCESS_NODE_TYPE)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode(JOB_ACCESS_NODE_TYPE);
                node.setAttribute(JOB_TOKEN_ATTRIBUTE, accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node = new SpecificationNode(JOB_ACCESS_NODE_TYPE);
                node.setAttribute(JOB_TOKEN_ATTRIBUTE, accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        JiraRepositoryConnector.fillInJIRAQuerySpecificationMap(paramMap, ds);
        JiraRepositoryConnector.fillInJIRASecuritySpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_JIRAQUERY, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_SECURITY, paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, JIRA_QUERY_TAB_PROPERTY));
        tabsArray.add(Messages.getString(locale, JIRA_SECURITY_TAB_PROPERTY));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        JiraRepositoryConnector.fillInJIRAQuerySpecificationMap(paramMap, ds);
        JiraRepositoryConnector.fillInJIRASecuritySpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_HEADER_FORWARD, paramMap);
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        String jiraDriveQuery = "ORDER BY createdDate Asc";
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
            jiraDriveQuery = sn.getAttributeValue(JOB_QUERY_ATTRIBUTE);
            break;
        }
        GetSeedsThread t = new GetSeedsThread(this.getSession(), jiraDriveQuery);
        try {
            t.start();
            boolean wasInterrupted = false;
            try {
                String issueKey;
                XThreadStringBuffer seedBuffer = t.getBuffer();
                while ((issueKey = seedBuffer.fetch()) != null) {
                    activities.addSeedDocument("I-" + issueKey);
                }
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                throw e;
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    wasInterrupted = true;
                }
                throw e;
            }
            finally {
                if (!wasInterrupted) {
                    t.finishUp();
                }
            }
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (IOException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (ResponseException e) {
            JiraRepositoryConnector.handleResponseException(e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        Object[] acls = JiraRepositoryConnector.getAcls(spec);
        if (acls != null) {
            Arrays.sort(acls);
        }
        for (String documentIdentifier : documentIdentifiers) {
            if (documentIdentifier.startsWith("I-")) {
                long fileLength;
                byte[] documentBytes;
                RepositoryDocument rd;
                String documentURI;
                Long fileSize;
                String errorDesc;
                String errorCode;
                long startTime;
                String versionString;
                block32: {
                    Date modifiedDate;
                    Date createdDate;
                    String mimeType;
                    Object[] aclsToUse;
                    JiraIssue jiraFile;
                    block31: {
                        block30: {
                            block29: {
                                String issueID = documentIdentifier.substring(2);
                                jiraFile = this.getIssue(issueID);
                                if (jiraFile == null) {
                                    activities.deleteDocument(documentIdentifier);
                                    continue;
                                }
                                Date rev = jiraFile.getUpdatedDate();
                                if (rev == null) {
                                    activities.deleteDocument(documentIdentifier);
                                    continue;
                                }
                                StringBuilder sb = new StringBuilder();
                                if (acls == null) {
                                    List<String> users = this.getUsers(issueID);
                                    aclsToUse = users.toArray(new String[0]);
                                    Arrays.sort(aclsToUse);
                                } else {
                                    aclsToUse = acls;
                                }
                                JiraRepositoryConnector.packList((StringBuilder)sb, (String[])aclsToUse, (char)'+');
                                if (aclsToUse.length > 0) {
                                    sb.append('+');
                                    JiraRepositoryConnector.pack((StringBuilder)sb, (String)defaultAuthorityDenyToken, (char)'+');
                                } else {
                                    sb.append('-');
                                }
                                sb.append(rev.toString());
                                versionString = sb.toString();
                                if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
                                if (Logging.connectors.isDebugEnabled()) {
                                    Logging.connectors.debug((Object)("JIRA: Processing document identifier '" + documentIdentifier + "'"));
                                }
                                startTime = System.currentTimeMillis();
                                errorCode = null;
                                errorDesc = null;
                                fileSize = null;
                                mimeType = "text/plain";
                                createdDate = jiraFile.getCreatedDate();
                                modifiedDate = jiraFile.getUpdatedDate();
                                documentURI = this.composeDocumentURI(this.getBaseUrl(this.session), jiraFile.getKey());
                                if (activities.checkURLIndexable(documentURI)) break block29;
                                errorCode = "EXCLUDEDURL";
                                errorDesc = "Excluded because of URL ('" + documentURI + "')";
                                activities.noDocument(documentIdentifier, versionString);
                                if (errorCode == null) continue;
                                activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, documentIdentifier, errorCode, errorDesc, null);
                                continue;
                            }
                            if (activities.checkMimeTypeIndexable(mimeType)) break block30;
                            errorCode = "EXCLUDEDMIMETYPE";
                            errorDesc = "Excluded because of mime type ('" + mimeType + "')";
                            activities.noDocument(documentIdentifier, versionString);
                            if (errorCode == null) continue;
                            activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, documentIdentifier, errorCode, errorDesc, null);
                            continue;
                        }
                        if (activities.checkDateIndexable(modifiedDate)) break block31;
                        errorCode = "EXCLUDEDDATE";
                        errorDesc = "Excluded because of date (" + modifiedDate + ")";
                        activities.noDocument(documentIdentifier, versionString);
                        if (errorCode == null) continue;
                        activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, documentIdentifier, errorCode, errorDesc, null);
                        continue;
                    }
                    rd = new RepositoryDocument();
                    String[] denyAclsToUse = aclsToUse.length > 0 ? new String[]{defaultAuthorityDenyToken} : new String[]{};
                    rd.setSecurity("document", (String[])aclsToUse, denyAclsToUse);
                    rd.setMimeType(mimeType);
                    if (createdDate != null) {
                        rd.setCreatedDate(createdDate);
                    }
                    if (modifiedDate != null) {
                        rd.setModifiedDate(modifiedDate);
                    }
                    rd.addField("webUrl", documentURI);
                    rd.addField("key", jiraFile.getKey());
                    rd.addField("self", jiraFile.getSelf());
                    rd.addField("description", jiraFile.getDescription());
                    Map<String, String[]> metadataMap = jiraFile.getMetadata();
                    for (Map.Entry<String, String[]> entry : metadataMap.entrySet()) {
                        rd.addField(entry.getKey(), entry.getValue());
                    }
                    String document = JiraRepositoryConnector.getJiraBody(jiraFile);
                    documentBytes = document.getBytes(StandardCharsets.UTF_8);
                    fileLength = documentBytes.length;
                    if (activities.checkLengthIndexable(fileLength)) break block32;
                    errorCode = "EXCLUDEDLENGTH";
                    errorDesc = "Excluded because of document length (" + fileLength + ")";
                    activities.noDocument(documentIdentifier, versionString);
                    if (errorCode == null) continue;
                    activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, documentIdentifier, errorCode, errorDesc, null);
                    continue;
                }
                try {
                    block33: {
                        try (ByteArrayInputStream is = new ByteArrayInputStream(documentBytes);){
                            rd.setBinary((InputStream)is, fileLength);
                            activities.ingestDocumentWithException(documentIdentifier, versionString, documentURI, rd);
                            errorCode = "OK";
                            fileSize = new Long(fileLength);
                            break block33;
                        }
                        {
                            catch (IOException e) {
                                errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                                errorDesc = e.getMessage();
                                JiraRepositoryConnector.handleIOException(e);
                            }
                        }
                    }
                    if (errorCode == null) continue;
                }
                catch (ManifoldCFException e) {
                    try {
                        if (e.getErrorCode() == 2) {
                            errorCode = null;
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (errorCode != null) {
                            activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, documentIdentifier, errorCode, errorDesc, null);
                        }
                        throw throwable;
                    }
                }
                activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, documentIdentifier, errorCode, errorDesc, null);
                continue;
            }
            activities.deleteDocument(documentIdentifier);
        }
    }

    protected static String getJiraBody(JiraIssue jiraFile) {
        String summary = jiraFile.getSummary();
        String description = jiraFile.getDescription();
        StringBuilder body = new StringBuilder();
        if (summary != null) {
            body.append(summary);
        }
        if (description != null) {
            if (body.length() > 0) {
                body.append(" : ");
            }
            body.append(description);
        }
        return body.toString();
    }

    private String composeDocumentURI(String baseUrl, String key) {
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        return baseUrl + "browse/" + key;
    }

    protected static String[] getAcls(Specification spec) {
        HashSet<String> map = new HashSet<String>();
        for (int i = 0; i < spec.getChildCount(); ++i) {
            String onOff;
            SpecificationNode sn = spec.getChild(i);
            if (sn.getType().equals(JOB_ACCESS_NODE_TYPE)) {
                String token = sn.getAttributeValue(JOB_TOKEN_ATTRIBUTE);
                map.add(token);
                continue;
            }
            if (!sn.getType().equals(JOB_SECURITY_NODE_TYPE) || (onOff = sn.getAttributeValue(JOB_VALUE_ATTRIBUTE)) == null || !onOff.equals("on")) continue;
            return null;
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.iterator();
        int i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    private static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        Logging.connectors.warn((Object)("JIRA: IO exception: " + e.getMessage()), (Throwable)e);
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    private static void handleResponseException(ResponseException e) throws ManifoldCFException, ServiceInterruption {
        throw new ManifoldCFException("Unexpected response: " + e.getMessage(), (Throwable)e);
    }

    protected List<String> getUsers(String issueKey) throws ManifoldCFException, ServiceInterruption {
        GetUsersThread t = new GetUsersThread(this.getSession(), issueKey);
        try {
            t.start();
            t.finishUp();
            return t.getResult();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (IOException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (ResponseException e) {
            JiraRepositoryConnector.handleResponseException(e);
        }
        return null;
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        CheckConnectionThread t = new CheckConnectionThread(this.getSession());
        try {
            t.start();
            t.finishUp();
            return;
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (IOException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (ResponseException e) {
            JiraRepositoryConnector.handleResponseException(e);
        }
    }

    protected JiraIssue getIssue(String issueID) throws ManifoldCFException, ServiceInterruption {
        GetIssueThread t = new GetIssueThread(this.getSession(), issueID);
        try {
            t.start();
            t.finishUp();
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (IOException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (ResponseException e) {
            JiraRepositoryConnector.handleResponseException(e);
        }
        return t.getResponse();
    }

    protected String getBaseUrl(JiraSession jiraSession) throws ManifoldCFException, ServiceInterruption {
        String url = "";
        try {
            url = jiraSession.getBaseUrl();
            return url;
        }
        catch (SocketTimeoutException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (IOException e) {
            JiraRepositoryConnector.handleIOException(e);
        }
        catch (ResponseException e) {
            JiraRepositoryConnector.handleResponseException(e);
        }
        return url;
    }

    protected static class GetIssueThread
    extends Thread {
        protected final JiraSession session;
        protected final String nodeId;
        protected Throwable exception = null;
        protected JiraIssue response = null;

        public GetIssueThread(JiraSession session, String nodeId) {
            this.setDaemon(true);
            this.session = session;
            this.nodeId = nodeId;
        }

        @Override
        public void run() {
            try {
                this.response = this.session.getIssue(this.nodeId);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public JiraIssue getResponse() {
            return this.response;
        }

        public void finishUp() throws InterruptedException, IOException, ResponseException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof ResponseException) {
                    throw (ResponseException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
    }

    protected static class GetSeedsThread
    extends Thread {
        protected Throwable exception = null;
        protected final JiraSession session;
        protected final String jiraDriveQuery;
        protected final XThreadStringBuffer seedBuffer;

        public GetSeedsThread(JiraSession session, String jiraDriveQuery) {
            this.session = session;
            this.jiraDriveQuery = jiraDriveQuery;
            this.seedBuffer = new XThreadStringBuffer();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.getSeeds(this.seedBuffer, this.jiraDriveQuery);
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.seedBuffer.signalDone();
            }
        }

        public XThreadStringBuffer getBuffer() {
            return this.seedBuffer;
        }

        public void finishUp() throws InterruptedException, IOException, ResponseException {
            this.seedBuffer.abandon();
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof ResponseException) {
                    throw (ResponseException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }
    }

    protected static class CheckConnectionThread
    extends Thread {
        protected final JiraSession session;
        protected Throwable exception = null;

        public CheckConnectionThread(JiraSession session) {
            this.session = session;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.session.getRepositoryInfo();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException, ResponseException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof ResponseException) {
                    throw (ResponseException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
    }

    protected static class GetUsersThread
    extends Thread {
        protected final JiraSession session;
        protected final String issueKey;
        protected Throwable exception = null;
        protected List<String> result = null;

        public GetUsersThread(JiraSession session, String issueKey) {
            this.session = session;
            this.issueKey = issueKey;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.result = this.session.getUsers(this.issueKey);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, IOException, ResponseException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof ResponseException) {
                    throw (ResponseException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }

        public List<String> getResult() {
            return this.result;
        }
    }
}

