/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.connectorcommon.fuzzyml;

import java.util.Locale;
import java.util.Map;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLFuzzyParseState;
import org.apache.manifoldcf.connectorcommon.fuzzyml.XMLParsingContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class XMLFuzzyHierarchicalParseState
extends XMLFuzzyParseState {
    protected XMLParsingContext currentContext = null;
    protected StringBuilder characterBuffer = new StringBuilder();
    protected boolean captureEscaped = false;
    protected static final int MAX_CHUNK_SIZE = 4096;

    public XMLFuzzyHierarchicalParseState() {
        this(true, true, true, true, true, true);
    }

    public XMLFuzzyHierarchicalParseState(boolean lowerCaseAttributes, boolean lowerCaseTags, boolean lowerCaseQAttributes, boolean lowerCaseQTags, boolean lowerCaseBTags, boolean lowerCaseEscapeTags) {
        super(lowerCaseAttributes, lowerCaseTags, lowerCaseQAttributes, lowerCaseQTags, lowerCaseBTags, lowerCaseEscapeTags);
    }

    public void setContext(XMLParsingContext context) {
        this.currentContext = context;
    }

    public XMLParsingContext getContext() {
        return this.currentContext;
    }

    public void cleanup() throws ManifoldCFException {
        if (this.currentContext != null) {
            this.currentContext.cleanup();
            this.currentContext = null;
        }
    }

    @Override
    protected boolean noteTagEx(String tagName, String nameSpace, String localName, Map<String, String> attributes) throws ManifoldCFException {
        this.flushCharacterBuffer();
        if (this.currentContext != null) {
            this.currentContext.startElement(nameSpace, localName, tagName, attributes);
        }
        return false;
    }

    @Override
    protected boolean noteEndTagEx(String tagName, String nameSpace, String localName) throws ManifoldCFException {
        this.flushCharacterBuffer();
        if (this.currentContext != null) {
            this.currentContext.endElement(nameSpace, localName, tagName);
        }
        return false;
    }

    @Override
    protected boolean noteNormalCharacter(char thisChar) throws ManifoldCFException {
        this.appendToCharacterBuffer(thisChar);
        return false;
    }

    protected void appendToCharacterBuffer(char thisChar) throws ManifoldCFException {
        this.characterBuffer.append(thisChar);
        if (this.characterBuffer.length() >= 4096) {
            this.flushCharacterBuffer();
        }
    }

    protected void flushCharacterBuffer() throws ManifoldCFException {
        if (this.characterBuffer.length() > 0) {
            if (this.currentContext != null) {
                this.currentContext.characters(this.characterBuffer.toString());
            }
            this.characterBuffer.setLength(0);
        }
    }

    @Override
    protected boolean noteEscapedEx(String token) throws ManifoldCFException {
        if (token.toLowerCase(Locale.ROOT).equals("cdata")) {
            this.captureEscaped = true;
        }
        return false;
    }

    @Override
    protected boolean noteEscapedCharacter(char thisChar) throws ManifoldCFException {
        if (this.captureEscaped) {
            this.appendToCharacterBuffer(thisChar);
        }
        return false;
    }

    @Override
    protected boolean noteEndEscaped() throws ManifoldCFException {
        this.captureEscaped = false;
        return false;
    }

    @Override
    public void finishUp() throws ManifoldCFException {
        this.flushCharacterBuffer();
        super.finishUp();
    }
}

