/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.common.DCTM;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.rmi.server.RMIServerSocketFactory;

public class RMILocalSocketFactory
implements RMIServerSocketFactory {
    public static final String _rcsid = "@(#)$Id: RMILocalSocketFactory.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static InetAddress loopbackAddress;

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return new LocalServerSocket(port);
    }

    public boolean equals(Object o) {
        return o instanceof RMILocalSocketFactory;
    }

    public int hashCode() {
        return 258473;
    }

    static {
        try {
            loopbackAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    protected static class LocalServerSocket
    extends ServerSocket {
        protected int currentPort;

        public LocalServerSocket(int port) throws IOException {
            super(port);
            this.currentPort = port;
        }

        @Override
        public void bind(SocketAddress endpoint) throws IOException {
            int thisPort = this.currentPort;
            if (endpoint instanceof InetSocketAddress) {
                thisPort = ((InetSocketAddress)endpoint).getPort();
            }
            endpoint = new InetSocketAddress(loopbackAddress, thisPort);
            super.bind(endpoint);
        }

        @Override
        public void bind(SocketAddress endpoint, int backlog) throws IOException {
            int thisPort = this.currentPort;
            if (endpoint instanceof InetSocketAddress) {
                thisPort = ((InetSocketAddress)endpoint).getPort();
            }
            endpoint = new InetSocketAddress(loopbackAddress, thisPort);
            super.bind(endpoint, backlog);
        }
    }
}

