/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

public enum IterationStrategy {
    ASCENDING(false),
    DESCENDING(false),
    BUFFER_SOURCE(true),
    BUFFER_TARGET(true);

    final boolean needBuffer;

    private IterationStrategy(boolean bl) {
        this.needBuffer = bl;
    }

    public static IterationStrategy suggest(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n5 <= 1) {
            return ASCENDING;
        }
        int n7 = Math.subtractExact(n, n3);
        if (n7 >= 0) {
            n6 = n2 - n4;
            if (n6 >= 0 || n7 >= Math.multiplyExact(1 - n5, n6)) {
                return ASCENDING;
            }
        } else {
            if ((n7 = Math.negateExact(n7)) >= Math.multiplyExact(n5, n2)) {
                return ASCENDING;
            }
            n6 = n2 - n4;
            if (n7 >= Math.multiplyExact(n5 - 1, n6)) {
                return DESCENDING;
            }
        }
        return n6 > 0 ? BUFFER_TARGET : BUFFER_SOURCE;
    }
}

