/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.common.DCTM;

import com.documentum.com.DfClientX;
import com.documentum.fc.client.DfAuthenticationException;
import com.documentum.fc.client.DfDocbaseUnreachableException;
import com.documentum.fc.client.DfIOException;
import com.documentum.fc.client.DfIdentityException;
import com.documentum.fc.client.DfQuery;
import com.documentum.fc.client.IDfClient;
import com.documentum.fc.client.IDfFolder;
import com.documentum.fc.client.IDfPersistentObject;
import com.documentum.fc.client.IDfSession;
import com.documentum.fc.client.IDfSessionManager;
import com.documentum.fc.client.IDfType;
import com.documentum.fc.common.DfException;
import com.documentum.fc.common.DfTime;
import com.documentum.fc.common.IDfLoginInfo;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Date;
import org.apache.manifoldcf.crawler.common.DCTM.DocumentumException;
import org.apache.manifoldcf.crawler.common.DCTM.DocumentumObjectImpl;
import org.apache.manifoldcf.crawler.common.DCTM.DocumentumResultImpl;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentum;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentumObject;
import org.apache.manifoldcf.crawler.common.DCTM.IDocumentumResult;
import org.apache.manifoldcf.crawler.common.DCTM.RMILocalClientSocketFactory;
import org.apache.manifoldcf.crawler.common.DCTM.RMILocalSocketFactory;

public class DocumentumImpl
extends UnicastRemoteObject
implements IDocumentum {
    public static final String _rcsid = "@(#)$Id: DocumentumImpl.java 988245 2010-08-23 18:39:35Z kwright $";
    protected String docBaseName = null;
    protected String userName = null;
    protected String password = null;
    protected String domain = null;
    protected IDfSessionManager sessionManager = null;
    protected IDfSession session = null;

    public DocumentumImpl() throws RemoteException {
        super(0, (RMIClientSocketFactory)new RMILocalClientSocketFactory(), (RMIServerSocketFactory)new RMILocalSocketFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IDfSession getSession() throws DocumentumException {
        if (this.session == null) {
            int retryCount = 5;
            while (true) {
                this.performSessionCreate();
                if (this.session != null && this.session.isConnected()) break;
                if (retryCount == 0) {
                    throw new DocumentumException("Connection attempt failed!");
                }
                --retryCount;
                try {
                    Integer x;
                    Integer n = x = new Integer(0);
                    synchronized (n) {
                        x.wait(1000L);
                        continue;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        return this.session;
    }

    public void createSession(String docBaseName, String userName, String password, String domain) throws DocumentumException, RemoteException {
        this.docBaseName = docBaseName;
        this.userName = userName;
        this.password = password;
        this.domain = domain;
        this.performSessionCreate();
    }

    protected void performSessionCreate() throws DocumentumException {
        try {
            DfClientX clientx = new DfClientX();
            IDfClient client = clientx.getLocalClient();
            IDfSessionManager localSessionManager = client.newSessionManager();
            IDfLoginInfo loginInfoObj = clientx.getLoginInfo();
            loginInfoObj.setUser(this.userName);
            loginInfoObj.setPassword(this.password);
            if (this.domain != null) {
                loginInfoObj.setDomain(this.domain);
            }
            localSessionManager.setIdentity(this.docBaseName, loginInfoObj);
            this.session = localSessionManager.getSession(this.docBaseName);
            this.sessionManager = localSessionManager;
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }

    public void destroySession() throws DocumentumException, RemoteException {
        if (this.session != null) {
            this.sessionManager.release(this.session);
            if (!this.session.isConnected()) {
                // empty if block
            }
            this.session = null;
            this.sessionManager = null;
        }
    }

    public void checkConnection() throws DocumentumException, RemoteException {
        this.getDocbaseName();
    }

    public String getDocbaseName() throws DocumentumException, RemoteException {
        IDfSession objIDfSession = this.getSession();
        try {
            return objIDfSession.getDocbaseName();
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }

    public String getServerVersion() throws DocumentumException, RemoteException {
        IDfSession objIDfSession = this.getSession();
        try {
            return objIDfSession.getServerVersion();
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }

    public String getSessionId() throws DocumentumException, RemoteException {
        IDfSession objIDfSession = this.getSession();
        try {
            return objIDfSession.getSessionId();
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }

    public IDocumentumResult performDQLQuery(String dql) throws DocumentumException, RemoteException {
        IDfSession objIDfSession = this.getSession();
        try {
            DfQuery objIDfQuery = new DfQuery();
            objIDfQuery.setDQL(dql);
            objIDfQuery.setBatchSize(2048);
            return new DocumentumResultImpl(objIDfQuery.execute(objIDfSession, 4));
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }

    public IDocumentumObject getObjectByQualification(String dql) throws DocumentumException, RemoteException {
        IDfSession objIDfSession = this.getSession();
        try {
            IDfPersistentObject o = objIDfSession.getObjectByQualification(dql);
            if (o == null) {
                return null;
            }
            return new DocumentumObjectImpl(objIDfSession, o);
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException dfe) {
            String errorMessage = dfe.getMessage();
            if (errorMessage.indexOf("[DM_CONTENT_E_CANT_START_PULL]") != -1) {
                throw new DocumentumException(dfe.getMessage(), 3);
            }
            if (errorMessage.indexOf("[DM_OBJECT_E_LOAD_INVALID_STRING_LEN]") != -1 || errorMessage.indexOf("[DM_PLATFORM_E_INTEGER_CONVERSION_ERROR]") != -1) {
                throw new DocumentumException(dfe.getMessage(), 5);
            }
            throw new DocumentumException(dfe.getMessage(), 0);
        }
    }

    public IDocumentumResult getFolderContents(String folderPath) throws DocumentumException, RemoteException {
        IDfSession objIDfSession = this.getSession();
        try {
            IDfFolder objTheParentFolderNode = (IDfFolder)objIDfSession.getObjectByPath(folderPath);
            if (objTheParentFolderNode == null) {
                return new DocumentumResultImpl(null);
            }
            return new DocumentumResultImpl(objTheParentFolderNode.getContents(null));
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }

    public boolean isOneOf(String theType, String[] matchTypeSet) throws DocumentumException, RemoteException {
        IDfSession objIDfSession = this.getSession();
        try {
            IDfType typeDescription = objIDfSession.getType(theType);
            int i = 0;
            while (i < matchTypeSet.length) {
                String matchType;
                if ((matchType = matchTypeSet[i++]).equalsIgnoreCase(theType)) {
                    return true;
                }
                if (!typeDescription.isSubTypeOf(matchType)) continue;
                return true;
            }
            return false;
        }
        catch (DfAuthenticationException ex) {
            throw new DocumentumException("Bad credentials: " + ex.getMessage(), 1);
        }
        catch (DfIdentityException ex) {
            throw new DocumentumException("Bad docbase name: " + ex.getMessage(), 2);
        }
        catch (DfDocbaseUnreachableException e) {
            throw new DocumentumException("Docbase unreachable: " + e.getMessage(), 0);
        }
        catch (DfIOException e) {
            throw new DocumentumException("Docbase io exception: " + e.getMessage(), 0);
        }
        catch (DfException e) {
            throw new DocumentumException("Documentum error: " + e.getMessage());
        }
    }

    public String buildDateString(long timestamp) throws RemoteException {
        return "date('" + new DfTime(new Date(timestamp)).asString("mm/dd/yyyy hh:mi:ss") + "','" + "mm/dd/yyyy hh:mi:ss" + "')";
    }
}

