/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public abstract class ResetManager {
    public static final String _rcsid = "@(#)$Id: ResetManager.java 988245 2010-08-23 18:39:35Z kwright $";
    protected final String processID;
    protected volatile boolean resetRequired = false;
    protected int involvedThreadCount = 0;
    protected volatile int waitingThreads = 0;

    public ResetManager(String processID) {
        this.processID = processID;
    }

    public synchronized void registerMe() {
        ++this.involvedThreadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteEvent() {
        ResetManager resetManager = this;
        synchronized (resetManager) {
            this.resetRequired = true;
        }
        this.performWakeupLogic();
    }

    public synchronized boolean waitForReset(IThreadContext tc) throws ManifoldCFException, InterruptedException {
        if (!this.resetRequired) {
            return false;
        }
        ++this.waitingThreads;
        if (this.waitingThreads == this.involvedThreadCount) {
            try {
                this.performResetLogic(tc, this.processID);
            }
            finally {
                this.waitingThreads = 0;
                this.resetRequired = false;
                this.notifyAll();
            }
            return true;
        }
        this.wait();
        return true;
    }

    protected abstract void performResetLogic(IThreadContext var1, String var2) throws ManifoldCFException;

    protected abstract void performWakeupLogic();
}

