/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.dropbox;

import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.RESTUtility;
import com.dropbox.client2.exception.DropboxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.XThreadInputStream;
import org.apache.manifoldcf.connectorcommon.common.XThreadStringBuffer;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.dropbox.DropboxSession;
import org.apache.manifoldcf.crawler.connectors.dropbox.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class DropboxRepositoryConnector
extends BaseRepositoryConnector {
    protected static final String ACTIVITY_READ = "read document";
    public static final String ACTIVITY_FETCH = "fetch";
    protected static final String RELATIONSHIP_CHILD = "child";
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    private static final String JOB_STARTPOINT_NODE_TYPE = "startpoint";
    private static final String JOB_PATH_ATTRIBUTE = "path";
    private static final String JOB_ACCESS_NODE_TYPE = "access";
    private static final String JOB_TOKEN_ATTRIBUTE = "token";
    private static final String DROPBOX_SERVER_TAB_PROPERTY = "DropboxRepositoryConnector.Server";
    private static final String DROPBOX_PATH_TAB_PROPERTY = "DropboxRepositoryConnector.DropboxPath";
    private static final String DROPBOX_SECURITY_TAB_PROPERTY = "DropboxRepositoryConnector.Security";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_Server.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration.html";
    private static final String EDIT_SPEC_HEADER_FORWARD = "editSpecification.js";
    private static final String EDIT_SPEC_FORWARD_DROPBOXPATH = "editSpecification_DropboxPath.html";
    private static final String EDIT_SPEC_FORWARD_SECURITY = "editSpecification_Security.html";
    private static final String VIEW_SPEC_FORWARD = "viewSpecification.html";
    protected String server = "dropbox";
    protected DropboxSession session = null;
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;
    protected String app_key = null;
    protected String app_secret = null;
    protected String key = null;
    protected String secret = null;

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH, ACTIVITY_READ};
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.server};
    }

    public void disconnect() throws ManifoldCFException {
        if (this.session != null) {
            this.session.close();
            this.session = null;
            this.lastSessionFetch = -1L;
        }
        this.app_key = null;
        this.app_secret = null;
        this.key = null;
        this.secret = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.app_key = this.params.getParameter("app_key");
        this.app_secret = this.params.getObfuscatedParameter("app_secret");
        this.key = this.params.getParameter("key");
        this.secret = this.params.getObfuscatedParameter("secret");
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        CheckConnectionThread t = new CheckConnectionThread();
        try {
            t.start();
            t.join();
            Throwable thr = t.getException();
            if (thr != null) {
                if (thr instanceof DropboxException) {
                    throw (DropboxException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
            return;
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (DropboxException e) {
            Logging.connectors.warn((Object)("DROPBOX: Error checking repository: " + e.getMessage()), (Throwable)e);
            DropboxRepositoryConnector.handleDropboxException(e);
            return;
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            if (StringUtils.isEmpty((String)this.app_key)) {
                throw new ManifoldCFException("Parameter app_key required but not set");
            }
            if (StringUtils.isEmpty((String)this.app_secret)) {
                throw new ManifoldCFException("Parameter app_secret required but not set");
            }
            if (StringUtils.isEmpty((String)this.key)) {
                throw new ManifoldCFException("Parameter key required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("DROPBOX: Username = '" + this.key + "'"));
            }
            if (StringUtils.isEmpty((String)this.secret)) {
                throw new ManifoldCFException("Parameter secret required but not set");
            }
            Logging.connectors.debug((Object)"DROPBOX: Password exists");
            this.session = new DropboxSession(this.app_key, this.app_secret, this.key, this.secret);
            this.lastSessionFetch = System.currentTimeMillis();
        }
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            this.session.close();
            this.session = null;
            this.lastSessionFetch = -1L;
        }
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public String[] getRelationshipTypes() {
        return new String[]{RELATIONSHIP_CHILD};
    }

    private static void fillInServerConfigurationMap(Map<String, Object> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String app_key = parameters.getParameter("app_key");
        String app_secret = parameters.getObfuscatedParameter("app_secret");
        String username = parameters.getParameter("key");
        String password = parameters.getObfuscatedParameter("secret");
        if (app_key == null) {
            app_key = "";
        }
        app_secret = app_secret == null ? "" : mapper.mapPasswordToKey(app_secret);
        if (username == null) {
            username = "";
        }
        password = password == null ? "" : mapper.mapPasswordToKey(password);
        newMap.put("APP_KEY", app_key);
        newMap.put("APP_SECRET", app_secret);
        newMap.put("KEY", username);
        newMap.put("SECRET", password);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DropboxRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, DROPBOX_SERVER_TAB_PROPERTY));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        DropboxRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        DropboxRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_SERVER, paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String secret;
        String key;
        String app_secret;
        String app_key = variableContext.getParameter("app_key");
        if (app_key != null) {
            parameters.setParameter("app_key", app_key);
        }
        if ((app_secret = variableContext.getParameter("app_secret")) != null) {
            parameters.setObfuscatedParameter("app_secret", variableContext.mapKeyToPassword(app_secret));
        }
        if ((key = variableContext.getParameter("key")) != null) {
            parameters.setParameter("key", key);
        }
        if ((secret = variableContext.getParameter("secret")) != null) {
            parameters.setObfuscatedParameter("secret", variableContext.mapKeyToPassword(secret));
        }
        return null;
    }

    private static void fillInDropboxPathSpecificationMap(Map<String, Object> newMap, Specification ds) {
        String DropboxPath = "/";
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
            DropboxPath = sn.getAttributeValue(JOB_PATH_ATTRIBUTE);
        }
        newMap.put("DROPBOXPATH", DropboxPath);
    }

    private static void fillInDropboxSecuritySpecificationMap(Map<String, Object> newMap, Specification ds) {
        ArrayList accessTokenList = new ArrayList();
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals(JOB_ACCESS_NODE_TYPE)) continue;
            String token = sn.getAttributeValue(JOB_TOKEN_ATTRIBUTE);
            HashMap<String, String> accessMap = new HashMap<String, String>();
            accessMap.put("TOKEN", token);
            accessTokenList.add(accessMap);
        }
        newMap.put("ACCESSTOKENS", accessTokenList);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        DropboxRepositoryConnector.fillInDropboxPathSpecificationMap(paramMap, ds);
        DropboxRepositoryConnector.fillInDropboxSecuritySpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPEC_FORWARD, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String xc;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String dropboxPath = variableContext.getParameter(seqPrefix + "dropboxpath");
        if (dropboxPath != null) {
            for (int i = 0; i < ds.getChildCount(); ++i) {
                SpecificationNode oldNode = ds.getChild(i);
                if (!oldNode.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
                ds.removeChild(i);
                break;
            }
            SpecificationNode node = new SpecificationNode(JOB_STARTPOINT_NODE_TYPE);
            node.setAttribute(JOB_PATH_ATTRIBUTE, dropboxPath);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals(JOB_ACCESS_NODE_TYPE)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode(JOB_ACCESS_NODE_TYPE);
                node.setAttribute(JOB_TOKEN_ATTRIBUTE, accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node = new SpecificationNode(JOB_ACCESS_NODE_TYPE);
                node.setAttribute(JOB_TOKEN_ATTRIBUTE, accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        DropboxRepositoryConnector.fillInDropboxPathSpecificationMap(paramMap, ds);
        DropboxRepositoryConnector.fillInDropboxSecuritySpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_DROPBOXPATH, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_SECURITY, paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, DROPBOX_PATH_TAB_PROPERTY));
        tabsArray.add(Messages.getString(locale, DROPBOX_SECURITY_TAB_PROPERTY));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        DropboxRepositoryConnector.fillInDropboxPathSpecificationMap(paramMap, ds);
        DropboxRepositoryConnector.fillInDropboxSecuritySpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_HEADER_FORWARD, paramMap);
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        String dropboxPath = "";
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
            dropboxPath = sn.getAttributeValue(JOB_PATH_ATTRIBUTE);
            break;
        }
        this.getSession();
        GetSeedsThread t = new GetSeedsThread(dropboxPath);
        try {
            t.start();
            boolean wasInterrupted = false;
            try {
                String docPath;
                XThreadStringBuffer seedBuffer = t.getBuffer();
                while ((docPath = seedBuffer.fetch()) != null) {
                    activities.addSeedDocument(docPath);
                }
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                throw e;
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    wasInterrupted = true;
                }
                throw e;
            }
            finally {
                if (!wasInterrupted) {
                    t.finishUp();
                }
            }
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (DropboxException e) {
            Logging.connectors.warn((Object)("DROPBOX: Error adding seed documents: " + e.getMessage()), (Throwable)e);
            DropboxRepositoryConnector.handleDropboxException(e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        Logging.connectors.debug((Object)"DROPBOX: Inside processDocuments");
        Object[] acls = DropboxRepositoryConnector.getAcls(spec);
        Arrays.sort(acls);
        for (String documentIdentifier : documentIdentifiers) {
            Date modifiedDate;
            String documentURI;
            long fileLength;
            String version;
            String nodeId;
            Long fileSize;
            String errorDesc;
            String errorCode;
            long startTime;
            DropboxAPI.Entry dropboxObject;
            block45: {
                String versionString;
                block44: {
                    block43: {
                        block42: {
                            this.getSession();
                            GetObjectThread objt = new GetObjectThread(documentIdentifier);
                            objt.start();
                            try {
                                objt.finishUp();
                            }
                            catch (InterruptedException e) {
                                objt.interrupt();
                                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                            }
                            catch (DropboxException e) {
                                Logging.connectors.warn((Object)("DROPBOX: Error getting object: " + e.getMessage()), (Throwable)e);
                                DropboxRepositoryConnector.handleDropboxException(e);
                            }
                            dropboxObject = objt.getResponse();
                            if (dropboxObject.isDir) {
                                versionString = "";
                                List children = dropboxObject.contents;
                                for (DropboxAPI.Entry child : children) {
                                    activities.addDocumentReference(child.path, documentIdentifier, RELATIONSHIP_CHILD);
                                }
                                activities.noDocument(documentIdentifier, versionString);
                                continue;
                            }
                            if (dropboxObject.isDeleted) {
                                activities.deleteDocument(documentIdentifier);
                                continue;
                            }
                            if (StringUtils.isEmpty((String)dropboxObject.rev)) {
                                activities.deleteDocument(documentIdentifier);
                                continue;
                            }
                            StringBuilder sb = new StringBuilder();
                            DropboxRepositoryConnector.packList((StringBuilder)sb, (String[])acls, (char)'+');
                            if (acls.length > 0) {
                                sb.append('+');
                                DropboxRepositoryConnector.pack((StringBuilder)sb, (String)defaultAuthorityDenyToken, (char)'+');
                            } else {
                                sb.append('-');
                            }
                            sb.append(dropboxObject.rev);
                            versionString = sb.toString();
                            if (!activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
                            startTime = System.currentTimeMillis();
                            errorCode = null;
                            errorDesc = null;
                            fileSize = null;
                            nodeId = documentIdentifier;
                            version = versionString;
                            fileLength = dropboxObject.bytes;
                            if (activities.checkLengthIndexable(fileLength)) break block42;
                            errorCode = "EXCLUDEDLENGTH";
                            errorDesc = "Document excluded because of length (" + fileLength + ")";
                            activities.noDocument(documentIdentifier, versionString);
                            if (errorCode == null) continue;
                            activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, nodeId, errorCode, errorDesc, null);
                            continue;
                        }
                        documentURI = dropboxObject.path;
                        if (activities.checkURLIndexable(documentURI)) break block43;
                        errorCode = "EXCLUDEDURL";
                        errorDesc = "Document excluded because of URL ('" + documentURI + "')";
                        activities.noDocument(documentIdentifier, versionString);
                        if (errorCode == null) continue;
                        activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, nodeId, errorCode, errorDesc, null);
                        continue;
                    }
                    modifiedDate = dropboxObject.modified != null ? RESTUtility.parseDate((String)dropboxObject.modified) : null;
                    if (activities.checkDateIndexable(modifiedDate)) break block44;
                    errorCode = "EXCLUDEDDATE";
                    errorDesc = "Document excluded because of date (" + modifiedDate + ")";
                    activities.noDocument(documentIdentifier, versionString);
                    if (errorCode == null) continue;
                    activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, nodeId, errorCode, errorDesc, null);
                    continue;
                }
                String mimeType = dropboxObject.mimeType;
                if (activities.checkMimeTypeIndexable(mimeType)) break block45;
                errorCode = "EXCLUDEDMIMETYPE";
                errorDesc = "Document excluded because of mime type ('" + mimeType + "')";
                activities.noDocument(documentIdentifier, versionString);
                if (errorCode == null) continue;
                activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, nodeId, errorCode, errorDesc, null);
                continue;
            }
            try {
                RepositoryDocument rd = new RepositoryDocument();
                if (acls.length > 0) {
                    rd.setSecurityACL("document", (String[])acls);
                    String[] denyAclArray = new String[]{defaultAuthorityDenyToken};
                    rd.setSecurityDenyACL("document", denyAclArray);
                }
                if (dropboxObject.path != null) {
                    rd.setFileName(dropboxObject.path);
                }
                if (dropboxObject.mimeType != null) {
                    rd.setMimeType(dropboxObject.mimeType);
                }
                if (dropboxObject.modified != null) {
                    rd.setModifiedDate(modifiedDate);
                }
                rd.addField("Modified", dropboxObject.modified);
                rd.addField("Size", dropboxObject.size);
                rd.addField("Path", dropboxObject.path);
                rd.addField("Root", dropboxObject.root);
                rd.addField("ClientMtime", dropboxObject.clientMtime);
                rd.addField("mimeType", dropboxObject.mimeType);
                rd.addField("rev", dropboxObject.rev);
                this.getSession();
                BackgroundStreamThread t = new BackgroundStreamThread(nodeId);
                t.start();
                try {
                    boolean wasInterrupted = false;
                    try (InputStream is = t.getSafeInputStream();){
                        rd.setBinary(is, fileLength);
                        activities.ingestDocumentWithException(nodeId, version, documentURI, rd);
                        errorCode = "OK";
                        fileSize = new Long(fileLength);
                    }
                    catch (SocketTimeoutException e) {
                        throw e;
                    }
                    catch (InterruptedIOException e) {
                        wasInterrupted = true;
                        throw e;
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() == 2) {
                            wasInterrupted = true;
                        }
                        throw e;
                    }
                    finally {
                        if (!wasInterrupted) {
                            t.finishUp();
                        }
                    }
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (SocketTimeoutException e) {
                    errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                    errorDesc = e.getMessage();
                    DropboxRepositoryConnector.handleIOException(e);
                }
                catch (InterruptedIOException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                }
                catch (IOException e) {
                    errorCode = e.getClass().getSimpleName().toUpperCase(Locale.ROOT);
                    errorDesc = e.getMessage();
                    DropboxRepositoryConnector.handleIOException(e);
                }
                catch (DropboxException e) {
                    Logging.connectors.warn((Object)("DROPBOX: Error getting stream: " + e.getMessage()), (Throwable)e);
                    errorCode = ((Object)((Object)e)).getClass().getSimpleName().toUpperCase(Locale.ROOT);
                    errorDesc = e.getMessage();
                    DropboxRepositoryConnector.handleDropboxException(e);
                }
                if (errorCode == null) continue;
            }
            catch (ManifoldCFException e) {
                try {
                    if (e.getErrorCode() == 2) {
                        errorCode = null;
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (errorCode != null) {
                        activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, nodeId, errorCode, errorDesc, null);
                    }
                    throw throwable;
                }
            }
            activities.recordActivity(new Long(startTime), ACTIVITY_READ, fileSize, nodeId, errorCode, errorDesc, null);
        }
    }

    protected static String[] getAcls(Specification spec) {
        HashSet<String> map = new HashSet<String>();
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals(JOB_ACCESS_NODE_TYPE)) continue;
            String token = sn.getAttributeValue(JOB_TOKEN_ATTRIBUTE);
            map.add(token);
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.iterator();
        int i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    protected static void handleDropboxException(DropboxException e) throws ManifoldCFException, ServiceInterruption {
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("Dropbox exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    protected static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    protected class BackgroundStreamThread
    extends Thread {
        protected final String nodeId;
        protected boolean abortThread = false;
        protected Throwable responseException = null;
        protected InputStream sourceStream = null;
        protected XThreadInputStream threadStream = null;

        public BackgroundStreamThread(String nodeId) {
            this.setDaemon(true);
            this.nodeId = nodeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    BackgroundStreamThread backgroundStreamThread = this;
                    synchronized (backgroundStreamThread) {
                        if (!this.abortThread) {
                            this.sourceStream = DropboxRepositoryConnector.this.session.getDropboxInputStream(this.nodeId);
                            this.threadStream = new XThreadInputStream(this.sourceStream);
                            this.notifyAll();
                        }
                    }
                    if (this.threadStream != null) {
                        this.threadStream.stuffQueue();
                    }
                }
                finally {
                    if (this.sourceStream != null) {
                        this.sourceStream.close();
                    }
                }
            }
            catch (Throwable e) {
                this.responseException = e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream getSafeInputStream() throws InterruptedException, IOException, DropboxException {
            while (true) {
                BackgroundStreamThread backgroundStreamThread = this;
                synchronized (backgroundStreamThread) {
                    if (this.responseException != null) {
                        throw new IllegalStateException("Check for response before getting stream");
                    }
                    this.checkException(this.responseException);
                    if (this.threadStream != null) {
                        return this.threadStream;
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishUp() throws InterruptedException, IOException, DropboxException {
            BackgroundStreamThread backgroundStreamThread = this;
            synchronized (backgroundStreamThread) {
                if (this.threadStream != null) {
                    this.threadStream.abort();
                }
                this.abortThread = true;
            }
            this.join();
            this.checkException(this.responseException);
        }

        protected synchronized void checkException(Throwable exception) throws IOException, DropboxException {
            if (exception != null) {
                Throwable e = exception;
                if (e instanceof DropboxException) {
                    throw (DropboxException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unhandled exception of type: " + e.getClass().getName(), e);
            }
        }
    }

    protected class GetObjectThread
    extends Thread {
        protected final String nodeId;
        protected Throwable exception = null;
        protected DropboxAPI.Entry response = null;

        public GetObjectThread(String nodeId) {
            this.setDaemon(true);
            this.nodeId = nodeId;
        }

        @Override
        public void run() {
            try {
                this.response = DropboxRepositoryConnector.this.session.getObject(this.nodeId);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public void finishUp() throws InterruptedException, DropboxException {
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof DropboxException) {
                    throw (DropboxException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }

        public DropboxAPI.Entry getResponse() {
            return this.response;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class GetSeedsThread
    extends Thread {
        protected Throwable exception = null;
        protected final String path;
        protected final XThreadStringBuffer seedBuffer;

        public GetSeedsThread(String path) {
            this.path = path;
            this.seedBuffer = new XThreadStringBuffer();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                DropboxRepositoryConnector.this.session.getSeeds(this.seedBuffer, this.path, 25000);
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.seedBuffer.signalDone();
            }
        }

        public XThreadStringBuffer getBuffer() {
            return this.seedBuffer;
        }

        public void finishUp() throws InterruptedException, DropboxException {
            this.seedBuffer.abandon();
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof DropboxException) {
                    throw (DropboxException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }
    }

    protected class CheckConnectionThread
    extends Thread {
        protected Throwable exception = null;

        public CheckConnectionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                DropboxRepositoryConnector.this.session.getRepositoryInfo();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

