/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.tools;

import java.util.Arrays;
import java.util.Properties;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

public class ProducerPerformance {
    private static final long NS_PER_MS = 1000000L;
    private static final long NS_PER_SEC = 1000000000L;
    private static final long MIN_SLEEP_NS = 2000000L;

    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            System.err.println("USAGE: java " + ProducerPerformance.class.getName() + " topic_name num_records record_size target_records_sec [prop_name=prop_value]*");
            System.exit(1);
        }
        String topicName = args[0];
        long numRecords = Long.parseLong(args[1]);
        int recordSize = Integer.parseInt(args[2]);
        int throughput = Integer.parseInt(args[3]);
        Properties props = new Properties();
        for (int i = 4; i < args.length; ++i) {
            String[] pieces = args[i].split("=");
            if (pieces.length != 2) {
                throw new IllegalArgumentException("Invalid property: " + args[i]);
            }
            props.put(pieces[0], pieces[1]);
        }
        props.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        KafkaProducer producer = new KafkaProducer(props);
        byte[] payload = new byte[recordSize];
        Arrays.fill(payload, (byte)1);
        ProducerRecord record = new ProducerRecord(topicName, payload);
        long sleepTime = 1000000000L / (long)throughput;
        long sleepDeficitNs = 0L;
        Stats stats = new Stats(numRecords, 5000);
        int i = 0;
        while ((long)i < numRecords) {
            long sendStart = System.currentTimeMillis();
            Callback cb = stats.nextCompletion(sendStart, payload.length, stats);
            producer.send(record, cb);
            if (throughput > 0 && (sleepDeficitNs += sleepTime) >= 2000000L) {
                long sleepMs = sleepDeficitNs / 1000000L;
                long sleepNs = sleepDeficitNs - sleepMs * 1000000L;
                Thread.sleep(sleepMs, (int)sleepNs);
                sleepDeficitNs = 0L;
            }
            ++i;
        }
        producer.close();
        stats.printTotal();
    }

    private static final class PerfCallback
    implements Callback {
        private final long start;
        private final int iteration;
        private final int bytes;
        private final Stats stats;

        public PerfCallback(int iter, long start, int bytes, Stats stats) {
            this.start = start;
            this.stats = stats;
            this.iteration = iter;
            this.bytes = bytes;
        }

        @Override
        public void onCompletion(RecordMetadata metadata, Exception exception) {
            long now = System.currentTimeMillis();
            int latency = (int)(now - this.start);
            this.stats.record(this.iteration, latency, this.bytes, now);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    private static class Stats {
        private long start = System.currentTimeMillis();
        private long windowStart = System.currentTimeMillis();
        private int[] latencies;
        private int sampling;
        private int iteration = 0;
        private int index = 0;
        private long count;
        private long bytes;
        private int maxLatency;
        private long totalLatency;
        private long windowCount;
        private int windowMaxLatency;
        private long windowTotalLatency;
        private long windowBytes;
        private long reportingInterval;

        public Stats(long numRecords, int reportingInterval) {
            this.sampling = (int)(numRecords / Math.min(numRecords, 500000L));
            this.latencies = new int[(int)(numRecords / (long)this.sampling) + 1];
            this.index = 0;
            this.maxLatency = 0;
            this.totalLatency = 0L;
            this.windowCount = 0L;
            this.windowMaxLatency = 0;
            this.windowTotalLatency = 0L;
            this.windowBytes = 0L;
            this.totalLatency = 0L;
            this.reportingInterval = reportingInterval;
        }

        public void record(int iter, int latency, int bytes, long time) {
            ++this.count;
            this.bytes += (long)bytes;
            this.totalLatency += (long)latency;
            this.maxLatency = Math.max(this.maxLatency, latency);
            ++this.windowCount;
            this.windowBytes += (long)bytes;
            this.windowTotalLatency += (long)latency;
            this.windowMaxLatency = Math.max(this.windowMaxLatency, latency);
            if (iter % this.sampling == 0) {
                this.latencies[this.index] = latency;
                ++this.index;
            }
            if (time - this.windowStart >= this.reportingInterval) {
                this.printWindow();
                this.newWindow();
            }
        }

        public Callback nextCompletion(long start, int bytes, Stats stats) {
            PerfCallback cb = new PerfCallback(this.iteration, start, bytes, stats);
            ++this.iteration;
            return cb;
        }

        public void printWindow() {
            long ellapsed = System.currentTimeMillis() - this.windowStart;
            double recsPerSec = 1000.0 * (double)this.windowCount / (double)ellapsed;
            double mbPerSec = 1000.0 * (double)this.windowBytes / (double)ellapsed / 1048576.0;
            System.out.printf("%d records sent, %.1f records/sec (%.2f MB/sec), %.1f ms avg latency, %.1f max latency.\n", this.windowCount, recsPerSec, mbPerSec, (double)this.windowTotalLatency / (double)this.windowCount, (double)this.windowMaxLatency);
        }

        public void newWindow() {
            this.windowStart = System.currentTimeMillis();
            this.windowCount = 0L;
            this.windowMaxLatency = 0;
            this.windowTotalLatency = 0L;
            this.windowBytes = 0L;
        }

        public void printTotal() {
            long ellapsed = System.currentTimeMillis() - this.start;
            double recsPerSec = 1000.0 * (double)this.count / (double)ellapsed;
            double mbPerSec = 1000.0 * (double)this.bytes / (double)ellapsed / 1048576.0;
            int[] percs = Stats.percentiles(this.latencies, this.index, 0.5, 0.95, 0.99, 0.999);
            System.out.printf("%d records sent, %f records/sec (%.2f MB/sec), %.2f ms avg latency, %.2f ms max latency, %d ms 50th, %d ms 95th, %d ms 99th, %d ms 99.9th.\n", this.count, recsPerSec, mbPerSec, (double)this.totalLatency / (double)this.count, (double)this.maxLatency, percs[0], percs[1], percs[2], percs[3]);
        }

        private static int[] percentiles(int[] latencies, int count, double ... percentiles) {
            int size = Math.min(count, latencies.length);
            Arrays.sort(latencies, 0, size);
            int[] values = new int[percentiles.length];
            for (int i = 0; i < percentiles.length; ++i) {
                int index = (int)(percentiles[i] * (double)size);
                values[i] = latencies[index];
            }
            return values;
        }
    }
}

