/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.parser;

import java.util.LinkedList;
import java.util.List;
import org.apache.jsieve.ScriptCoordinate;
import org.apache.jsieve.parser.generated.Token;

public class SieveNode {
    private Token firstToken;
    private Token lastToken;
    private String fieldName;
    private Object fieldValue;

    public String getName() {
        return this.fieldName;
    }

    public Object getValue() {
        return this.fieldValue;
    }

    public void setName(String name) {
        this.fieldName = name;
    }

    public void setValue(Object value) {
        this.fieldValue = value;
    }

    public Token getFirstToken() {
        return this.firstToken;
    }

    public void setFirstToken(Token firstToken) {
        this.firstToken = firstToken;
    }

    public Token getLastToken() {
        return this.lastToken;
    }

    public void setLastToken(Token lastToken) {
        this.lastToken = lastToken;
    }

    public ScriptCoordinate getCoordinate() {
        int lastColumn = this.lastToken.endColumn;
        int lastList = this.lastToken.endLine;
        int firstColumn = this.firstToken.beginColumn;
        int firstLine = this.firstToken.beginLine;
        return new ScriptCoordinate(firstLine, firstColumn, lastList, lastColumn);
    }

    public List<String> getPrecedingComments() {
        LinkedList<String> results = new LinkedList<String>();
        if (this.firstToken != null) {
            Token special = this.firstToken.specialToken;
            while (special != null) {
                String comment = this.parseComment(special);
                results.addFirst(comment);
                special = special.specialToken;
            }
        }
        return results;
    }

    private String parseComment(Token special) {
        String comment;
        String image = special.image;
        if ('#' == image.charAt(0)) {
            int leftHandCharactersToIgnore = '\r' == image.charAt(image.length() - 2) ? 2 : 1;
            comment = image.substring(1, image.length() - leftHandCharactersToIgnore);
        } else {
            comment = image.substring(2, image.length() - 2);
        }
        return comment;
    }

    public String getLastComment() {
        Token special;
        String result = this.firstToken == null ? null : ((special = this.firstToken.specialToken) == null ? null : this.parseComment(special));
        return result;
    }
}

