/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.cassandra.migration;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.backends.cassandra.migration.Migration;
import org.apache.james.backends.cassandra.migration.MigrationException;
import org.apache.james.rrt.cassandra.CassandraMappingsSourcesDAO;
import org.apache.james.rrt.cassandra.CassandraRecipientRewriteTableDAO;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class MappingsSourcesMigration
implements Migration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingsSourcesMigration.class);
    public static final TaskType TYPE = TaskType.of((String)"mappings-sources-migration");
    private final CassandraRecipientRewriteTableDAO cassandraRecipientRewriteTableDAO;
    private final CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO;
    private final AtomicLong successfulMappingsCount;
    private final AtomicLong errorMappingsCount;

    @Inject
    public MappingsSourcesMigration(CassandraRecipientRewriteTableDAO cassandraRecipientRewriteTableDAO, CassandraMappingsSourcesDAO cassandraMappingsSourcesDAO) {
        this.cassandraRecipientRewriteTableDAO = cassandraRecipientRewriteTableDAO;
        this.cassandraMappingsSourcesDAO = cassandraMappingsSourcesDAO;
        this.successfulMappingsCount = new AtomicLong(0L);
        this.errorMappingsCount = new AtomicLong(0L);
    }

    public void apply() {
        this.cassandraRecipientRewriteTableDAO.getAllMappings().flatMap(this::migrate, 16).then(Mono.fromRunnable(() -> {
            if (this.errorMappingsCount.get() > 0L) {
                throw new MigrationException("MappingsSourcesMigration failed");
            }
        })).doOnError(t -> LOGGER.error("Error while migrating mappings sources", t)).block();
    }

    private Mono<Void> migrate(Pair<MappingSource, Mapping> mappingEntry) {
        return this.cassandraMappingsSourcesDAO.addMapping((Mapping)mappingEntry.getRight(), (MappingSource)mappingEntry.getLeft()).then(Mono.fromCallable(this.successfulMappingsCount::incrementAndGet)).then().onErrorResume(t -> {
            LOGGER.error("Error while performing migration of mapping source: {} with mapping: {}", new Object[]{((MappingSource)mappingEntry.getLeft()).asString(), ((Mapping)mappingEntry.getRight()).asString(), t});
            this.errorMappingsCount.incrementAndGet();
            return Mono.empty();
        });
    }

    public Task asTask() {
        return new MappingsSourcesMigrationTask(this);
    }

    AdditionalInformation createAdditionalInformation() {
        return new AdditionalInformation(this.successfulMappingsCount.get(), this.errorMappingsCount.get(), Clock.systemUTC().instant());
    }

    public static class MappingsSourcesMigrationTask
    implements Task {
        private final MappingsSourcesMigration migration;

        public MappingsSourcesMigrationTask(MappingsSourcesMigration migration) {
            this.migration = migration;
        }

        public Task.Result run() throws InterruptedException {
            return this.migration.runTask();
        }

        public TaskType type() {
            return TYPE;
        }

        public Optional<TaskExecutionDetails.AdditionalInformation> details() {
            return Optional.of(this.migration.createAdditionalInformation());
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final long successfulMappingsCount;
        private final long errorMappingsCount;
        private final Instant timestamp;

        AdditionalInformation(long successfulMappingsCount, long errorMappingsCount, Instant timestamp) {
            this.successfulMappingsCount = successfulMappingsCount;
            this.errorMappingsCount = errorMappingsCount;
            this.timestamp = timestamp;
        }

        public long getSuccessfulMappingsCount() {
            return this.successfulMappingsCount;
        }

        public long getErrorMappingsCount() {
            return this.errorMappingsCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

