/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.mailet.filter;

import com.google.common.annotations.VisibleForTesting;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.api.filtering.Rule;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.mailet.Mail;
import org.apache.mailet.StorageDirective;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionApplier {
    static final String DELIVERY_PATH_PREFIX = "DeliveryPath_";
    public static final Logger LOGGER = LoggerFactory.getLogger(ActionApplier.class);
    private final MailboxManager mailboxManager;
    private final MailboxId.Factory mailboxIdFactory;
    private final Mail mail;
    private final Username username;

    @VisibleForTesting
    public static Factory factory(MailboxManager mailboxManager, MailboxId.Factory mailboxIdFactory) {
        return new Factory(mailboxManager, mailboxIdFactory);
    }

    private ActionApplier(MailboxManager mailboxManager, MailboxId.Factory mailboxIdFactory, Mail mail, Username username) {
        this.mailboxManager = mailboxManager;
        this.mailboxIdFactory = mailboxIdFactory;
        this.mail = mail;
        this.username = username;
    }

    public void apply(Stream<Rule.Action> actions) {
        actions.flatMap(action -> action.getAppendInMailboxes().getMailboxIds().stream()).map(arg_0 -> ((MailboxId.Factory)this.mailboxIdFactory).fromString(arg_0)).forEach(this::addStorageDirective);
    }

    private void addStorageDirective(MailboxId mailboxId) {
        try {
            MailboxSession mailboxSession = this.mailboxManager.createSystemSession(this.username);
            MessageManager messageManager = this.mailboxManager.getMailbox(mailboxId, mailboxSession);
            String mailboxName = messageManager.getMailboxPath().getName();
            StorageDirective.builder().targetFolder(mailboxName).build().encodeAsAttributes(this.username).forEach(arg_0 -> ((Mail)this.mail).setAttribute(arg_0));
        }
        catch (MailboxNotFoundException e) {
            LOGGER.info("Mailbox {} does not exist, but it was mentioned in a JMAP filtering rule", (Object)mailboxId, (Object)e);
        }
        catch (Exception e) {
            LOGGER.error("Unexpected failure while resolving mailbox name for {}", (Object)mailboxId, (Object)e);
        }
    }

    @VisibleForTesting
    static class Factory {
        private final MailboxManager mailboxManager;
        private final MailboxId.Factory mailboxIdFactory;

        @Inject
        Factory(MailboxManager mailboxManager, MailboxId.Factory mailboxIdFactory) {
            this.mailboxManager = mailboxManager;
            this.mailboxIdFactory = mailboxIdFactory;
        }

        public RequireUser forMail(Mail mail) {
            return new RequireUser(mail);
        }

        public class RequireUser {
            private final Mail mail;

            RequireUser(Mail mail) {
                this.mail = mail;
            }

            public ActionApplier forUser(Username username) {
                return new ActionApplier(Factory.this.mailboxManager, Factory.this.mailboxIdFactory, this.mail, username);
            }
        }
    }
}

