/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.methods;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.github.fge.lambdas.Throwing;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.jmap.draft.json.ObjectMapperFactory;
import org.apache.james.jmap.draft.methods.JmapResponse;
import org.apache.james.jmap.draft.methods.JmapResponseWriter;
import org.apache.james.jmap.draft.model.InvocationResponse;
import org.apache.james.jmap.draft.model.Property;
import reactor.core.publisher.Flux;

public class JmapResponseWriterImpl
implements JmapResponseWriter {
    public static final String PROPERTIES_FILTER = "propertiesFilter";
    private final ObjectMapper objectMapper;
    private final Cache<Long, CachedObjectMapper> writerCache;

    @Inject
    public JmapResponseWriterImpl(ObjectMapperFactory objectMapperFactory) {
        this.objectMapper = objectMapperFactory.forWriting();
        this.writerCache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(Duration.ofMinutes(15L)).build();
    }

    @Override
    public Flux<InvocationResponse> formatMethodResponse(Flux<JmapResponse> jmapResponses) {
        return jmapResponses.map((Function)Throwing.function(jmapResponse -> {
            ObjectMapper objectMapper = this.retrieveObjectMapperFromCache((JmapResponse)jmapResponse).cachedMapperIfApplicable((JmapResponse)jmapResponse).orElseGet(() -> this.newConfiguredObjectMapper((JmapResponse)jmapResponse));
            return new InvocationResponse(jmapResponse.getResponseName(), (ObjectNode)objectMapper.valueToTree((Object)jmapResponse.getResponse()), jmapResponse.getMethodCallId());
        }));
    }

    private CachedObjectMapper retrieveObjectMapperFromCache(JmapResponse jmapResponse) throws ExecutionException {
        return (CachedObjectMapper)this.writerCache.get((Object)this.computeCachingKey(jmapResponse), () -> new CachedObjectMapper(this.newConfiguredObjectMapper(jmapResponse), jmapResponse.getProperties(), jmapResponse.getFilterProvider().map(Pair::getKey)));
    }

    private ObjectMapper newConfiguredObjectMapper(JmapResponse jmapResponse) {
        SimpleFilterProvider filterProvider = jmapResponse.getFilterProvider().map(Pair::getValue).orElseGet(SimpleFilterProvider::new).setDefaultFilter(SimpleBeanPropertyFilter.serializeAll()).addFilter(PROPERTIES_FILTER, this.getPropertiesFilter(jmapResponse.getProperties()));
        return this.objectMapper.copy().setFilterProvider((FilterProvider)filterProvider);
    }

    private long computeCachingKey(JmapResponse jmapResponse) {
        long lowBits = jmapResponse.getProperties().hashCode();
        long highBits = jmapResponse.getFilterProvider().map(Pair::getKey).map(Object::hashCode).map(i -> (long)i).orElse(Long.valueOf(jmapResponse.getResponseName().hashCode()));
        return lowBits + (highBits >> 32);
    }

    private PropertyFilter getPropertiesFilter(Optional<? extends Set<? extends Property>> properties) {
        return (PropertyFilter)properties.map(this::toFieldNames).map(SimpleBeanPropertyFilter::filterOutAllExcept).orElse(SimpleBeanPropertyFilter.serializeAll());
    }

    private Set<String> toFieldNames(Set<? extends Property> properties) {
        return (Set)properties.stream().map(Property::asFieldName).collect(ImmutableSet.toImmutableSet());
    }

    private static class CachedObjectMapper {
        private final ObjectMapper objectMapper;
        private final Optional<? extends Set<? extends Property>> properties;
        private final Optional<? extends Set<? extends Property>> subProperties;

        private CachedObjectMapper(ObjectMapper objectMapper, Optional<? extends Set<? extends Property>> properties, Optional<? extends Set<? extends Property>> subProperties) {
            this.objectMapper = objectMapper;
            this.properties = properties;
            this.subProperties = subProperties;
        }

        Optional<ObjectMapper> cachedMapperIfApplicable(JmapResponse jmapResponse) {
            if (jmapResponse.getProperties().equals(this.properties) && jmapResponse.getFilterProvider().map(Pair::getKey).equals(this.subProperties)) {
                return Optional.of(this.objectMapper);
            }
            return Optional.empty();
        }
    }
}

