/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.request.ImapRequest;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.api.process.SelectedMailbox;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.AbstractMessageRangeRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MessageRangeException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UidValidity;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractMessageRangeProcessor<R extends AbstractMessageRangeRequest>
extends AbstractMailboxProcessor<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessageRangeProcessor.class);

    public AbstractMessageRangeProcessor(Class<R> acceptableClass, MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(acceptableClass, mailboxManager, factory, metricFactory);
    }

    protected abstract Flux<MessageRange> process(MailboxId var1, SelectedMailbox var2, MailboxSession var3, MessageRange var4);

    protected abstract String getOperationName();

    @Override
    protected Mono<Void> processRequestReactive(R request, ImapSession session, ImapProcessor.Responder responder) {
        MailboxPath targetMailbox = PathConverter.forSession(session).buildFullPath(((AbstractMessageRangeRequest)request).getMailboxName());
        MailboxSession mailboxSession = session.getMailboxSession();
        return Mono.from((Publisher)this.getMailboxManager().mailboxExists(targetMailbox, mailboxSession)).flatMap(targetExists -> {
            if (!targetExists.booleanValue()) {
                this.no((ImapRequest)request, responder, HumanReadableText.FAILURE_NO_SUCH_MAILBOX, StatusResponse.ResponseCode.tryCreate());
                return Mono.empty();
            }
            return this.handleRanges(request, session, targetMailbox, mailboxSession).flatMap(code -> this.unsolicitedResponses(session, responder, request.isUseUids()).then(Mono.fromRunnable(() -> this.okComplete((ImapRequest)request, (StatusResponse.ResponseCode)code, responder))));
        }).onErrorResume(MessageRangeException.class, e -> {
            this.taggedBad((ImapRequest)request, responder, HumanReadableText.INVALID_MESSAGESET);
            return ReactorUtils.logAsMono(() -> LOGGER.debug("{} failed from mailbox {} to {} for invalid sequence-set {}", new Object[]{this.getOperationName(), session.getSelected().getMailboxId(), targetMailbox, request.getIdSet(), e}));
        }).onErrorResume(MailboxException.class, e -> {
            this.no((ImapRequest)request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
            return ReactorUtils.logAsMono(() -> LOGGER.error("{} failed from mailbox {} to {} for sequence-set {}", new Object[]{this.getOperationName(), session.getSelected().getMailboxId(), targetMailbox, request.getIdSet(), e.getCause()}));
        }).then();
    }

    private Mono<StatusResponse.ResponseCode> handleRanges(R request, ImapSession session, MailboxPath targetMailbox, MailboxSession mailboxSession) {
        return Mono.from((Publisher)this.getMailboxManager().getMailboxReactive(targetMailbox, mailboxSession)).flatMap(target -> {
            try {
                UidValidity uidValidity = target.getMailboxEntity().getUidValidity();
                return Flux.fromArray((Object[])request.getIdSet()).map(Throwing.function(range -> this.messageRange(session.getSelected(), (IdRange)range, request.isUseUids())).sneakyThrow()).filter(Objects::nonNull).concatMap(range -> this.process(target.getId(), session.getSelected(), mailboxSession, (MessageRange)range).map(IdRange::from)).collect(ImmutableList.toImmutableList()).map(IdRange::mergeRanges).map(ranges -> StatusResponse.ResponseCode.copyUid(uidValidity, request.getIdSet(), (IdRange[])ranges.toArray(IdRange[]::new)));
            }
            catch (MailboxException e) {
                return Mono.error((Throwable)e);
            }
        });
    }
}

