/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.github.fge.lambdas.Throwing;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ACLUsernameChangeTaskStep
implements UsernameChangeTaskStep {
    private final MailboxManager mailboxManager;
    private final SubscriptionManager subscriptionManager;

    @Inject
    public ACLUsernameChangeTaskStep(MailboxManager mailboxManager, SubscriptionManager subscriptionManager) {
        this.mailboxManager = mailboxManager;
        this.subscriptionManager = subscriptionManager;
    }

    public UsernameChangeTaskStep.StepName name() {
        return new UsernameChangeTaskStep.StepName("ACLUsernameChangeTaskStep");
    }

    public int priority() {
        return 3;
    }

    public Publisher<Void> changeUsername(Username oldUsername, Username newUsername) {
        MailboxSession oldSession = this.mailboxManager.createSystemSession(oldUsername);
        MailboxSession newSession = this.mailboxManager.createSystemSession(newUsername);
        return this.mailboxManager.search(MailboxQuery.builder().matchesAllMailboxNames().build(), oldSession).filter(mailbox -> !mailbox.getPath().getUser().equals((Object)oldUsername)).concatMap(mailbox -> this.migrateACLs(oldUsername, newUsername, (MailboxMetaData)mailbox)).then(this.updateSubscriptionsOnDeletedMailboxes(oldUsername, oldSession, newSession));
    }

    private Mono<Void> updateSubscriptionsOnDeletedMailboxes(Username oldUsername, MailboxSession oldSession, MailboxSession newSession) {
        try {
            return Flux.from((Publisher)this.subscriptionManager.subscriptionsReactive(oldSession)).filter(subscription -> !subscription.getUser().equals((Object)oldUsername)).concatMap(subscription -> Mono.from((Publisher)this.subscriptionManager.subscribeReactive(subscription, newSession)).then(Mono.from((Publisher)this.subscriptionManager.unsubscribeReactive(subscription, oldSession)))).then();
        }
        catch (SubscriptionException e) {
            return Mono.error((Throwable)e);
        }
    }

    private Publisher<? extends Void> migrateACLs(Username oldUsername, Username newUsername, MailboxMetaData mailbox) {
        MailboxSession ownerSession = this.mailboxManager.createSystemSession(mailbox.getPath().getUser());
        MailboxACL.Rfc4314Rights rights = Optional.ofNullable((MailboxACL.Rfc4314Rights)mailbox.getMailbox().getACL().getEntries().get(MailboxACL.EntryKey.createUserEntryKey((Username)oldUsername))).orElse(MailboxACL.NO_RIGHTS);
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.mailboxManager.applyRightsCommand(mailbox.getId(), MailboxACL.command().rights(rights).forUser(newUsername).asAddition(), ownerSession))).then(Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.mailboxManager.applyRightsCommand(mailbox.getId(), MailboxACL.command().rights(rights).forUser(oldUsername).asRemoval(), ownerSession)))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).then();
    }
}

