/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.base.MoreObjects;
import io.vavr.control.Try;
import java.io.FileNotFoundException;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.blob.aes.CryptoConfig;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.modules.mailbox.ConfigurationComponent;
import org.apache.james.server.blob.deduplication.StorageStrategy;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.filesystem.FileSystemImpl;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class BlobStoreConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreConfiguration.class);
    static final String ENCRYPTION_ENABLE_PROPERTY = "encryption.aes.enable";
    static final String ENCRYPTION_PASSWORD_PROPERTY = "encryption.aes.password";
    static final String ENCRYPTION_SALT_PROPERTY = "encryption.aes.salt";
    static final String ENCRYPTION_PRIVATE_KEY_ALGORITHM_PROPERTY = "encryption.aes.private.key.algorithm";
    static final String DEDUPLICATION_ENABLE_PROPERTY = "deduplication.enable";
    private final StorageStrategy storageStrategy;
    private final Optional<CryptoConfig> cryptoConfig;

    public static RequireStoringStrategy builder() {
        return storageStrategy -> cryptoConfig -> new BlobStoreConfiguration(storageStrategy, cryptoConfig);
    }

    public static BlobStoreConfiguration parse(Configuration configuration) throws ConfigurationException {
        PropertiesProvider propertiesProvider = new PropertiesProvider((FileSystem)new FileSystemImpl(configuration.directories()), configuration.configurationPath());
        return BlobStoreConfiguration.parse(propertiesProvider);
    }

    public static BlobStoreConfiguration parse(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            org.apache.commons.configuration2.Configuration configuration = propertiesProvider.getConfigurations(ConfigurationComponent.NAMES);
            return BlobStoreConfiguration.from(configuration);
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Could not find blob configuration file, using deduplicating blobstore as the default");
            return BlobStoreConfiguration.builder().deduplication().noCryptoConfig();
        }
    }

    static BlobStoreConfiguration from(org.apache.commons.configuration2.Configuration configuration) {
        boolean deduplicationEnabled = (Boolean)Try.ofCallable(() -> configuration.getBoolean(DEDUPLICATION_ENABLE_PROPERTY)).getOrElseThrow(() -> new IllegalStateException("deduplication.enable property is missing please use one of the supported values in: true, false\nIf you choose to enable deduplication, the mails with the same content will be stored only once.\nWarning: Once this feature is enabled, there is no turning back as turning it off will lead to the deletion of all\nthe mails sharing the same content once one is deleted.\nUpgrade note: If you are upgrading from James 3.5 or older, the deduplication was enabled."));
        Optional<CryptoConfig> cryptoConfig = BlobStoreConfiguration.parseCryptoConfig(configuration);
        if (deduplicationEnabled) {
            return BlobStoreConfiguration.builder().deduplication().cryptoConfig(cryptoConfig);
        }
        return BlobStoreConfiguration.builder().passthrough().cryptoConfig(cryptoConfig);
    }

    private static Optional<CryptoConfig> parseCryptoConfig(org.apache.commons.configuration2.Configuration configuration) {
        boolean enabled = configuration.getBoolean(ENCRYPTION_ENABLE_PROPERTY, false);
        if (enabled) {
            return Optional.of(CryptoConfig.builder().password((char[])Optional.ofNullable(configuration.getString(ENCRYPTION_PASSWORD_PROPERTY, null)).map(String::toCharArray).orElse(null)).salt(configuration.getString(ENCRYPTION_SALT_PROPERTY, null)).privateKeyAlgorithm(Optional.ofNullable(configuration.getString(ENCRYPTION_PRIVATE_KEY_ALGORITHM_PROPERTY, null))).build());
        }
        return Optional.empty();
    }

    BlobStoreConfiguration(StorageStrategy storageStrategy, Optional<CryptoConfig> cryptoConfig) {
        this.storageStrategy = storageStrategy;
        this.cryptoConfig = cryptoConfig;
    }

    public StorageStrategy storageStrategy() {
        return this.storageStrategy;
    }

    public Optional<CryptoConfig> getCryptoConfig() {
        return this.cryptoConfig;
    }

    public final boolean equals(Object o) {
        if (o instanceof BlobStoreConfiguration) {
            BlobStoreConfiguration that = (BlobStoreConfiguration)o;
            return Objects.equals(this.storageStrategy, that.storageStrategy) && Objects.equals(this.cryptoConfig, that.cryptoConfig);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.storageStrategy, this.cryptoConfig);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("storageStrategy", (Object)this.storageStrategy.name()).add("cryptoConfig", this.cryptoConfig).toString();
    }

    @FunctionalInterface
    public static interface RequireStoringStrategy {
        public RequireCryptoConfig strategy(StorageStrategy var1);

        default public RequireCryptoConfig passthrough() {
            return this.strategy(StorageStrategy.PASSTHROUGH);
        }

        default public RequireCryptoConfig deduplication() {
            return this.strategy(StorageStrategy.DEDUPLICATION);
        }
    }

    @FunctionalInterface
    public static interface RequireCryptoConfig {
        public BlobStoreConfiguration cryptoConfig(Optional<CryptoConfig> var1);

        default public BlobStoreConfiguration noCryptoConfig() {
            return this.cryptoConfig(Optional.empty());
        }

        default public BlobStoreConfiguration cryptoConfig(CryptoConfig cryptoConfig) {
            return this.cryptoConfig(Optional.of(cryptoConfig));
        }
    }
}

