/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.mail.MessagingException;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailetcontainer.impl.MatcherMailetPair;
import org.apache.james.mailetcontainer.impl.MatcherSplitter;
import org.apache.james.mailetcontainer.impl.ProcessorImpl;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailetProcessorImpl
extends AbstractStateMailetProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailetProcessorImpl.class);
    private final MetricFactory metricFactory;
    private List<MatcherMailetPair> pairs;
    private Map<MatcherSplitter, ProcessorImpl> pairsToBeProcessed;

    public MailetProcessorImpl(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    public void service(Mail mail) {
        ProcessingStep lastStep = this.pairsToBeProcessed.entrySet().stream().reduce(ProcessingStep.initial(mail), (processingStep, pair) -> {
            if (processingStep.test()) {
                return this.executeProcessingStep((ProcessingStep)processingStep, (Map.Entry<MatcherSplitter, ProcessorImpl>)pair);
            }
            return processingStep;
        }, (a, b) -> {
            throw new NotImplementedException("Fold left implementation. Should never be called.");
        });
        lastStep.ghostInFlight(nonGhostedTerminalMail -> {
            if (!"error".equals(mail.getState())) {
                LOGGER.warn("Message {} reached the end of this processor, and is automatically deleted. This may indicate a configuration error.", (Object)mail.getName());
                mail.setState("ghost");
            }
        });
        lastStep.disposeGhostedEncounteredMails();
    }

    private ProcessingStep executeProcessingStep(ProcessingStep step, Map.Entry<MatcherSplitter, ProcessorImpl> pair) {
        MatcherSplitter matcherSplitter = pair.getKey();
        ProcessorImpl processor = pair.getValue();
        ImmutableList afterMatching = (ImmutableList)step.getInFlightMails().stream().flatMap(Throwing.function(mail -> matcherSplitter.split((Mail)mail).stream()).sneakyThrow()).collect(ImmutableList.toImmutableList());
        afterMatching.stream().filter(mail -> mail.removeAttribute(MatcherSplitter.MATCHER_MATCHED_ATTRIBUTE).isPresent()).forEach(Throwing.consumer(processor::process).sneakyThrow());
        afterMatching.stream().filter(mail -> !mail.getState().equals(this.getState())).filter(mail -> !mail.getState().equals("ghost")).forEach(Throwing.consumer(x$0 -> this.toProcessor((Mail)x$0)).sneakyThrow());
        return step.nextStepBuilder().inFlight((ImmutableList<Mail>)((ImmutableList)afterMatching.stream().filter(mail -> mail.getState().equals(this.getState())).collect(ImmutableList.toImmutableList()))).encountered((ImmutableList<Mail>)afterMatching);
    }

    public List<MatcherMailetPair> getPairs() {
        return ImmutableList.copyOf(this.pairs);
    }

    protected String getEndpoint() {
        return "direct:processor." + this.getState();
    }

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
    }

    @Override
    protected void setupRouting(List<MatcherMailetPair> pairs) throws MessagingException {
        try {
            this.pairs = pairs;
            this.pairsToBeProcessed = (Map)pairs.stream().map(pair -> Pair.of((Object)new MatcherSplitter(this.metricFactory, this, (MatcherMailetPair)pair), (Object)new ProcessorImpl(this.metricFactory, this, pair.getMailet()))).collect(ImmutableMap.toImmutableMap(Pair::getKey, Pair::getValue));
        }
        catch (Exception e) {
            throw new MessagingException("Unable to setup routing for MailetMatcherPairs", e);
        }
    }

    private static class ProcessingStep {
        private ImmutableList<Mail> inFlightMails;
        private ImmutableSet<Mail> encounteredMails;

        public static ProcessingStep initial(Mail mail) {
            return new ProcessingStep((ImmutableList<Mail>)ImmutableList.of((Object)mail), (ImmutableSet<Mail>)ImmutableSet.of((Object)mail));
        }

        private ProcessingStep(ImmutableList<Mail> inFlightMails, ImmutableSet<Mail> encounteredMails) {
            this.inFlightMails = inFlightMails;
            this.encounteredMails = encounteredMails;
        }

        public ImmutableList<Mail> getInFlightMails() {
            return this.inFlightMails;
        }

        public Builder.RequiresInFlight nextStepBuilder() {
            return inFlight -> encountered -> new ProcessingStep((ImmutableList<Mail>)inFlight, (ImmutableSet<Mail>)ImmutableSet.builder().addAll((Iterable)inFlight).addAll(this.encounteredMails).addAll((Iterable)encountered).build());
        }

        public void ghostInFlight(Consumer<Mail> callback) {
            this.inFlightMails.stream().filter(mail -> !mail.getState().equals("ghost")).forEach(mail -> {
                callback.accept((Mail)mail);
                mail.setState("ghost");
            });
        }

        public void disposeGhostedEncounteredMails() {
            this.encounteredMails.stream().filter(mail -> mail.getState().equals("ghost")).forEach(Throwing.consumer(mail -> {
                LifecycleUtil.dispose((Object)mail);
                LifecycleUtil.dispose((Object)mail.getMessage());
            }).sneakyThrow());
        }

        public boolean test() {
            return this.inFlightMails.size() > 0;
        }

        private static class Builder {
            private Builder() {
            }

            @FunctionalInterface
            static interface RequiresEncounteredMails {
                public ProcessingStep encountered(ImmutableList<Mail> var1);
            }

            @FunctionalInterface
            static interface RequiresInFlight {
                public RequiresEncounteredMails inFlight(ImmutableList<Mail> var1);
            }
        }
    }
}

