/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.listener;

import com.unboundid.ldap.listener.InMemoryPasswordEncoder;
import com.unboundid.ldap.listener.PasswordEncoderOutputFormatter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Arrays;
import java.util.List;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ClearInMemoryPasswordEncoder
extends InMemoryPasswordEncoder {
    public ClearInMemoryPasswordEncoder(@NotNull String prefix, @Nullable PasswordEncoderOutputFormatter outputFormatter) {
        super(prefix, outputFormatter);
    }

    @Override
    @NotNull
    protected byte[] encodePassword(@NotNull byte[] clearPassword, @NotNull ReadOnlyEntry userEntry, @NotNull List<Modification> modifications) throws LDAPException {
        return clearPassword;
    }

    @Override
    protected void ensurePreEncodedPasswordAppearsValid(@NotNull byte[] unPrefixedUnFormattedEncodedPasswordBytes, @NotNull ReadOnlyEntry userEntry, @NotNull List<Modification> modifications) throws LDAPException {
    }

    @Override
    protected boolean passwordMatches(@NotNull byte[] clearPasswordBytes, @NotNull byte[] unPrefixedUnFormattedEncodedPasswordBytes, @NotNull ReadOnlyEntry userEntry) throws LDAPException {
        return Arrays.equals(clearPasswordBytes, unPrefixedUnFormattedEncodedPasswordBytes);
    }

    @Override
    @NotNull
    protected byte[] extractClearPassword(@NotNull byte[] unPrefixedUnFormattedEncodedPasswordBytes, @NotNull ReadOnlyEntry userEntry) throws LDAPException {
        return unPrefixedUnFormattedEncodedPasswordBytes;
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ClearInMemoryPasswordEncoder(prefix='");
        buffer.append(this.getPrefix());
        buffer.append("', outputFormatter=");
        PasswordEncoderOutputFormatter outputFormatter = this.getOutputFormatter();
        if (outputFormatter == null) {
            buffer.append("null");
        } else {
            outputFormatter.toString(buffer);
        }
        buffer.append(')');
    }
}

