/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.james.core.Username;

public class MailboxSession {
    public static long SYSTEM_SESSION_ID = 0L;
    private final Collection<String> sharedSpaces;
    private final String otherUsersSpace;
    private final String personalSpace;
    private final SessionId sessionId;
    private final Username userName;
    private boolean open = true;
    private final List<Locale> localePreferences;
    private final Map<Object, Object> attributes;
    private final char pathSeparator;
    private final SessionType type;

    public MailboxSession(SessionId sessionId, Username userName, List<Locale> localePreferences, char pathSeparator, SessionType type) {
        this(sessionId, userName, localePreferences, new ArrayList<String>(), null, pathSeparator, type);
    }

    public MailboxSession(SessionId sessionId, Username userName, List<Locale> localePreferences, List<String> sharedSpaces, String otherUsersSpace, char pathSeparator, SessionType type) {
        this.sessionId = sessionId;
        this.userName = userName;
        this.otherUsersSpace = otherUsersSpace;
        this.sharedSpaces = sharedSpaces;
        this.type = type;
        this.personalSpace = otherUsersSpace == null && (sharedSpaces == null || sharedSpaces.isEmpty()) ? "" : "#private";
        this.localePreferences = localePreferences;
        this.attributes = new HashMap<Object, Object>();
        this.pathSeparator = pathSeparator;
    }

    public SessionType getType() {
        return this.type;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.open = false;
    }

    public Username getUser() {
        return this.userName;
    }

    public List<Locale> getLocalePreferences() {
        return this.localePreferences;
    }

    public String getPersonalSpace() {
        return this.personalSpace;
    }

    public String getOtherUsersSpace() {
        return this.otherUsersSpace;
    }

    public Collection<String> getSharedSpaces() {
        return this.sharedSpaces;
    }

    public Map<Object, Object> getAttributes() {
        return this.attributes;
    }

    public char getPathDelimiter() {
        return this.pathSeparator;
    }

    public String toString() {
        String tab = " ";
        return "MailboxSession ( sessionId = " + this.sessionId + tab + "open = " + this.open + tab + " )";
    }

    public static class SessionId {
        private final long sessionId;

        public static SessionId of(long sessionId) {
            return new SessionId(sessionId);
        }

        private SessionId(long sessionId) {
            this.sessionId = sessionId;
        }

        public long getValue() {
            return this.sessionId;
        }

        public final boolean equals(Object o) {
            if (o instanceof SessionId) {
                SessionId that = (SessionId)o;
                return Objects.equals(this.sessionId, that.sessionId);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.sessionId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("sessionId", this.sessionId).toString();
        }
    }

    public static enum SessionType {
        System,
        User;

    }
}

