/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.commons.shaded.johnzon.core;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Map;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonBuilderFactoryImpl;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonGeneratorFactoryImpl;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonParserFactoryImpl;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonReaderFactoryImpl;
import org.apache.activemq.artemis.commons.shaded.johnzon.core.JsonWriterFactoryImpl;
import org.apache.activemq.artemis.commons.shaded.json.JsonArrayBuilder;
import org.apache.activemq.artemis.commons.shaded.json.JsonBuilderFactory;
import org.apache.activemq.artemis.commons.shaded.json.JsonObjectBuilder;
import org.apache.activemq.artemis.commons.shaded.json.JsonReader;
import org.apache.activemq.artemis.commons.shaded.json.JsonReaderFactory;
import org.apache.activemq.artemis.commons.shaded.json.JsonWriter;
import org.apache.activemq.artemis.commons.shaded.json.JsonWriterFactory;
import org.apache.activemq.artemis.commons.shaded.json.spi.JsonProvider;
import org.apache.activemq.artemis.commons.shaded.json.stream.JsonGenerator;
import org.apache.activemq.artemis.commons.shaded.json.stream.JsonGeneratorFactory;
import org.apache.activemq.artemis.commons.shaded.json.stream.JsonParser;
import org.apache.activemq.artemis.commons.shaded.json.stream.JsonParserFactory;

public class JsonProviderImpl
extends JsonProvider
implements Serializable {
    private static final JsonProvider DELEGATE = new JsonProviderDelegate();

    @Override
    public JsonParser createParser(Reader reader) {
        return DELEGATE.createParser(reader);
    }

    @Override
    public JsonParser createParser(InputStream inputStream) {
        return DELEGATE.createParser(inputStream);
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> stringMap) {
        return DELEGATE.createParserFactory(stringMap);
    }

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return DELEGATE.createGenerator(writer);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream) {
        return DELEGATE.createGenerator(outputStream);
    }

    @Override
    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> stringMap) {
        return DELEGATE.createGeneratorFactory(stringMap);
    }

    @Override
    public JsonReader createReader(Reader reader) {
        return DELEGATE.createReader(reader);
    }

    @Override
    public JsonReader createReader(InputStream inputStream) {
        return DELEGATE.createReader(inputStream);
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return DELEGATE.createWriter(writer);
    }

    @Override
    public JsonWriter createWriter(OutputStream outputStream) {
        return DELEGATE.createWriter(outputStream);
    }

    @Override
    public JsonWriterFactory createWriterFactory(Map<String, ?> stringMap) {
        return DELEGATE.createWriterFactory(stringMap);
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> stringMap) {
        return DELEGATE.createReaderFactory(stringMap);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return DELEGATE.createObjectBuilder();
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return DELEGATE.createArrayBuilder();
    }

    @Override
    public JsonBuilderFactory createBuilderFactory(Map<String, ?> stringMap) {
        return DELEGATE.createBuilderFactory(stringMap);
    }

    static class JsonProviderDelegate
    extends JsonProvider {
        private final JsonReaderFactory readerFactory = new JsonReaderFactoryImpl(null);
        private final JsonParserFactory parserFactory = new JsonParserFactoryImpl(null);
        private final JsonGeneratorFactory generatorFactory = new JsonGeneratorFactoryImpl(null);
        private final JsonWriterFactory writerFactory = new JsonWriterFactoryImpl(null);
        private final JsonBuilderFactory builderFactory = new JsonBuilderFactoryImpl(null);

        JsonProviderDelegate() {
        }

        @Override
        public JsonParser createParser(InputStream in) {
            return this.parserFactory.createParser(in);
        }

        @Override
        public JsonParser createParser(Reader reader) {
            return this.parserFactory.createParser(reader);
        }

        @Override
        public JsonReader createReader(InputStream in) {
            return this.readerFactory.createReader(in);
        }

        @Override
        public JsonReader createReader(Reader reader) {
            return this.readerFactory.createReader(reader);
        }

        @Override
        public JsonParserFactory createParserFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.parserFactory : new JsonParserFactoryImpl(config);
        }

        @Override
        public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.readerFactory : new JsonReaderFactoryImpl(config);
        }

        @Override
        public JsonGenerator createGenerator(Writer writer) {
            return this.generatorFactory.createGenerator(writer);
        }

        @Override
        public JsonGenerator createGenerator(OutputStream out) {
            return this.generatorFactory.createGenerator(out);
        }

        @Override
        public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.generatorFactory : new JsonGeneratorFactoryImpl(config);
        }

        @Override
        public JsonWriter createWriter(Writer writer) {
            return this.writerFactory.createWriter(writer);
        }

        @Override
        public JsonWriter createWriter(OutputStream out) {
            return this.writerFactory.createWriter(out);
        }

        @Override
        public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.writerFactory : new JsonWriterFactoryImpl(config);
        }

        @Override
        public JsonObjectBuilder createObjectBuilder() {
            return this.builderFactory.createObjectBuilder();
        }

        @Override
        public JsonArrayBuilder createArrayBuilder() {
            return this.builderFactory.createArrayBuilder();
        }

        @Override
        public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
            return config == null || config.isEmpty() ? this.builderFactory : new JsonBuilderFactoryImpl(config);
        }
    }
}

