/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.rabbitmq;

import com.github.fge.lambdas.Throwing;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ShutdownNotifier;
import java.io.IOException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.james.backends.rabbitmq.RabbitMQConnectionFactory;
import org.apache.james.backends.rabbitmq.RabbitMQServerVersion;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.retry.Retry;

public class SimpleConnectionPool
implements AutoCloseable,
Startable {
    public static final Logger LOGGER = LoggerFactory.getLogger(SimpleConnectionPool.class);
    private final AtomicReference<Connection> connectionReference;
    private final RabbitMQConnectionFactory connectionFactory;
    private final Configuration configuration;
    private Set<ReconnectionHandler> reconnectionHandlers;

    @Inject
    public SimpleConnectionPool(RabbitMQConnectionFactory factory, Configuration configuration) {
        this.connectionFactory = factory;
        this.reconnectionHandlers = new HashSet<ReconnectionHandler>();
        this.configuration = configuration;
        this.connectionReference = new AtomicReference();
    }

    public void init(Set<ReconnectionHandler> reconnectionHandlers) {
        this.reconnectionHandlers = reconnectionHandlers;
    }

    @Override
    @PreDestroy
    public void close() {
        Optional.ofNullable(this.connectionReference.get()).filter(ShutdownNotifier::isOpen).ifPresent(Throwing.consumer(Connection::close).orDoNothing());
    }

    public Mono<Connection> getResilientConnection() {
        return Mono.defer(this::getOpenConnection).retryWhen((Retry)Retry.backoff((long)this.configuration.getNumRetries(), (Duration)this.configuration.getInitialDelay()).scheduler(Schedulers.elastic()));
    }

    private Mono<Connection> getOpenConnection() {
        Connection previous = this.connectionReference.get();
        Connection current = Optional.ofNullable(previous).filter(ShutdownNotifier::isOpen).orElseGet(this.connectionFactory::create);
        boolean updated = this.connectionReference.compareAndSet(previous, current);
        if (updated) {
            if (previous != null && previous != current) {
                LOGGER.warn("Replacing current RabbitMQ connection...");
                return Flux.fromIterable(this.reconnectionHandlers).concatMap(handler -> handler.handleReconnection(current)).then().thenReturn((Object)current);
            }
            return Mono.just((Object)current);
        }
        try {
            current.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Mono.error((Throwable)new RuntimeException("unable to create and register a new Connection"));
    }

    public Mono<Boolean> tryConnection() {
        return this.getOpenConnection().timeout(Duration.ofSeconds(1L)).hasElement().onErrorResume(any -> Mono.just((Object)false));
    }

    public Mono<RabbitMQServerVersion> version() {
        return this.getOpenConnection().map(Connection::getServerProperties).map(serverProperties -> Optional.ofNullable(serverProperties.get("version"))).handle(ReactorUtils.publishIfPresent()).map(Object::toString).map(RabbitMQServerVersion::of).timeout(Duration.ofSeconds(1L)).onErrorResume(any -> Mono.empty());
    }

    public static class Configuration {
        public static final Configuration DEFAULT = Configuration.builder().retries(10).initialDelay(Duration.ofMillis(100L));
        private final int numRetries;
        private final Duration initialDelay;

        public static RequiresRetries builder() {
            return retries -> initialDelay -> new Configuration(retries, initialDelay);
        }

        public static Configuration from(org.apache.commons.configuration2.Configuration configuration) {
            return Configuration.builder().retries(configuration.getInt("connection.pool.retries", 10)).initialDelay(Duration.ofMillis(configuration.getLong("connection.pool.min.delay.ms", 100L)));
        }

        public Configuration(int numRetries, Duration initialDelay) {
            this.numRetries = numRetries;
            this.initialDelay = initialDelay;
        }

        public int getNumRetries() {
            return this.numRetries;
        }

        public Duration getInitialDelay() {
            return this.initialDelay;
        }

        @FunctionalInterface
        public static interface RequiresRetries {
            public RequiresInitialDelay retries(int var1);
        }

        @FunctionalInterface
        public static interface RequiresInitialDelay {
            public Configuration initialDelay(Duration var1);
        }
    }

    public static interface ReconnectionHandler {
        public Publisher<Void> handleReconnection(Connection var1);
    }
}

