/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.mail.Flags;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.ThreadId;

public class SearchQuery {
    private static final String DATE_HEADER_NAME = "Date";
    private final ImmutableList<Criterion> criteria;
    private final ImmutableList<Sort> sorts;
    private final ImmutableSet<MessageUid> recentMessageUids;

    public static Criterion sizeLessThan(long value) {
        return new SizeCriterion(new NumericOperator(value, NumericComparator.LESS_THAN));
    }

    public static Criterion sizeGreaterThan(long value) {
        return new SizeCriterion(new NumericOperator(value, NumericComparator.GREATER_THAN));
    }

    public static Criterion sizeEquals(long value) {
        return new SizeCriterion(new NumericOperator(value, NumericComparator.EQUALS));
    }

    public static Criterion modSeqLessThan(long value) {
        return new ModSeqCriterion(new NumericOperator(value, NumericComparator.LESS_THAN));
    }

    public static Criterion modSeqGreaterThan(long value) {
        return new ModSeqCriterion(new NumericOperator(value, NumericComparator.GREATER_THAN));
    }

    public static Criterion modSeqEquals(long value) {
        return new ModSeqCriterion(new NumericOperator(value, NumericComparator.EQUALS));
    }

    public static Criterion internalDateAfter(Date date, DateResolution dateResolution) {
        return new InternalDateCriterion(new DateOperator(DateComparator.AFTER, date, dateResolution));
    }

    public static Criterion internalDateOn(Date date, DateResolution dateResolution) {
        return new InternalDateCriterion(new DateOperator(DateComparator.ON, date, dateResolution));
    }

    public static Criterion internalDateBefore(Date date, DateResolution dateResolution) {
        return new InternalDateCriterion(new DateOperator(DateComparator.BEFORE, date, dateResolution));
    }

    public static Criterion sentDateAfter(Date date, DateResolution dateResolution) {
        return SearchQuery.headerDateAfter(DATE_HEADER_NAME, date, dateResolution);
    }

    public static Criterion sentDateOn(Date date, DateResolution dateResolution) {
        return SearchQuery.headerDateOn(DATE_HEADER_NAME, date, dateResolution);
    }

    public static Criterion sentDateBefore(Date date, DateResolution dateResolution) {
        return SearchQuery.headerDateBefore(DATE_HEADER_NAME, date, dateResolution);
    }

    public static Criterion headerDateAfter(String headerName, Date date, DateResolution dateResolution) {
        return new HeaderCriterion(headerName, new DateOperator(DateComparator.AFTER, date, dateResolution));
    }

    public static Criterion headerDateOn(String headerName, Date date, DateResolution dateResolution) {
        return new HeaderCriterion(headerName, new DateOperator(DateComparator.ON, date, dateResolution));
    }

    public static Criterion headerDateBefore(String headerName, Date date, DateResolution dateResolution) {
        return new HeaderCriterion(headerName, new DateOperator(DateComparator.BEFORE, date, dateResolution));
    }

    public static Criterion address(AddressType type, String address) {
        return new HeaderCriterion(type.name(), new AddressOperator(address));
    }

    public static Criterion headerContains(String headerName, String value) {
        if (value == null || value.length() == 0) {
            return SearchQuery.headerExists(headerName);
        }
        return new HeaderCriterion(headerName, new ContainsOperator(value));
    }

    public static Criterion headerExists(String headerName) {
        return new HeaderCriterion(headerName, ExistsOperator.exists());
    }

    public static Criterion mailContains(String value) {
        return new TextCriterion(value, Scope.FULL);
    }

    public static Criterion bodyContains(String value) {
        return new TextCriterion(value, Scope.BODY);
    }

    public static Criterion attachmentContains(String value) {
        return new TextCriterion(value, Scope.ATTACHMENTS);
    }

    public static Criterion uid(UidRange ... range) {
        return new UidCriterion(range);
    }

    public static Criterion or(Criterion one, Criterion two) {
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(one);
        criteria.add(two);
        return new ConjunctionCriterion(Conjunction.OR, criteria);
    }

    public static Criterion or(List<Criterion> criteria) {
        return new ConjunctionCriterion(Conjunction.OR, criteria);
    }

    public static Criterion and(Criterion one, Criterion two) {
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(one);
        criteria.add(two);
        return new ConjunctionCriterion(Conjunction.AND, criteria);
    }

    public static Criterion and(List<Criterion> criteria) {
        return new ConjunctionCriterion(Conjunction.AND, criteria);
    }

    public static Criterion not(Criterion criterion) {
        ArrayList<Criterion> criteria = new ArrayList<Criterion>();
        criteria.add(criterion);
        return new ConjunctionCriterion(Conjunction.NOR, criteria);
    }

    public static Criterion not(List<Criterion> criteria) {
        return new ConjunctionCriterion(Conjunction.NOR, criteria);
    }

    public static Criterion flagSet(Flags.Flag flag, boolean isSet) {
        Criterion result = isSet ? SearchQuery.flagIsSet(flag) : SearchQuery.flagIsUnSet(flag);
        return result;
    }

    public static Criterion hasAttachment(boolean value) {
        if (value) {
            return new AttachmentCriterion(BooleanOperator.set());
        }
        return new AttachmentCriterion(BooleanOperator.unset());
    }

    public static Criterion attachmentFileName(String fileName) {
        return new TextCriterion(fileName, Scope.ATTACHMENT_FILE_NAME);
    }

    public static Criterion hasAttachment() {
        return SearchQuery.hasAttachment(true);
    }

    public static Criterion hasNoAttachment() {
        return SearchQuery.hasAttachment(false);
    }

    public static Criterion flagIsSet(Flags.Flag flag) {
        return new FlagCriterion(flag, BooleanOperator.set());
    }

    public static Criterion flagIsUnSet(Flags.Flag flag) {
        return new FlagCriterion(flag, BooleanOperator.unset());
    }

    public static Criterion flag(Flags.Flag flag, boolean isSet) {
        return new FlagCriterion(flag, new BooleanOperator(isSet));
    }

    public static Criterion flagSet(String flag, boolean isSet) {
        Criterion result = isSet ? SearchQuery.flagIsSet(flag) : SearchQuery.flagIsUnSet(flag);
        return result;
    }

    public static Criterion flagIsSet(String flag) {
        return new CustomFlagCriterion(flag, BooleanOperator.set());
    }

    public static Criterion flagIsUnSet(String flag) {
        return new CustomFlagCriterion(flag, BooleanOperator.unset());
    }

    public static Criterion all() {
        return AllCriterion.all();
    }

    public static Criterion mimeMessageID(String messageId) {
        return new MimeMessageIDCriterion(messageId);
    }

    public static Criterion threadId(ThreadId threadId) {
        return new ThreadIdCriterion(threadId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SearchQuery of(Criterion ... criterias) {
        return new Builder().andCriteria(criterias).build();
    }

    public static SearchQuery matchAll() {
        return new Builder().build();
    }

    public static SearchQuery allSortedWith(Sort ... sorts) {
        return new Builder().sorts(sorts).build();
    }

    private SearchQuery(ImmutableList<Criterion> criteria, ImmutableList<Sort> sorts, ImmutableSet<MessageUid> recentMessageUids) {
        this.criteria = criteria;
        this.sorts = sorts;
        this.recentMessageUids = recentMessageUids;
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public Set<MessageUid> getRecentMessageUids() {
        return this.recentMessageUids;
    }

    public String toString() {
        return "Search:" + this.criteria.toString();
    }

    public final int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.criteria, this.sorts, this.recentMessageUids});
    }

    public final boolean equals(Object obj) {
        if (obj instanceof SearchQuery) {
            SearchQuery that = (SearchQuery)obj;
            return com.google.common.base.Objects.equal(this.criteria, that.criteria) && com.google.common.base.Objects.equal(this.sorts, that.sorts) && com.google.common.base.Objects.equal(this.recentMessageUids, that.recentMessageUids);
        }
        return false;
    }

    public static class SizeCriterion
    extends Criterion {
        private final NumericOperator operator;

        private SizeCriterion(NumericOperator operator) {
            this.operator = operator;
        }

        public NumericOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.operator});
        }

        public boolean equals(Object obj) {
            if (obj instanceof SizeCriterion) {
                SizeCriterion that = (SizeCriterion)obj;
                return com.google.common.base.Objects.equal((Object)this.operator, (Object)that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).toString();
        }
    }

    public static class NumericOperator
    implements Operator {
        private final long value;
        private final NumericComparator type;

        private NumericOperator(long value, NumericComparator type) {
            this.value = value;
            this.type = type;
        }

        public NumericComparator getType() {
            return this.type;
        }

        public long getValue() {
            return this.value;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.value, this.type});
        }

        public boolean equals(Object obj) {
            if (obj instanceof NumericOperator) {
                NumericOperator that = (NumericOperator)obj;
                return com.google.common.base.Objects.equal((Object)this.value, (Object)that.value) && com.google.common.base.Objects.equal((Object)((Object)this.type), (Object)((Object)that.type));
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("type", (Object)this.type).toString();
        }
    }

    public static enum NumericComparator {
        EQUALS,
        LESS_THAN,
        GREATER_THAN;

    }

    public static class ModSeqCriterion
    extends Criterion {
        private final NumericOperator operator;

        private ModSeqCriterion(NumericOperator operator) {
            this.operator = operator;
        }

        public NumericOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.operator});
        }

        public boolean equals(Object obj) {
            if (obj instanceof ModSeqCriterion) {
                ModSeqCriterion that = (ModSeqCriterion)obj;
                return com.google.common.base.Objects.equal((Object)this.operator, (Object)that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).toString();
        }
    }

    public static class InternalDateCriterion
    extends Criterion {
        private final DateOperator operator;

        public InternalDateCriterion(DateOperator operator) {
            this.operator = operator;
        }

        public DateOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.operator});
        }

        public boolean equals(Object obj) {
            if (obj instanceof InternalDateCriterion) {
                InternalDateCriterion that = (InternalDateCriterion)obj;
                return com.google.common.base.Objects.equal((Object)this.operator, (Object)that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).toString();
        }
    }

    public static class DateOperator
    implements HeaderOperator {
        public static final int BEFORE = 1;
        public static final int AFTER = 2;
        public static final int ON = 3;
        private final DateComparator type;
        private final Date date;
        private final DateResolution dateResolution;

        public DateOperator(DateComparator type, Date date, DateResolution dateResolution) {
            Preconditions.checkNotNull((Object)date);
            Preconditions.checkNotNull((Object)((Object)dateResolution));
            this.type = type;
            this.date = date;
            this.dateResolution = dateResolution;
        }

        public Date getDate() {
            return this.date;
        }

        public DateResolution getDateResultion() {
            return this.dateResolution;
        }

        public DateComparator getType() {
            return this.type;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.dateResolution, this.type});
        }

        public boolean equals(Object obj) {
            if (obj instanceof DateOperator) {
                DateOperator that = (DateOperator)obj;
                return com.google.common.base.Objects.equal((Object)((Object)this.dateResolution), (Object)((Object)that.dateResolution)) && com.google.common.base.Objects.equal((Object)((Object)this.type), (Object)((Object)that.type));
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("date", (Object)this.date).add("dateResolution", (Object)this.dateResolution).add("type", (Object)this.type).toString();
        }
    }

    public static enum DateComparator {
        BEFORE,
        AFTER,
        ON;

    }

    public static enum DateResolution {
        Second,
        Minute,
        Hour,
        Day,
        Month,
        Year;

    }

    public static abstract class Criterion {
    }

    public static class HeaderCriterion
    extends Criterion {
        private final HeaderOperator operator;
        private final String headerName;

        private HeaderCriterion(String headerName, HeaderOperator operator) {
            this.operator = operator;
            this.headerName = headerName;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public HeaderOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.headerName, this.operator});
        }

        public boolean equals(Object obj) {
            if (obj instanceof HeaderCriterion) {
                HeaderCriterion that = (HeaderCriterion)obj;
                return com.google.common.base.Objects.equal((Object)this.operator, (Object)that.operator) && com.google.common.base.Objects.equal((Object)this.headerName, (Object)that.headerName);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).add("headerName", (Object)this.headerName).toString();
        }
    }

    public static interface HeaderOperator
    extends Operator {
    }

    public static enum AddressType {
        From,
        To,
        Cc,
        Bcc;

    }

    public static class AddressOperator
    implements HeaderOperator {
        private final String address;

        public AddressOperator(String address) {
            this.address = address;
        }

        public String getAddress() {
            return this.address;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.address});
        }

        public boolean equals(Object obj) {
            if (obj instanceof AddressOperator) {
                AddressOperator that = (AddressOperator)obj;
                return com.google.common.base.Objects.equal((Object)this.address, (Object)that.address);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).toString();
        }
    }

    public static class ContainsOperator
    implements HeaderOperator {
        private final String value;

        public ContainsOperator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.value});
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContainsOperator) {
                ContainsOperator that = (ContainsOperator)obj;
                return com.google.common.base.Objects.equal((Object)this.value, (Object)that.value);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }

    public static class ExistsOperator
    implements HeaderOperator {
        private static final ExistsOperator EXISTS = new ExistsOperator();

        public static ExistsOperator exists() {
            return EXISTS;
        }

        public boolean equals(Object obj) {
            return obj instanceof ExistsOperator;
        }

        public int hashCode() {
            return 42;
        }

        public String toString() {
            return "ExistsCriterion";
        }
    }

    public static class TextCriterion
    extends Criterion {
        private final Scope type;
        private final ContainsOperator operator;

        private TextCriterion(String value, Scope type) {
            this.operator = new ContainsOperator(value);
            this.type = type;
        }

        public Scope getType() {
            return this.type;
        }

        public ContainsOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.operator});
        }

        public boolean equals(Object obj) {
            if (obj instanceof TextCriterion) {
                TextCriterion that = (TextCriterion)obj;
                return com.google.common.base.Objects.equal((Object)this.operator, (Object)that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).toString();
        }
    }

    public static enum Scope {
        BODY,
        FULL,
        ATTACHMENTS,
        ATTACHMENT_FILE_NAME;

    }

    public static class UidCriterion
    extends Criterion {
        private final UidInOperator operator;

        public UidCriterion(UidRange[] ranges) {
            this.operator = new UidInOperator(ranges);
        }

        public UidInOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.operator});
        }

        public boolean equals(Object obj) {
            if (obj instanceof UidCriterion) {
                UidCriterion that = (UidCriterion)obj;
                return com.google.common.base.Objects.equal((Object)this.operator, (Object)that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).toString();
        }
    }

    public static class UidRange {
        private final MessageUid lowValue;
        private final MessageUid highValue;

        public UidRange(MessageUid value) {
            this.lowValue = value;
            this.highValue = value;
        }

        public UidRange(MessageUid lowValue, MessageUid highValue) {
            this.lowValue = lowValue;
            this.highValue = highValue;
        }

        public MessageUid getHighValue() {
            return this.highValue;
        }

        public MessageUid getLowValue() {
            return this.lowValue;
        }

        public boolean isIn(MessageUid value) {
            return this.lowValue.compareTo(value) <= 0 && this.highValue.compareTo(value) >= 0;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.lowValue, this.highValue});
        }

        public boolean equals(Object obj) {
            if (obj instanceof UidRange) {
                UidRange that = (UidRange)obj;
                return com.google.common.base.Objects.equal((Object)this.lowValue, (Object)that.lowValue) && com.google.common.base.Objects.equal((Object)this.highValue, (Object)that.highValue);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("lowValue", (Object)this.lowValue).add("highValue", (Object)this.highValue).toString();
        }
    }

    public static class ConjunctionCriterion
    extends Criterion {
        private final Conjunction type;
        private final List<Criterion> criteria;

        public ConjunctionCriterion(Conjunction type, List<Criterion> criteria) {
            this.type = type;
            this.criteria = criteria;
        }

        public List<Criterion> getCriteria() {
            return this.criteria;
        }

        public Conjunction getType() {
            return this.type;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.criteria});
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConjunctionCriterion) {
                ConjunctionCriterion that = (ConjunctionCriterion)obj;
                return com.google.common.base.Objects.equal(this.criteria, that.criteria);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("criteria", this.criteria).add("type", (Object)this.type).toString();
        }
    }

    public static enum Conjunction {
        AND,
        OR,
        NOR;

    }

    public static class AttachmentCriterion
    extends Criterion {
        private final BooleanOperator operator;

        private AttachmentCriterion(BooleanOperator operator) {
            this.operator = operator;
        }

        public BooleanOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.operator});
        }

        public boolean equals(Object obj) {
            if (obj instanceof AttachmentCriterion) {
                AttachmentCriterion that = (AttachmentCriterion)obj;
                return com.google.common.base.Objects.equal((Object)this.operator, (Object)that.operator);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).toString();
        }
    }

    public static class BooleanOperator
    implements Operator {
        private static final BooleanOperator SET = new BooleanOperator(true);
        private static final BooleanOperator UNSET = new BooleanOperator(false);
        private final boolean set;

        public static BooleanOperator set() {
            return SET;
        }

        public static BooleanOperator unset() {
            return UNSET;
        }

        private BooleanOperator(boolean set) {
            this.set = set;
        }

        public boolean isSet() {
            return this.set;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.set});
        }

        public boolean equals(Object obj) {
            if (obj instanceof BooleanOperator) {
                BooleanOperator that = (BooleanOperator)obj;
                return com.google.common.base.Objects.equal((Object)this.set, (Object)that.set);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("set", this.set).toString();
        }
    }

    public static class FlagCriterion
    extends Criterion {
        private final Flags.Flag flag;
        private final BooleanOperator operator;

        private FlagCriterion(Flags.Flag flag, BooleanOperator operator) {
            this.flag = flag;
            this.operator = operator;
        }

        public Flags.Flag getFlag() {
            return this.flag;
        }

        public BooleanOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.flag, this.operator});
        }

        public boolean equals(Object obj) {
            if (obj instanceof FlagCriterion) {
                FlagCriterion that = (FlagCriterion)obj;
                return com.google.common.base.Objects.equal((Object)this.operator, (Object)that.operator) && com.google.common.base.Objects.equal((Object)this.flag, (Object)that.flag);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).add("flag", (Object)this.flag).toString();
        }
    }

    public static class CustomFlagCriterion
    extends Criterion {
        private final String flag;
        private final BooleanOperator operator;

        private CustomFlagCriterion(String flag, BooleanOperator operator) {
            this.flag = flag;
            this.operator = operator;
        }

        public String getFlag() {
            return this.flag;
        }

        public BooleanOperator getOperator() {
            return this.operator;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.flag, this.operator});
        }

        public boolean equals(Object obj) {
            if (obj instanceof CustomFlagCriterion) {
                CustomFlagCriterion that = (CustomFlagCriterion)obj;
                return com.google.common.base.Objects.equal((Object)this.operator, (Object)that.operator) && com.google.common.base.Objects.equal((Object)this.flag, (Object)that.flag);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).add("flag", (Object)this.flag).toString();
        }
    }

    public static class AllCriterion
    extends Criterion {
        private static final AllCriterion ALL = new AllCriterion();

        private static Criterion all() {
            return ALL;
        }

        public boolean equals(Object obj) {
            return obj instanceof AllCriterion;
        }

        public int hashCode() {
            return 1729;
        }

        public String toString() {
            return "AllCriterion";
        }
    }

    public static class MimeMessageIDCriterion
    extends Criterion {
        private final String messageID;

        public MimeMessageIDCriterion(String messageID) {
            this.messageID = messageID;
        }

        public String getMessageID() {
            return this.messageID;
        }

        public HeaderCriterion asHeaderCriterion() {
            return new HeaderCriterion("Message-ID", new ContainsOperator(this.messageID));
        }

        public final boolean equals(Object o) {
            if (o instanceof MimeMessageIDCriterion) {
                MimeMessageIDCriterion that = (MimeMessageIDCriterion)o;
                return Objects.equals(this.messageID, that.messageID);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.messageID);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("messageID", (Object)this.messageID).toString();
        }
    }

    public static class ThreadIdCriterion
    extends Criterion {
        private final ThreadId threadId;

        public ThreadIdCriterion(ThreadId threadId) {
            this.threadId = threadId;
        }

        public ThreadId getThreadId() {
            return this.threadId;
        }

        public final boolean equals(Object o) {
            if (o instanceof ThreadIdCriterion) {
                ThreadIdCriterion that = (ThreadIdCriterion)o;
                return com.google.common.base.Objects.equal((Object)this.threadId, (Object)that.threadId);
            }
            return false;
        }

        public final int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.threadId});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("threadId", (Object)this.threadId).toString();
        }
    }

    public static class Builder {
        private final ImmutableList.Builder<Criterion> criterias = ImmutableList.builder();
        private final ImmutableSet.Builder<MessageUid> recentMessageUids;
        private Optional<ImmutableList<Sort>> sorts = Optional.empty();

        public Builder() {
            this.recentMessageUids = ImmutableSet.builder();
        }

        public Builder andCriteria(Criterion ... criteria) {
            return this.andCriteria(Arrays.asList(criteria));
        }

        public Builder andCriteria(Collection<Criterion> criteria) {
            this.criterias.addAll(criteria);
            return this;
        }

        public Builder sorts(Sort ... sorts) {
            return this.sorts(Arrays.asList(sorts));
        }

        public Builder sorts(List<Sort> sorts) {
            if (sorts == null || sorts.isEmpty()) {
                throw new IllegalArgumentException("There must be at least one Sort");
            }
            this.sorts = Optional.of(ImmutableList.copyOf(sorts));
            return this;
        }

        public Builder addRecentMessageUids(Collection<MessageUid> uids) {
            this.recentMessageUids.addAll(uids);
            return this;
        }

        public SearchQuery build() {
            return new SearchQuery((ImmutableList<Criterion>)this.criterias.build(), this.sorts.orElse((ImmutableList<Sort>)ImmutableList.of((Object)new Sort(Sort.SortClause.Uid, Sort.Order.NATURAL))), (ImmutableSet<MessageUid>)this.recentMessageUids.build());
        }
    }

    public static class Sort {
        private final Order order;
        private final SortClause sortClause;

        public Sort(SortClause sortClause, Order order) {
            this.order = order;
            this.sortClause = sortClause;
        }

        public Sort(SortClause sortClause) {
            this(sortClause, Order.NATURAL);
        }

        public boolean isReverse() {
            return this.order == Order.REVERSE;
        }

        public SortClause getSortClause() {
            return this.sortClause;
        }

        public boolean equals(Object o) {
            if (o instanceof Sort) {
                Sort that = (Sort)o;
                return com.google.common.base.Objects.equal((Object)((Object)this.sortClause), (Object)((Object)that.sortClause)) && com.google.common.base.Objects.equal((Object)((Object)this.order), (Object)((Object)that.order));
            }
            return false;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.sortClause, this.order});
        }

        public static enum Order {
            REVERSE,
            NATURAL;

        }

        public static enum SortClause {
            Arrival,
            MailboxCc,
            MailboxFrom,
            MailboxTo,
            BaseSubject,
            Size,
            SentDate,
            Uid,
            Id;

        }
    }

    public static class UidInOperator
    implements Operator {
        private final UidRange[] ranges;

        public UidInOperator(UidRange[] ranges) {
            this.ranges = ranges;
        }

        public UidRange[] getRange() {
            return this.ranges;
        }

        public int hashCode() {
            return Arrays.hashCode(this.ranges);
        }

        public boolean equals(Object obj) {
            if (obj instanceof UidInOperator) {
                UidInOperator other = (UidInOperator)obj;
                return Arrays.equals(this.ranges, other.ranges);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("ranges", (Object)Arrays.toString(this.ranges)).toString();
        }
    }

    public static interface Operator {
    }
}

