/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.blob.api.BlobId;
import org.apache.james.util.DurationParser;

public class GenerationAwareBlobId
implements BlobId {
    public static final int NO_FAMILY = 0;
    public static final int NO_GENERATION = 0;
    private final long generation;
    private final int family;
    private final BlobId delegate;

    private static long computeGeneration(Configuration configuration, Instant now) {
        return now.getEpochSecond() / configuration.getDuration().toSeconds();
    }

    @VisibleForTesting
    GenerationAwareBlobId(long generation, int family, BlobId delegate) {
        Preconditions.checkArgument((generation >= 0L ? 1 : 0) != 0, (Object)"'generation' should not be negative");
        Preconditions.checkArgument((family >= 0 ? 1 : 0) != 0, (Object)"'family' should not be negative");
        this.generation = generation;
        this.family = family;
        this.delegate = delegate;
    }

    public String asString() {
        if (this.family == 0) {
            return this.delegate.asString();
        }
        return this.family + "_" + this.generation + "_" + this.delegate.asString();
    }

    public boolean inActiveGeneration(Configuration configuration, Instant now) {
        return configuration.getFamily() == this.family && this.generation + 1L >= GenerationAwareBlobId.computeGeneration(configuration, now);
    }

    @VisibleForTesting
    long getGeneration() {
        return this.generation;
    }

    @VisibleForTesting
    int getFamily() {
        return this.family;
    }

    @VisibleForTesting
    BlobId getDelegate() {
        return this.delegate;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof GenerationAwareBlobId) {
            GenerationAwareBlobId other = (GenerationAwareBlobId)obj;
            return Objects.equals(this.generation, other.generation) && Objects.equals(this.delegate, other.delegate) && Objects.equals(this.family, other.family);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.generation, this.family, this.delegate);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("generation", this.generation).add("delegate", (Object)this.delegate).toString();
    }

    public static class Configuration {
        public static final Duration DEFAULT_DURATION = Duration.ofDays(30L);
        public static final int DEFAULT_FAMILY = 1;
        public static final Configuration DEFAULT = Configuration.builder().duration(DEFAULT_DURATION).family(1);
        private final int family;
        private final Duration duration;

        public static RequiresGenerationDuration builder() {
            return duration -> family -> new Configuration(family, duration);
        }

        public static Configuration parse(org.apache.commons.configuration2.Configuration propertiesConfiguration) {
            return Configuration.builder().duration(Optional.ofNullable(propertiesConfiguration.getString("deduplication.gc.generation.duration", null)).map(s -> DurationParser.parse((String)s, (ChronoUnit)ChronoUnit.DAYS)).orElse(DEFAULT_DURATION)).family(Optional.ofNullable(propertiesConfiguration.getString("deduplication.gc.generation.family", null)).map(Integer::parseInt).orElse(1));
        }

        public Configuration(int family, Duration duration) {
            Preconditions.checkArgument((family > 0 ? 1 : 0) != 0, (Object)"'family' must be strictly positive");
            Preconditions.checkNotNull((Object)duration);
            Preconditions.checkArgument((!duration.isZero() ? 1 : 0) != 0, (Object)"'duration' must be strictly positive");
            this.family = family;
            this.duration = duration;
        }

        public int getFamily() {
            return this.family;
        }

        public Duration getDuration() {
            return this.duration;
        }

        public final boolean equals(Object obj) {
            if (obj instanceof Configuration) {
                Configuration other = (Configuration)obj;
                return Objects.equals(this.family, other.family) && Objects.equals(this.duration, other.duration);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.family, this.duration);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("family", this.family).add("duration", (Object)this.duration).toString();
        }

        @FunctionalInterface
        public static interface RequiresGenerationDuration {
            public RequiresGenerationFamily duration(Duration var1);
        }

        @FunctionalInterface
        public static interface RequiresGenerationFamily {
            public Configuration family(int var1);
        }
    }

    public static class Factory
    implements BlobId.Factory {
        private final Clock clock;
        private final BlobId.Factory delegate;
        private final Configuration configuration;

        public Factory(Clock clock, BlobId.Factory delegate, Configuration configuration) {
            this.clock = clock;
            this.delegate = delegate;
            this.configuration = configuration;
        }

        public GenerationAwareBlobId forPayload(byte[] payload) {
            return this.decorate(this.delegate.forPayload(payload));
        }

        public GenerationAwareBlobId forPayload(ByteSource payload) {
            return this.decorate(this.delegate.forPayload(payload));
        }

        public GenerationAwareBlobId from(String id) {
            int separatorIndex1 = id.indexOf(95);
            if (separatorIndex1 == -1 || separatorIndex1 == id.length() - 1) {
                return this.decorateWithoutGeneration(id);
            }
            int separatorIndex2 = id.indexOf(95, separatorIndex1 + 1);
            if (separatorIndex2 == -1 || separatorIndex2 == id.length() - 1) {
                return this.decorateWithoutGeneration(id);
            }
            int family = Integer.parseInt(id.substring(0, separatorIndex1));
            int generation = Integer.parseInt(id.substring(separatorIndex1 + 1, separatorIndex2));
            BlobId wrapped = this.delegate.from(id.substring(separatorIndex2 + 1));
            return new GenerationAwareBlobId(generation, family, wrapped);
        }

        public GenerationAwareBlobId randomId() {
            return this.decorate(this.delegate.randomId());
        }

        private GenerationAwareBlobId decorateWithoutGeneration(String id) {
            return new GenerationAwareBlobId(0L, 0, this.delegate.from(id));
        }

        private GenerationAwareBlobId decorate(BlobId blobId) {
            return new GenerationAwareBlobId(GenerationAwareBlobId.computeGeneration(this.configuration, this.clock.instant()), this.configuration.getFamily(), blobId);
        }
    }
}

