/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.google.common.base.Preconditions;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Optional;
import org.apache.james.jmap.cassandra.upload.CassandraUploadRepository;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class UploadRepositoryCleanupTask
implements Task {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadRepositoryCleanupTask.class);
    public static final TaskType TASK_TYPE = TaskType.of((String)"UploadRepositoryCleanupTask");
    private final CassandraUploadRepository uploadRepository;
    private final CleanupScope scope;

    public UploadRepositoryCleanupTask(CassandraUploadRepository uploadRepository, CleanupScope scope) {
        this.uploadRepository = uploadRepository;
        this.scope = scope;
    }

    public Task.Result run() {
        if (CleanupScope.EXPIRED.equals((Object)this.scope)) {
            return (Task.Result)this.uploadRepository.purge().thenReturn((Object)Task.Result.COMPLETED).onErrorResume(error -> {
                LOGGER.error("Error when cleaning upload repository", error);
                return Mono.just((Object)Task.Result.PARTIAL);
            }).subscribeOn(Schedulers.elastic()).block();
        }
        return Task.Result.COMPLETED;
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public CleanupScope getScope() {
        return this.scope;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from(this.scope));
    }

    static enum CleanupScope {
        EXPIRED;


        public static Optional<CleanupScope> from(String name) {
            Preconditions.checkNotNull((Object)name);
            return Arrays.stream(CleanupScope.values()).filter(value -> name.equalsIgnoreCase(value.name())).findFirst();
        }

        static class CleanupScopeInvalidException
        extends IllegalArgumentException {
            CleanupScopeInvalidException() {
            }
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final CleanupScope scope;
        private final Instant timestamp;

        private static AdditionalInformation from(CleanupScope scope) {
            return new AdditionalInformation(scope, Clock.systemUTC().instant());
        }

        public AdditionalInformation(CleanupScope scope, Instant timestamp) {
            this.scope = scope;
            this.timestamp = timestamp;
        }

        public Instant timestamp() {
            return this.timestamp;
        }

        public CleanupScope getScope() {
            return this.scope;
        }
    }
}

