/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.DayMonthYear;
import org.apache.james.imap.api.message.request.SearchKey;
import org.apache.james.imap.api.message.request.SearchOperation;
import org.apache.james.imap.api.message.request.SearchResultOption;
import org.apache.james.imap.api.message.response.StatusResponse;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchCommandParser
extends AbstractUidCommandParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchCommandParser.class);

    public SearchCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.SEARCH_COMMAND, statusResponseFactory);
    }

    protected SearchKey searchKey(ImapSession session, ImapRequestLineReader request, Charset charset, boolean isFirstToken) throws DecodingException, IllegalCharsetNameException, UnsupportedCharsetException {
        char next = request.nextChar();
        if (next >= '0' && next <= '9' || next == '*' || next == '$') {
            return this.sequenceSet(session, request);
        }
        if (next == '(') {
            return this.paren(session, request, charset);
        }
        int cap = this.consumeAndCap(request);
        switch (cap) {
            case 65: {
                return this.a(request);
            }
            case 66: {
                return this.b(request, charset);
            }
            case 67: {
                return this.c(session, request, isFirstToken, charset);
            }
            case 68: {
                return this.d(request);
            }
            case 69: {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
            }
            case 70: {
                return this.f(request, charset);
            }
            case 71: {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
            }
            case 72: {
                return this.header(request, charset);
            }
            case 73: {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
            }
            case 74: {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
            }
            case 75: {
                return this.keyword(request);
            }
            case 76: {
                return this.larger(request);
            }
            case 77: {
                return this.modseq(request);
            }
            case 78: {
                return this.n(session, request, charset);
            }
            case 79: {
                return this.o(session, request, charset);
            }
            case 80: {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
            }
            case 81: {
                throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
            }
            case 82: {
                this.nextIsE(request);
                this.nextIsC(request);
                return this.recent(request);
            }
            case 83: {
                return this.s(request, charset);
            }
            case 84: {
                return this.t(request, charset);
            }
            case 85: {
                return this.u(request);
            }
            case 89: {
                return this.younger(request);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey modseq(ImapRequestLineReader request) throws DecodingException {
        this.nextIsO(request);
        this.nextIsD(request);
        this.nextIsS(request);
        this.nextIsE(request);
        this.nextIsQ(request);
        try {
            return SearchKey.buildModSeq(request.number());
        }
        catch (DecodingException e) {
            request.consumeQuoted();
            request.consumeWord(chr -> true);
            return SearchKey.buildModSeq(request.number());
        }
    }

    private SearchKey paren(ImapSession session, ImapRequestLineReader request, Charset charset) throws DecodingException {
        request.consume();
        ArrayList<SearchKey> keys = new ArrayList<SearchKey>();
        this.addUntilParen(session, request, keys, charset);
        return SearchKey.buildAnd(keys);
    }

    private void addUntilParen(ImapSession session, ImapRequestLineReader request, List<SearchKey> keys, Charset charset) throws DecodingException {
        char next = request.nextWordChar();
        if (next == ')') {
            request.consume();
        } else {
            SearchKey key = this.searchKey(session, request, null, false);
            keys.add(key);
            this.addUntilParen(session, request, keys, charset);
        }
    }

    private int consumeAndCap(ImapRequestLineReader request) throws DecodingException {
        char next = request.consume();
        return ImapRequestLineReader.cap(next);
    }

    private SearchKey cc(ImapRequestLineReader request, Charset charset) throws DecodingException {
        this.nextIsSpace(request);
        String value = request.astring(charset);
        SearchKey result = SearchKey.buildCc(value);
        return result;
    }

    private SearchKey c(ImapSession session, ImapRequestLineReader request, boolean isFirstToken, Charset charset) throws DecodingException, IllegalCharsetNameException, UnsupportedCharsetException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 67: {
                return this.cc(request, charset);
            }
            case 72: {
                return this.charset(session, request, isFirstToken);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey charset(ImapSession session, ImapRequestLineReader request, boolean isFirstToken) throws DecodingException, IllegalCharsetNameException, UnsupportedCharsetException {
        this.nextIsA(request);
        this.nextIsR(request);
        this.nextIsS(request);
        this.nextIsE(request);
        this.nextIsT(request);
        this.nextIsSpace(request);
        if (!isFirstToken) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
        }
        String value = request.astring();
        Charset charset = Charset.forName(value);
        request.nextWordChar();
        SearchKey result = this.searchKey(session, request, charset, false);
        return result;
    }

    private SearchKey u(ImapRequestLineReader request) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 73: {
                return this.uid(request);
            }
            case 78: {
                return this.un(request);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey un(ImapRequestLineReader request) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 65: {
                return this.unanswered(request);
            }
            case 68: {
                return this.und(request);
            }
            case 70: {
                return this.unflagged(request);
            }
            case 75: {
                return this.unkeyword(request);
            }
            case 83: {
                return this.unseen(request);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey und(ImapRequestLineReader request) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 69: {
                return this.undeleted(request);
            }
            case 82: {
                return this.undraft(request);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey t(ImapRequestLineReader request, Charset charset) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 69: {
                return this.text(request, charset);
            }
            case 79: {
                return this.to(request, charset);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey s(ImapRequestLineReader request, Charset charset) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 69: {
                return this.se(request);
            }
            case 73: {
                return this.since(request);
            }
            case 77: {
                return this.smaller(request);
            }
            case 85: {
                return this.subject(request, charset);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey se(ImapRequestLineReader request) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 69: {
                return this.seen(request);
            }
            case 78: {
                return this.sen(request);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey sen(ImapRequestLineReader request) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 84: {
                return this.sent(request);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey sent(ImapRequestLineReader request) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 66: {
                return this.sentBefore(request);
            }
            case 79: {
                return this.sentOn(request);
            }
            case 83: {
                return this.sentSince(request);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey o(ImapSession session, ImapRequestLineReader request, Charset charset) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 76: {
                return this.old(request);
            }
            case 78: {
                return this.on(request);
            }
            case 82: {
                return this.or(session, request, charset);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey old(ImapRequestLineReader request) throws DecodingException {
        this.nextIsD(request);
        try {
            this.nextIsE(request);
            return this.older(request);
        }
        catch (DecodingException e) {
            return SearchKey.buildOld();
        }
    }

    private SearchKey n(ImapSession session, ImapRequestLineReader request, Charset charset) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 69: {
                return this.newOperator(request);
            }
            case 79: {
                return this.not(session, request, charset);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey f(ImapRequestLineReader request, Charset charset) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 76: {
                return this.flagged(request);
            }
            case 82: {
                return this.from(request, charset);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey d(ImapRequestLineReader request) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 69: {
                return this.deleted(request);
            }
            case 82: {
                return this.draft(request);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey keyword(ImapRequestLineReader request) throws DecodingException {
        this.nextIsE(request);
        this.nextIsY(request);
        this.nextIsW(request);
        this.nextIsO(request);
        this.nextIsR(request);
        this.nextIsD(request);
        this.nextIsSpace(request);
        String value = request.atom();
        SearchKey result = SearchKey.buildKeyword(value);
        return result;
    }

    private SearchKey unkeyword(ImapRequestLineReader request) throws DecodingException {
        this.nextIsE(request);
        this.nextIsY(request);
        this.nextIsW(request);
        this.nextIsO(request);
        this.nextIsR(request);
        this.nextIsD(request);
        this.nextIsSpace(request);
        String value = request.atom();
        SearchKey result = SearchKey.buildUnkeyword(value);
        return result;
    }

    private SearchKey header(ImapRequestLineReader request, Charset charset) throws DecodingException {
        this.nextIsE(request);
        this.nextIsA(request);
        this.nextIsD(request);
        this.nextIsE(request);
        this.nextIsR(request);
        this.nextIsSpace(request);
        String field = request.astring(charset);
        this.nextIsSpace(request);
        String value = request.astring(charset);
        SearchKey result = SearchKey.buildHeader(field, value);
        return result;
    }

    private SearchKey larger(ImapRequestLineReader request) throws DecodingException {
        this.nextIsA(request);
        this.nextIsR(request);
        this.nextIsG(request);
        this.nextIsE(request);
        this.nextIsR(request);
        this.nextIsSpace(request);
        long value = request.number();
        SearchKey result = SearchKey.buildLarger(value);
        return result;
    }

    private SearchKey smaller(ImapRequestLineReader request) throws DecodingException {
        this.nextIsA(request);
        this.nextIsL(request);
        this.nextIsL(request);
        this.nextIsE(request);
        this.nextIsR(request);
        this.nextIsSpace(request);
        long value = request.number();
        SearchKey result = SearchKey.buildSmaller(value);
        return result;
    }

    private SearchKey from(ImapRequestLineReader request, Charset charset) throws DecodingException {
        this.nextIsO(request);
        this.nextIsM(request);
        this.nextIsSpace(request);
        String value = request.astring(charset);
        SearchKey result = SearchKey.buildFrom(value);
        return result;
    }

    private SearchKey flagged(ImapRequestLineReader request) throws DecodingException {
        this.nextIsA(request);
        this.nextIsG(request);
        this.nextIsG(request);
        this.nextIsE(request);
        this.nextIsD(request);
        SearchKey result = SearchKey.buildFlagged();
        return result;
    }

    private SearchKey unseen(ImapRequestLineReader request) throws DecodingException {
        this.nextIsE(request);
        this.nextIsE(request);
        this.nextIsN(request);
        SearchKey result = SearchKey.buildUnseen();
        return result;
    }

    private SearchKey undraft(ImapRequestLineReader request) throws DecodingException {
        this.nextIsA(request);
        this.nextIsF(request);
        this.nextIsT(request);
        SearchKey result = SearchKey.buildUndraft();
        return result;
    }

    private SearchKey undeleted(ImapRequestLineReader request) throws DecodingException {
        this.nextIsL(request);
        this.nextIsE(request);
        this.nextIsT(request);
        this.nextIsE(request);
        this.nextIsD(request);
        SearchKey result = SearchKey.buildUndeleted();
        return result;
    }

    private SearchKey unflagged(ImapRequestLineReader request) throws DecodingException {
        this.nextIsL(request);
        this.nextIsA(request);
        this.nextIsG(request);
        this.nextIsG(request);
        this.nextIsE(request);
        this.nextIsD(request);
        SearchKey result = SearchKey.buildUnflagged();
        return result;
    }

    private SearchKey unanswered(ImapRequestLineReader request) throws DecodingException {
        this.nextIsN(request);
        this.nextIsS(request);
        this.nextIsW(request);
        this.nextIsE(request);
        this.nextIsR(request);
        this.nextIsE(request);
        this.nextIsD(request);
        SearchKey result = SearchKey.buildUnanswered();
        return result;
    }

    private SearchKey younger(ImapRequestLineReader request) throws DecodingException {
        this.nextIsO(request);
        this.nextIsU(request);
        this.nextIsN(request);
        this.nextIsG(request);
        this.nextIsE(request);
        this.nextIsR(request);
        this.nextIsSpace(request);
        SearchKey result = SearchKey.buildYounger(request.nzNumber());
        return result;
    }

    private SearchKey older(ImapRequestLineReader request) throws DecodingException {
        this.nextIsR(request);
        this.nextIsSpace(request);
        SearchKey result = SearchKey.buildOlder(request.nzNumber());
        return result;
    }

    private SearchKey or(ImapSession session, ImapRequestLineReader request, Charset charset) throws DecodingException {
        this.nextIsSpace(request);
        SearchKey firstKey = this.searchKey(session, request, charset, false);
        this.nextIsSpace(request);
        SearchKey secondKey = this.searchKey(session, request, charset, false);
        SearchKey result = SearchKey.buildOr(firstKey, secondKey);
        return result;
    }

    private SearchKey not(ImapSession session, ImapRequestLineReader request, Charset charset) throws DecodingException {
        this.nextIsT(request);
        this.nextIsSpace(request);
        SearchKey nextKey = this.searchKey(session, request, charset, false);
        SearchKey result = SearchKey.buildNot(nextKey);
        return result;
    }

    private SearchKey newOperator(ImapRequestLineReader request) throws DecodingException {
        this.nextIsW(request);
        SearchKey result = SearchKey.buildNew();
        return result;
    }

    private SearchKey recent(ImapRequestLineReader request) throws DecodingException {
        this.nextIsE(request);
        this.nextIsN(request);
        this.nextIsT(request);
        SearchKey result = SearchKey.buildRecent();
        return result;
    }

    private SearchKey seen(ImapRequestLineReader request) throws DecodingException {
        this.nextIsN(request);
        SearchKey result = SearchKey.buildSeen();
        return result;
    }

    private SearchKey draft(ImapRequestLineReader request) throws DecodingException {
        this.nextIsA(request);
        this.nextIsF(request);
        this.nextIsT(request);
        SearchKey result = SearchKey.buildDraft();
        return result;
    }

    private SearchKey deleted(ImapRequestLineReader request) throws DecodingException {
        this.nextIsL(request);
        this.nextIsE(request);
        this.nextIsT(request);
        this.nextIsE(request);
        this.nextIsD(request);
        SearchKey result = SearchKey.buildDeleted();
        return result;
    }

    private SearchKey b(ImapRequestLineReader request, Charset charset) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 67: {
                return this.bcc(request, charset);
            }
            case 69: {
                return this.before(request);
            }
            case 79: {
                return this.body(request, charset);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey body(ImapRequestLineReader request, Charset charset) throws DecodingException {
        this.nextIsD(request);
        this.nextIsY(request);
        this.nextIsSpace(request);
        String value = request.astring(charset);
        SearchKey result = SearchKey.buildBody(value);
        return result;
    }

    private SearchKey on(ImapRequestLineReader request) throws DecodingException {
        this.nextIsSpace(request);
        DayMonthYear value = request.date();
        SearchKey result = SearchKey.buildOn(value);
        return result;
    }

    private SearchKey sentBefore(ImapRequestLineReader request) throws DecodingException {
        this.nextIsE(request);
        this.nextIsF(request);
        this.nextIsO(request);
        this.nextIsR(request);
        this.nextIsE(request);
        this.nextIsSpace(request);
        DayMonthYear value = request.date();
        SearchKey result = SearchKey.buildSentBefore(value);
        return result;
    }

    private SearchKey sentSince(ImapRequestLineReader request) throws DecodingException {
        this.nextIsI(request);
        this.nextIsN(request);
        this.nextIsC(request);
        this.nextIsE(request);
        this.nextIsSpace(request);
        DayMonthYear value = request.date();
        SearchKey result = SearchKey.buildSentSince(value);
        return result;
    }

    private SearchKey since(ImapRequestLineReader request) throws DecodingException {
        this.nextIsN(request);
        this.nextIsC(request);
        this.nextIsE(request);
        this.nextIsSpace(request);
        DayMonthYear value = request.date();
        SearchKey result = SearchKey.buildSince(value);
        return result;
    }

    private SearchKey sentOn(ImapRequestLineReader request) throws DecodingException {
        this.nextIsN(request);
        this.nextIsSpace(request);
        DayMonthYear value = request.date();
        SearchKey result = SearchKey.buildSentOn(value);
        return result;
    }

    private SearchKey before(ImapRequestLineReader request) throws DecodingException {
        this.nextIsF(request);
        this.nextIsO(request);
        this.nextIsR(request);
        this.nextIsE(request);
        this.nextIsSpace(request);
        DayMonthYear value = request.date();
        SearchKey result = SearchKey.buildBefore(value);
        return result;
    }

    private SearchKey bcc(ImapRequestLineReader request, Charset charset) throws DecodingException {
        this.nextIsC(request);
        this.nextIsSpace(request);
        String value = request.astring(charset);
        SearchKey result = SearchKey.buildBcc(value);
        return result;
    }

    private SearchKey text(ImapRequestLineReader request, Charset charset) throws DecodingException {
        this.nextIsX(request);
        this.nextIsT(request);
        this.nextIsSpace(request);
        String value = request.astring(charset);
        SearchKey result = SearchKey.buildText(value);
        return result;
    }

    private SearchKey uid(ImapRequestLineReader request) throws DecodingException {
        this.nextIsD(request);
        this.nextIsSpace(request);
        UidRange[] range = request.parseUidRange();
        SearchKey result = SearchKey.buildUidSet(range);
        return result;
    }

    private SearchKey sequenceSet(ImapSession session, ImapRequestLineReader request) throws DecodingException {
        IdRange[] range = request.parseIdRange(session);
        return SearchKey.buildSequenceSet(range);
    }

    private SearchKey to(ImapRequestLineReader request, Charset charset) throws DecodingException {
        this.nextIsSpace(request);
        String value = request.astring(charset);
        SearchKey result = SearchKey.buildTo(value);
        return result;
    }

    private SearchKey subject(ImapRequestLineReader request, Charset charset) throws DecodingException {
        this.nextIsB(request);
        this.nextIsJ(request);
        this.nextIsE(request);
        this.nextIsC(request);
        this.nextIsT(request);
        this.nextIsSpace(request);
        String value = request.astring(charset);
        SearchKey result = SearchKey.buildSubject(value);
        return result;
    }

    private SearchKey a(ImapRequestLineReader request) throws DecodingException {
        int next = this.consumeAndCap(request);
        switch (next) {
            case 76: {
                return this.all(request);
            }
            case 78: {
                return this.answered(request);
            }
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
    }

    private SearchKey answered(ImapRequestLineReader request) throws DecodingException {
        this.nextIsS(request);
        this.nextIsW(request);
        this.nextIsE(request);
        this.nextIsR(request);
        this.nextIsE(request);
        this.nextIsD(request);
        SearchKey result = SearchKey.buildAnswered();
        return result;
    }

    private SearchKey all(ImapRequestLineReader request) throws DecodingException {
        this.nextIsL(request);
        SearchKey result = SearchKey.buildAll();
        return result;
    }

    private void nextIsSpace(ImapRequestLineReader request) throws DecodingException {
        char next = request.consume();
        if (next != ' ') {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
        }
    }

    private void nextIsG(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'G', 'g');
    }

    private void nextIsM(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'M', 'm');
    }

    private void nextIsI(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'I', 'i');
    }

    private void nextIsN(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'N', 'n');
    }

    private void nextIsA(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'A', 'a');
    }

    private void nextIsT(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'T', 't');
    }

    private void nextIsY(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'Y', 'y');
    }

    private void nextIsX(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'X', 'x');
    }

    private void nextIsU(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'U', 'u');
    }

    private void nextIsO(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'O', 'o');
    }

    private void nextIsQ(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'Q', 'q');
    }

    private void nextIsF(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'F', 'f');
    }

    private void nextIsJ(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'J', 'j');
    }

    private void nextIsC(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'C', 'c');
    }

    private void nextIsD(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'D', 'd');
    }

    private void nextIsB(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'B', 'b');
    }

    private void nextIsR(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'R', 'r');
    }

    private void nextIsE(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'E', 'e');
    }

    private void nextIsW(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'W', 'w');
    }

    private void nextIsS(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'S', 's');
    }

    private void nextIsL(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'L', 'l');
    }

    private void nextIsV(ImapRequestLineReader request) throws DecodingException {
        this.nextIs(request, 'V', 'v');
    }

    private void nextIs(ImapRequestLineReader request, char upper, char lower) throws DecodingException {
        char next = request.consume();
        if (next != upper && next != lower) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
        }
    }

    public SearchKey decode(ImapSession session, ImapRequestLineReader request) throws DecodingException, IllegalCharsetNameException, UnsupportedCharsetException {
        SearchKey result;
        request.nextWordChar();
        SearchKey firstKey = this.searchKey(session, request, null, true);
        if (request.nextChar() == ' ') {
            ArrayList<SearchKey> keys = new ArrayList<SearchKey>();
            keys.add(firstKey);
            while (request.nextChar() == ' ') {
                request.nextWordChar();
                SearchKey key = this.searchKey(session, request, null, false);
                keys.add(key);
            }
            result = SearchKey.buildAnd(keys);
        } else {
            result = firstKey;
        }
        request.eol();
        return result;
    }

    private ImapMessage unsupportedCharset(Tag tag) {
        StatusResponse.ResponseCode badCharset = StatusResponse.ResponseCode.badCharset();
        return this.taggedNo(tag, ImapConstants.SEARCH_COMMAND, HumanReadableText.BAD_CHARSET, badCharset);
    }

    private List<SearchResultOption> parseOptions(ImapRequestLineReader reader) throws DecodingException {
        ArrayList<SearchResultOption> options = new ArrayList<SearchResultOption>();
        reader.consumeChar('(');
        reader.nextWordChar();
        int cap = this.consumeAndCap(reader);
        while (cap != 41) {
            block0 : switch (cap) {
                case 65: {
                    this.nextIsL(reader);
                    this.nextIsL(reader);
                    options.add(SearchResultOption.ALL);
                    break;
                }
                case 67: {
                    this.nextIsO(reader);
                    this.nextIsU(reader);
                    this.nextIsN(reader);
                    this.nextIsT(reader);
                    options.add(SearchResultOption.COUNT);
                    break;
                }
                case 77: {
                    int c = this.consumeAndCap(reader);
                    switch (c) {
                        case 65: {
                            this.nextIsX(reader);
                            options.add(SearchResultOption.MAX);
                            break block0;
                        }
                        case 73: {
                            this.nextIsN(reader);
                            options.add(SearchResultOption.MIN);
                            break block0;
                        }
                    }
                    throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
                }
                case 83: {
                    this.nextIsA(reader);
                    this.nextIsV(reader);
                    this.nextIsE(reader);
                    options.add(SearchResultOption.SAVE);
                    break;
                }
                default: {
                    throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
                }
            }
            reader.nextWordChar();
            cap = this.consumeAndCap(reader);
        }
        if (options.isEmpty()) {
            options.add(SearchResultOption.ALL);
        }
        return options;
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, boolean useUids, ImapSession session) throws DecodingException {
        try {
            SearchKey finalKey;
            SearchKey recent = null;
            List<SearchResultOption> options = null;
            int c = ImapRequestLineReader.cap(request.nextWordChar());
            if (c == 82) {
                request.consume();
                this.nextIsE(request);
                c = this.consumeAndCap(request);
                switch (c) {
                    case 67: {
                        recent = this.recent(request);
                        break;
                    }
                    case 84: {
                        this.nextIsU(request);
                        this.nextIsR(request);
                        this.nextIsN(request);
                        request.nextWordChar();
                        options = this.parseOptions(request);
                        break;
                    }
                    default: {
                        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown search key");
                    }
                }
            }
            if (recent != null) {
                if (request.nextChar() != ' ') {
                    request.eol();
                    finalKey = recent;
                } else {
                    SearchKey key = this.decode(session, request);
                    finalKey = SearchKey.buildAnd(Arrays.asList(recent, key));
                }
            } else {
                finalKey = this.decode(session, request);
            }
            if (options == null) {
                options = new ArrayList<SearchResultOption>();
            }
            return new SearchRequest(new SearchOperation(finalKey, options), useUids, tag);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            LOGGER.debug("Unable to decode request", (Throwable)e);
            return this.unsupportedCharset(tag);
        }
    }
}

