/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jspf.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import org.apache.james.jspf.core.LogEnabled;
import org.apache.james.jspf.core.Logger;
import org.apache.james.jspf.core.exceptions.PermErrorException;
import org.apache.james.jspf.impl.DefaultTermDefinition;
import org.apache.james.jspf.parser.TermDefinition;
import org.apache.james.jspf.parser.TermsFactory;
import org.apache.james.jspf.terms.Configuration;
import org.apache.james.jspf.terms.ConfigurationEnabled;
import org.apache.james.jspf.wiring.WiringService;
import org.apache.james.jspf.wiring.WiringServiceException;
import org.apache.james.jspf.wiring.WiringServiceTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTermsFactory
implements TermsFactory {
    private String termFile = "org/apache/james/jspf/parser/jspf.default.terms";
    private Collection<TermDefinition> mechanismsCollection;
    private Collection<TermDefinition> modifiersCollection;
    private Logger log;
    private WiringService wiringService;

    public DefaultTermsFactory(Logger log) {
        this.log = log;
        this.wiringService = new WiringServiceTable();
        ((WiringServiceTable)this.wiringService).put(LogEnabled.class, log);
        this.init();
    }

    public DefaultTermsFactory(Logger log, WiringService wiringService) {
        this.log = log;
        this.wiringService = wiringService;
        this.init();
    }

    private void init() {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.termFile);
            if (is == null) {
                throw new NullPointerException("Unable to find the " + this.termFile + " resource in the classpath");
            }
            Properties p = new Properties();
            p.load(is);
            String mechs = p.getProperty("mechanisms");
            String mods = p.getProperty("modifiers");
            String[] classes = mechs.split(",");
            Class[] knownMechanisms = new Class[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                this.log.debug("Add following class as known mechanismn: " + classes[i]);
                knownMechanisms[i] = Thread.currentThread().getContextClassLoader().loadClass(classes[i]);
            }
            this.mechanismsCollection = this.createTermDefinitionCollection(knownMechanisms);
            classes = mods.split(",");
            Class[] knownModifiers = new Class[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                this.log.debug("Add following class as known modifier: " + classes[i]);
                knownModifiers[i] = Thread.currentThread().getContextClassLoader().loadClass(classes[i]);
            }
            this.modifiersCollection = this.createTermDefinitionCollection(knownModifiers);
        }
        catch (IOException e) {
            throw new IllegalStateException("Term configuration cannot be found");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("One configured class cannot be found");
        }
    }

    private Collection<TermDefinition> createTermDefinitionCollection(Class<?>[] classes) {
        ArrayList<DefaultTermDefinition> l = new ArrayList<DefaultTermDefinition>();
        for (int j = 0; j < classes.length; ++j) {
            try {
                l.add(new DefaultTermDefinition(classes[j]));
                continue;
            }
            catch (Exception e) {
                this.log.debug("Unable to create the term collection", e);
                throw new IllegalStateException("Unable to create the term collection");
            }
        }
        return Collections.synchronizedCollection(l);
    }

    @Override
    public Object createTerm(Class<?> termDef, Configuration subres) throws PermErrorException, InstantiationException {
        try {
            Object term = termDef.newInstance();
            try {
                this.wiringService.wire(term);
            }
            catch (WiringServiceException e) {
                throw new InstantiationException("Unexpected error adding dependencies to term: " + e.getMessage());
            }
            if (term instanceof ConfigurationEnabled) {
                if (subres == null || subres.groupCount() == 0) {
                    ((ConfigurationEnabled)term).config(null);
                } else {
                    ((ConfigurationEnabled)term).config(subres);
                }
            }
            return term;
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Unexpected error creating term: " + e.getMessage());
        }
    }

    @Override
    public Collection<TermDefinition> getMechanismsCollection() {
        return this.mechanismsCollection;
    }

    @Override
    public Collection<TermDefinition> getModifiersCollection() {
        return this.modifiersCollection;
    }
}

