/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.api;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.ProtocolTransport;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.StartTlsResponse;
import org.apache.james.protocols.api.StreamResponse;

public abstract class AbstractProtocolTransport
implements ProtocolTransport {
    private static final String CRLF = "\r\n";

    @Override
    public final void writeResponse(Response response, ProtocolSession session) {
        if (response != null) {
            boolean startTLS = false;
            if (response instanceof StartTlsResponse) {
                if (this.isStartTLSSupported()) {
                    startTLS = true;
                } else {
                    throw new UnsupportedOperationException("StartTls is not supported by this ProtocolTransport implementation");
                }
            }
            if (response instanceof StreamResponse) {
                this.writeToClient(AbstractProtocolTransport.toBytes(response), session, false);
                this.writeToClient(((StreamResponse)response).getStream(), session, startTLS);
            } else {
                this.writeToClient(AbstractProtocolTransport.toBytes(response), session, startTLS);
            }
            if (startTLS) {
                session.resetState();
                session.stopDetectingCommandInjection();
            }
            if (response.isEndSession()) {
                this.close();
            }
        }
    }

    protected static byte[] toBytes(Response response) {
        StringBuilder builder = new StringBuilder();
        List<CharSequence> lines = response.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            builder.append(lines.get(i));
            if (i >= lines.size()) continue;
            builder.append(CRLF);
        }
        return builder.toString().getBytes(StandardCharsets.US_ASCII);
    }

    protected abstract void writeToClient(byte[] var1, ProtocolSession var2, boolean var3);

    protected abstract void writeToClient(InputStream var1, ProtocolSession var2, boolean var3);

    protected abstract void close();
}

