/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.data.jackson.jersey;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.FutureUtils;
import io.servicetalk.data.jackson.JacksonSerializationProvider;
import io.servicetalk.data.jackson.JacksonSerializerFactory;
import io.servicetalk.http.router.jersey.internal.BufferPublisherInputStream;
import io.servicetalk.http.router.jersey.internal.RequestProperties;
import io.servicetalk.http.router.jersey.internal.SourceWrappers;
import io.servicetalk.serialization.api.DefaultSerializer;
import io.servicetalk.serialization.api.SerializationException;
import io.servicetalk.serialization.api.SerializationProvider;
import io.servicetalk.serializer.api.Deserializer;
import io.servicetalk.serializer.api.Serializer;
import io.servicetalk.serializer.api.SerializerDeserializer;
import io.servicetalk.serializer.api.StreamingSerializerDeserializer;
import io.servicetalk.transport.api.ConnectionContext;
import io.servicetalk.transport.api.ExecutionContext;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.NoSuchElementException;
import java.util.concurrent.Future;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.model.ResourceMethod;

@Priority(value=4100)
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
final class JacksonSerializerMessageBodyReaderWriter
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    @Context
    private Provider<Ref<ConnectionContext>> ctxRefProvider;
    @Context
    private Provider<ContainerRequestContext> requestCtxProvider;
    @Context
    private Providers providers;
    @Context
    private HttpHeaders headers;

    JacksonSerializerMessageBodyReaderWriter() {
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JacksonSerializerMessageBodyReaderWriter.isSupportedMediaType(mediaType);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        boolean oldJacksonProviderPresent;
        boolean bl = oldJacksonProviderPresent = this.providers.getContextResolver(JacksonSerializationProvider.class, mediaType) != null;
        if (oldJacksonProviderPresent) {
            return this.readFromOld(type, genericType, annotations, mediaType, httpHeaders, entityStream);
        }
        JacksonSerializerFactory serializerFactory = this.getJacksonSerializerFactory(mediaType);
        ExecutionContext executionContext = ((ConnectionContext)((Ref)this.ctxRefProvider.get()).get()).executionContext();
        BufferAllocator allocator = executionContext.bufferAllocator();
        int contentLength = ((ContainerRequestContext)this.requestCtxProvider.get()).getLength();
        if (Single.class.isAssignableFrom(type)) {
            return BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)allocator, (p, a) -> JacksonSerializerMessageBodyReaderWriter.deserialize((Publisher<Buffer>)p, serializerFactory.serializerDeserializer(JacksonSerializerMessageBodyReaderWriter.getSourceClass(genericType)), contentLength, a), (is, a) -> new SourceWrappers.SingleSource(JacksonSerializerMessageBodyReaderWriter.deserialize(JacksonSerializerMessageBodyReaderWriter.toBufferPublisher(is, a), serializerFactory.serializerDeserializer(JacksonSerializerMessageBodyReaderWriter.getSourceClass(genericType)), contentLength, a)));
        }
        if (Publisher.class.isAssignableFrom(type)) {
            return BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)allocator, (p, a) -> serializerFactory.streamingSerializerDeserializer(JacksonSerializerMessageBodyReaderWriter.getSourceClass(genericType)).deserialize(p, a), (is, a) -> new SourceWrappers.PublisherSource(serializerFactory.streamingSerializerDeserializer(JacksonSerializerMessageBodyReaderWriter.getSourceClass(genericType)).deserialize(JacksonSerializerMessageBodyReaderWriter.toBufferPublisher(is, a), a)));
        }
        return BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)allocator, (p, a) -> JacksonSerializerMessageBodyReaderWriter.deserializeObject((Publisher<Buffer>)p, serializerFactory.serializerDeserializer(type), contentLength, a), (is, a) -> JacksonSerializerMessageBodyReaderWriter.deserializeObject(JacksonSerializerMessageBodyReaderWriter.toBufferPublisher(is, a), serializerFactory.serializerDeserializer(type), contentLength, a));
    }

    @Deprecated
    private Object readFromOld(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws WebApplicationException {
        io.servicetalk.serialization.api.Serializer serializer = this.getSerializer(mediaType);
        ExecutionContext executionContext = ((ConnectionContext)((Ref)this.ctxRefProvider.get()).get()).executionContext();
        BufferAllocator allocator = executionContext.bufferAllocator();
        int contentLength = ((ContainerRequestContext)this.requestCtxProvider.get()).getLength();
        if (Single.class.isAssignableFrom(type)) {
            return BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)allocator, (p, a) -> JacksonSerializerMessageBodyReaderWriter.deserializeOld((Publisher<Buffer>)p, serializer, JacksonSerializerMessageBodyReaderWriter.getSourceClass(genericType), contentLength, a), (is, a) -> new SourceWrappers.SingleSource(JacksonSerializerMessageBodyReaderWriter.deserializeOld(JacksonSerializerMessageBodyReaderWriter.toBufferPublisher(is, a), serializer, JacksonSerializerMessageBodyReaderWriter.getSourceClass(genericType), contentLength, a)));
        }
        if (Publisher.class.isAssignableFrom(type)) {
            return BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)allocator, (p, a) -> serializer.deserialize(p, JacksonSerializerMessageBodyReaderWriter.getSourceClass(genericType)), (is, a) -> new SourceWrappers.PublisherSource(serializer.deserialize(JacksonSerializerMessageBodyReaderWriter.toBufferPublisher(is, a), JacksonSerializerMessageBodyReaderWriter.getSourceClass(genericType))));
        }
        return BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)allocator, (p, a) -> JacksonSerializerMessageBodyReaderWriter.deserializeObjectOld((Publisher<Buffer>)p, serializer, type, contentLength, a), (is, a) -> JacksonSerializerMessageBodyReaderWriter.deserializeObjectOld(JacksonSerializerMessageBodyReaderWriter.toBufferPublisher(is, a), serializer, type, contentLength, a));
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !JacksonSerializerMessageBodyReaderWriter.isSse((ContainerRequestContext)this.requestCtxProvider.get()) && JacksonSerializerMessageBodyReaderWriter.isSupportedMediaType(mediaType);
    }

    @Deprecated
    private void writeToOld(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        Publisher<Buffer> bufferPublisher = o instanceof Single ? this.getResponseBufferPublisher(((Single)o).toPublisher(), genericType, mediaType) : (o instanceof Publisher ? this.getResponseBufferPublisher((Publisher)o, genericType, mediaType) : this.getResponseBufferPublisher(Publisher.from((Object)o), o.getClass(), mediaType));
        RequestProperties.setResponseBufferPublisher(bufferPublisher, (ContainerRequestContext)((ContainerRequestContext)this.requestCtxProvider.get()));
    }

    private Publisher<Buffer> getResponseBufferPublisher(Publisher publisher, Type type, MediaType mediaType) {
        BufferAllocator allocator = ((ConnectionContext)((Ref)this.ctxRefProvider.get()).get()).executionContext().bufferAllocator();
        return this.getSerializer(mediaType).serialize(publisher, allocator, type instanceof Class ? (Class)type : JacksonSerializerMessageBodyReaderWriter.getSourceClass(type));
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws WebApplicationException {
        Publisher bufferPublisher;
        boolean oldJacksonProviderPresent;
        boolean bl = oldJacksonProviderPresent = this.providers.getContextResolver(JacksonSerializationProvider.class, mediaType) != null;
        if (oldJacksonProviderPresent) {
            this.writeToOld(o, type, genericType, annotations, mediaType, httpHeaders, entityStream);
            return;
        }
        BufferAllocator allocator = ((ConnectionContext)((Ref)this.ctxRefProvider.get()).get()).executionContext().bufferAllocator();
        if (o instanceof Single) {
            Class clazz = genericType instanceof Class ? (Class)genericType : JacksonSerializerMessageBodyReaderWriter.getSourceClass(genericType);
            SerializerDeserializer serializer = this.getJacksonSerializerFactory(mediaType).serializerDeserializer(clazz);
            bufferPublisher = ((Single)o).map(arg_0 -> JacksonSerializerMessageBodyReaderWriter.lambda$writeTo$12((Serializer)serializer, allocator, arg_0)).toPublisher();
        } else if (o instanceof Publisher) {
            Class clazz = genericType instanceof Class ? (Class)genericType : JacksonSerializerMessageBodyReaderWriter.getSourceClass(genericType);
            StreamingSerializerDeserializer serializer = this.getJacksonSerializerFactory(mediaType).streamingSerializerDeserializer(clazz);
            bufferPublisher = serializer.serialize((Publisher)o, allocator);
        } else {
            SerializerDeserializer serializer = this.getJacksonSerializerFactory(mediaType).serializerDeserializer(o.getClass());
            bufferPublisher = Publisher.from((Object)serializer.serialize(o, allocator));
        }
        RequestProperties.setResponseBufferPublisher((Publisher)bufferPublisher, (ContainerRequestContext)((ContainerRequestContext)this.requestCtxProvider.get()));
    }

    private JacksonSerializerFactory getJacksonSerializerFactory(MediaType mediaType) {
        ContextResolver contextResolver = this.providers.getContextResolver(JacksonSerializerFactory.class, mediaType);
        return contextResolver != null ? (JacksonSerializerFactory)contextResolver.getContext(JacksonSerializerFactory.class) : JacksonSerializerFactory.JACKSON;
    }

    private static Publisher<Buffer> toBufferPublisher(InputStream is, BufferAllocator a) {
        return Publisher.fromInputStream((InputStream)is).map(arg_0 -> ((BufferAllocator)a).wrap(arg_0));
    }

    @Deprecated
    private io.servicetalk.serialization.api.Serializer getSerializer(MediaType mediaType) {
        return new DefaultSerializer((SerializationProvider)this.getOldJacksonSerializer(mediaType));
    }

    @Deprecated
    private static <T> T deserializeObjectOld(Publisher<Buffer> bufferPublisher, io.servicetalk.serialization.api.Serializer ser, Class<T> type, int contentLength, BufferAllocator allocator) {
        return (T)FutureUtils.awaitResult((Future)JacksonSerializerMessageBodyReaderWriter.deserializeOld(bufferPublisher, ser, type, contentLength, allocator).toFuture());
    }

    private JacksonSerializationProvider getOldJacksonSerializer(MediaType mediaType) {
        ContextResolver contextResolver = this.providers.getContextResolver(JacksonSerializationProvider.class, mediaType);
        return (JacksonSerializationProvider)contextResolver.getContext(JacksonSerializationProvider.class);
    }

    @Deprecated
    private static <T> Single<T> deserializeOld(Publisher<Buffer> bufferPublisher, io.servicetalk.serialization.api.Serializer ser, Class<T> type, int contentLength, BufferAllocator allocator) {
        return bufferPublisher.collect(() -> JacksonSerializerMessageBodyReaderWriter.newBufferForRequestContent(contentLength, allocator), Buffer::writeBytes).map(buf -> {
            try {
                return ser.deserializeAggregatedSingle(buf, type);
            }
            catch (NoSuchElementException e) {
                throw new BadRequestException("No deserializable JSON content", (Throwable)e);
            }
            catch (SerializationException e) {
                throw new BadRequestException("Invalid JSON data", (Throwable)e);
            }
        });
    }

    private static <T> Single<T> deserialize(Publisher<Buffer> bufferPublisher, Deserializer<T> deserializer, int contentLength, BufferAllocator allocator) {
        return bufferPublisher.collect(() -> JacksonSerializerMessageBodyReaderWriter.newBufferForRequestContent(contentLength, allocator), Buffer::writeBytes).map(buf -> {
            try {
                return deserializer.deserialize(buf, allocator);
            }
            catch (NoSuchElementException e) {
                throw new BadRequestException("No deserializable JSON content", (Throwable)e);
            }
            catch (io.servicetalk.serializer.api.SerializationException e) {
                throw new BadRequestException("Invalid JSON data", (Throwable)e);
            }
        });
    }

    static Buffer newBufferForRequestContent(int contentLength, BufferAllocator allocator) {
        return contentLength == -1 ? allocator.newBuffer() : allocator.newBuffer(contentLength);
    }

    static <T> T deserializeObject(Publisher<Buffer> bufferPublisher, Deserializer<T> deserializer, int contentLength, BufferAllocator allocator) {
        return (T)FutureUtils.awaitResult((Future)JacksonSerializerMessageBodyReaderWriter.deserialize(bufferPublisher, deserializer, contentLength, allocator).toFuture());
    }

    private static boolean isSse(ContainerRequestContext requestCtx) {
        ResourceMethod method = ((ExtendedUriInfo)requestCtx.getUriInfo()).getMatchedResourceMethod();
        return method != null && method.isSse();
    }

    private static boolean isSupportedMediaType(MediaType mediaType) {
        return mediaType.getType().equalsIgnoreCase(MediaType.APPLICATION_JSON_TYPE.getType()) && (mediaType.getSubtype().equalsIgnoreCase(MediaType.APPLICATION_JSON_TYPE.getSubtype()) || mediaType.getSubtype().toLowerCase().endsWith('+' + MediaType.APPLICATION_JSON_TYPE.getSubtype()));
    }

    private static <T> Class<T> getSourceClass(Type sourceType) {
        Type sourceContentType = ((ParameterizedType)sourceType).getActualTypeArguments()[0];
        if (sourceContentType instanceof Class) {
            return (Class)sourceContentType;
        }
        if (sourceContentType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)sourceContentType).getRawType();
        }
        throw new IllegalArgumentException("Unsupported source type: " + sourceType);
    }

    private static /* synthetic */ Object lambda$writeTo$12(Serializer serializer, BufferAllocator allocator, Object t) {
        return serializer.serialize(t, allocator);
    }
}

