/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.postgres;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.DoubleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.FloatValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IntegerValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LongValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ShortValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.StringValueHandler;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.baremaps.database.copy.CopyWriter;
import org.apache.baremaps.database.copy.PostgisGeometryValueHandler;
import org.apache.baremaps.feature.Feature;
import org.apache.baremaps.feature.FeatureSet;
import org.apache.baremaps.feature.FeatureType;
import org.apache.baremaps.feature.PropertyType;
import org.apache.baremaps.feature.ReadableFeatureSet;
import org.apache.baremaps.feature.Resource;
import org.apache.baremaps.feature.WritableAggregate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.postgresql.PGConnection;
import org.postgresql.copy.PGCopyOutputStream;

public class PostgresDatabase
implements WritableAggregate {
    private static Map<Class, String> typeToName = new HashMap<Class, String>();
    private static Map<Class, BaseValueHandler> typeToHandler;
    private final DataSource dataSource;

    public PostgresDatabase(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private FeatureType createFeatureType(FeatureType featureType) {
        String name = featureType.getName().replaceAll("[^a-zA-Z0-9]", "_");
        Map<String, PropertyType> properties = featureType.getProperties().values().stream().filter(type -> typeToName.containsKey(type.getType())).collect(Collectors.toMap(k -> k.getName(), v -> v));
        return new FeatureType(name, properties);
    }

    @Override
    public void write(Resource resource) throws IOException {
        if (resource instanceof ReadableFeatureSet) {
            ReadableFeatureSet featureSetReader = (ReadableFeatureSet)resource;
            try (Connection connection = this.dataSource.getConnection();){
                FeatureType featureType = this.createFeatureType(featureSetReader.getType());
                String dropQuery = this.dropTable(featureType);
                try (PreparedStatement dropStatement = connection.prepareStatement(dropQuery);){
                    dropStatement.execute();
                }
                String createQuery = this.createTable(featureType);
                try (PreparedStatement createStatement = connection.prepareStatement(createQuery);){
                    createStatement.execute();
                }
                PGConnection pgConnection = connection.unwrap(PGConnection.class);
                String copyQuery = this.copyTable(featureType);
                try (CopyWriter writer = new CopyWriter(new PGCopyOutputStream(pgConnection, copyQuery));){
                    writer.writeHeader();
                    Iterator featureIterator = featureSetReader.read().iterator();
                    while (featureIterator.hasNext()) {
                        Feature feature = (Feature)featureIterator.next();
                        List<PropertyType> attributes = this.getAttributes(featureType);
                        writer.startRow(attributes.size());
                        for (PropertyType attribute : attributes) {
                            String name = attribute.getName().toString();
                            Object value = feature.getProperty(name);
                            if (value == null) {
                                writer.writeNull();
                                continue;
                            }
                            writer.write(typeToHandler.get(value.getClass()), value);
                        }
                    }
                }
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
    }

    private List<PropertyType> getAttributes(FeatureType featureType) {
        return featureType.getProperties().values().stream().filter(this::isSupported).collect(Collectors.toList());
    }

    private boolean isSupported(PropertyType propertyType) {
        return typeToName.containsKey(propertyType.getType());
    }

    private String createTable(FeatureType featureType) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE ");
        builder.append(featureType.getName());
        builder.append(" (");
        builder.append(featureType.getProperties().values().stream().map(attributeType -> attributeType.getName() + " " + typeToName.get(attributeType.getType())).collect(Collectors.joining(", ")));
        builder.append(")");
        return builder.toString();
    }

    private String copyTable(FeatureType featureType) {
        StringBuilder builder = new StringBuilder();
        builder.append("COPY ");
        builder.append(featureType.getName());
        builder.append(" (");
        builder.append(featureType.getProperties().values().stream().map(propertyType -> propertyType.getName()).collect(Collectors.joining(", ")));
        builder.append(") FROM STDIN BINARY");
        return builder.toString();
    }

    @Override
    public void remove(Resource resource) throws IOException {
        if (resource instanceof FeatureSet) {
            FeatureSet featureSet = (FeatureSet)resource;
            FeatureType type = featureSet.getType();
            try (Connection connection = this.dataSource.getConnection();
                 Statement statement = connection.createStatement();){
                statement.executeQuery(String.format("DROP TABLE IF EXISTS %s CASCADE", type.getName()));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String dropTable(FeatureType type) {
        return String.format("DROP TABLE IF EXISTS %s CASCADE", type.getName());
    }

    static {
        typeToName.put(String.class, "varchar");
        typeToName.put(Short.class, "int2");
        typeToName.put(Integer.class, "int4");
        typeToName.put(Long.class, "int8");
        typeToName.put(Float.class, "float4");
        typeToName.put(Double.class, "float8");
        typeToName.put(Geometry.class, "geometry");
        typeToName.put(Point.class, "geometry");
        typeToName.put(MultiPoint.class, "geometry");
        typeToName.put(Point.class, "geometry");
        typeToName.put(LineString.class, "geometry");
        typeToName.put(MultiLineString.class, "geometry");
        typeToName.put(Polygon.class, "geometry");
        typeToName.put(MultiPolygon.class, "geometry");
        typeToName.put(LinearRing.class, "geometry");
        typeToName.put(GeometryCollection.class, "geometry");
        typeToName.put(LocalDate.class, "date");
        typeToName.put(LocalTime.class, "time");
        typeToName.put(LocalDateTime.class, "timestamp");
        typeToHandler = new HashMap<Class, BaseValueHandler>();
        typeToHandler.put(String.class, (BaseValueHandler)new StringValueHandler());
        typeToHandler.put(Short.class, (BaseValueHandler)new ShortValueHandler());
        typeToHandler.put(Integer.class, (BaseValueHandler)new IntegerValueHandler());
        typeToHandler.put(Long.class, (BaseValueHandler)new LongValueHandler());
        typeToHandler.put(Float.class, (BaseValueHandler)new FloatValueHandler());
        typeToHandler.put(Double.class, (BaseValueHandler)new DoubleValueHandler());
        typeToHandler.put(Geometry.class, new PostgisGeometryValueHandler());
        typeToHandler.put(Point.class, new PostgisGeometryValueHandler());
        typeToHandler.put(MultiPoint.class, new PostgisGeometryValueHandler());
        typeToHandler.put(Point.class, new PostgisGeometryValueHandler());
        typeToHandler.put(LineString.class, new PostgisGeometryValueHandler());
        typeToHandler.put(MultiLineString.class, new PostgisGeometryValueHandler());
        typeToHandler.put(Polygon.class, new PostgisGeometryValueHandler());
        typeToHandler.put(MultiPolygon.class, new PostgisGeometryValueHandler());
        typeToHandler.put(LinearRing.class, new PostgisGeometryValueHandler());
        typeToHandler.put(GeometryCollection.class, new PostgisGeometryValueHandler());
        typeToHandler.put(LocalDate.class, (BaseValueHandler)new LocalDateValueHandler());
        typeToHandler.put(LocalTime.class, (BaseValueHandler)new LocalTimeValueHandler());
        typeToHandler.put(LocalDateTime.class, (BaseValueHandler)new LocalDateTimeValueHandler());
    }
}

