/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.collection.type.DataType;

public class DoubleListDataType
implements DataType<List<Double>> {
    @Override
    public int size(List<Double> values) {
        return 4 + values.size() * 8;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Double> values) {
        buffer.putInt(position, this.size(values));
        position += 4;
        for (Double value : values) {
            buffer.putDouble(position, value);
            position += 8;
        }
    }

    @Override
    public List<Double> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        ArrayList<Double> list = new ArrayList<Double>(size);
        for (int p = position + 4; p < position + size; p += 8) {
            list.add(buffer.getDouble(p));
        }
        return list;
    }
}

