/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.http.api.DefaultHttpCookiePair;
import io.servicetalk.http.api.DefaultHttpSetCookie;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpCookiePair;
import io.servicetalk.http.api.HttpSetCookie;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

public interface HttpHeaders
extends Iterable<Map.Entry<CharSequence, CharSequence>> {
    @Nullable
    public CharSequence get(CharSequence var1);

    default public CharSequence get(CharSequence name, CharSequence defaultValue) {
        CharSequence value = this.get(name);
        return value != null ? value : defaultValue;
    }

    @Nullable
    public CharSequence getAndRemove(CharSequence var1);

    default public CharSequence getAndRemove(CharSequence name, CharSequence defaultValue) {
        CharSequence value = this.getAndRemove(name);
        return value == null ? defaultValue : value;
    }

    default public Iterable<? extends CharSequence> values(CharSequence name) {
        return () -> this.valuesIterator(name);
    }

    public Iterator<? extends CharSequence> valuesIterator(CharSequence var1);

    default public boolean contains(CharSequence name) {
        return this.get(name) != null;
    }

    public boolean contains(CharSequence var1, CharSequence var2);

    public boolean containsIgnoreCase(CharSequence var1, CharSequence var2);

    public int size();

    public boolean isEmpty();

    public Set<? extends CharSequence> names();

    public HttpHeaders add(CharSequence var1, CharSequence var2);

    public HttpHeaders add(CharSequence var1, Iterable<? extends CharSequence> var2);

    default public HttpHeaders add(CharSequence name, Iterator<? extends CharSequence> valuesItr) {
        while (valuesItr.hasNext()) {
            this.add(name, valuesItr.next());
        }
        return this;
    }

    public HttpHeaders add(CharSequence var1, CharSequence ... var2);

    public HttpHeaders add(HttpHeaders var1);

    public HttpHeaders set(CharSequence var1, CharSequence var2);

    public HttpHeaders set(CharSequence var1, Iterable<? extends CharSequence> var2);

    default public HttpHeaders set(CharSequence name, Iterator<? extends CharSequence> valueItr) {
        this.remove(name);
        while (valueItr.hasNext()) {
            this.add(name, valueItr.next());
        }
        return this;
    }

    public HttpHeaders set(CharSequence var1, CharSequence ... var2);

    default public HttpHeaders set(HttpHeaders headers) {
        if (headers != this) {
            this.clear();
            this.add(headers);
        }
        return this;
    }

    default public HttpHeaders replace(HttpHeaders headers) {
        if (headers != this) {
            for (CharSequence charSequence : headers.names()) {
                this.remove(charSequence);
            }
            this.add(headers);
        }
        return this;
    }

    public boolean remove(CharSequence var1);

    public boolean remove(CharSequence var1, CharSequence var2);

    public boolean removeIgnoreCase(CharSequence var1, CharSequence var2);

    public HttpHeaders clear();

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator();

    @Override
    default public Spliterator<Map.Entry<CharSequence, CharSequence>> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 64);
    }

    public String toString();

    default public String toString(BiFunction<? super CharSequence, ? super CharSequence, CharSequence> filter) {
        return HeaderUtils.toString(this, filter);
    }

    @Nullable
    public HttpCookiePair getCookie(CharSequence var1);

    @Nullable
    public HttpSetCookie getSetCookie(CharSequence var1);

    default public Iterable<? extends HttpCookiePair> getCookies() {
        return () -> this.getCookiesIterator();
    }

    public Iterator<? extends HttpCookiePair> getCookiesIterator();

    default public Iterable<? extends HttpCookiePair> getCookies(CharSequence name) {
        return () -> this.getCookiesIterator(name);
    }

    public Iterator<? extends HttpCookiePair> getCookiesIterator(CharSequence var1);

    default public Iterable<? extends HttpSetCookie> getSetCookies() {
        return () -> this.getSetCookiesIterator();
    }

    public Iterator<? extends HttpSetCookie> getSetCookiesIterator();

    default public Iterable<? extends HttpSetCookie> getSetCookies(CharSequence name) {
        return () -> this.getSetCookiesIterator(name);
    }

    public Iterator<? extends HttpSetCookie> getSetCookiesIterator(CharSequence var1);

    default public Iterable<? extends HttpSetCookie> getSetCookies(CharSequence name, CharSequence domain, CharSequence path) {
        return () -> this.getSetCookiesIterator(name, domain, path);
    }

    public Iterator<? extends HttpSetCookie> getSetCookiesIterator(CharSequence var1, CharSequence var2, CharSequence var3);

    public HttpHeaders addCookie(HttpCookiePair var1);

    default public HttpHeaders addCookie(CharSequence name, CharSequence value) {
        return this.addCookie(new DefaultHttpCookiePair(name, value));
    }

    public HttpHeaders addSetCookie(HttpSetCookie var1);

    default public HttpHeaders addSetCookie(CharSequence name, CharSequence value) {
        return this.addSetCookie(new DefaultHttpSetCookie(name, value));
    }

    public boolean removeCookies(CharSequence var1);

    public boolean removeSetCookies(CharSequence var1);

    public boolean removeSetCookies(CharSequence var1, CharSequence var2, CharSequence var3);
}

