/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.deprecated.spec;

import org.apache.ignite.internal.cli.deprecated.IgniteCliException;
import picocli.CommandLine;

class NodeEndpointOptions {
    @CommandLine.Option(names={"--node-endpoint"}, description={"Ignite server node's REST API address and port number"}, paramLabel="host:port")
    private String endpoint;

    NodeEndpointOptions() {
    }

    int port() {
        if (this.endpoint == null) {
            return 10300;
        }
        String[] hostPort = this.parse();
        try {
            return Integer.parseInt(hostPort[1]);
        }
        catch (NumberFormatException ex) {
            throw new IgniteCliException("Can't parse port from " + hostPort[1] + " value");
        }
    }

    String host() {
        return this.endpoint != null ? this.parse()[0] : "localhost";
    }

    private String[] parse() {
        String[] hostPort = this.endpoint.split(":");
        if (hostPort.length != 2) {
            throw new IgniteCliException("Incorrect host:port pair provided: '" + this.endpoint + "' (example of valid value 'localhost:10300')");
        }
        return hostPort;
    }
}

