/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.affinity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import org.apache.ignite.internal.affinity.RendezvousAffinityFunction;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.NotNull;

public class AffinityUtils {
    public static <T extends Collection<ClusterNode>> List<T> calculateAssignments(@NotNull Collection<ClusterNode> baselineNodes, int partitions, int replicas, IntFunction<T> aggregator) {
        return RendezvousAffinityFunction.assignPartitions(baselineNodes, partitions, replicas, false, null, aggregator);
    }

    public static List<List<ClusterNode>> calculateAssignments(@NotNull Collection<ClusterNode> baselineNodes, int partitions, int replicas) {
        return AffinityUtils.calculateAssignments(baselineNodes, partitions, replicas, ArrayList::new);
    }

    public static Set<ClusterNode> calculateAssignmentForPartition(Collection<ClusterNode> baselineNodes, int partition, int replicas) {
        return RendezvousAffinityFunction.assignPartition(partition, new ArrayList<ClusterNode>(baselineNodes), replicas, null, false, null, HashSet::new);
    }
}

