/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.AtomicLongMetric;
import org.apache.ignite.internal.processors.metric.impl.LongAdderMetric;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.spi.metric.Metric;

public class ZookeeperDiscoveryStatistics {
    private final LongAdderMetric joinedNodesCnt = new LongAdderMetric(MetricUtils.metricName((String[])new String[]{GridDiscoveryManager.DISCO_METRICS, "JoinedNodes"}), "Joined nodes count");
    private final LongAdderMetric failedNodesCnt = new LongAdderMetric(MetricUtils.metricName((String[])new String[]{GridDiscoveryManager.DISCO_METRICS, "FailedNodes"}), "Failed nodes count");
    private final LongAdderMetric leftNodesCnt = new LongAdderMetric(MetricUtils.metricName((String[])new String[]{GridDiscoveryManager.DISCO_METRICS, "LeftNodes"}), "Left nodes count");
    private final LongAdderMetric commErrCnt = new LongAdderMetric(MetricUtils.metricName((String[])new String[]{GridDiscoveryManager.DISCO_METRICS, "CommunicationErrors"}), "Communication errors count");
    private final AtomicLongMetric topVer = new AtomicLongMetric(MetricUtils.metricName((String[])new String[]{GridDiscoveryManager.DISCO_METRICS, "CurrentTopologyVersion"}), "Current topology version");

    public void registerMetrics(MetricRegistry discoReg) {
        discoReg.register((Metric)this.joinedNodesCnt);
        discoReg.register((Metric)this.failedNodesCnt);
        discoReg.register((Metric)this.leftNodesCnt);
        discoReg.register((Metric)this.commErrCnt);
        discoReg.register((Metric)this.topVer);
    }

    public long joinedNodesCnt() {
        return this.joinedNodesCnt.value();
    }

    public long failedNodesCnt() {
        return this.failedNodesCnt.value();
    }

    public long leftNodesCnt() {
        return this.leftNodesCnt.value();
    }

    public long commErrorCount() {
        return this.commErrCnt.value();
    }

    public void onNodeJoined() {
        this.joinedNodesCnt.increment();
    }

    public void onNodeFailed() {
        this.failedNodesCnt.increment();
    }

    public void onNodeLeft() {
        this.leftNodesCnt.increment();
    }

    public void onCommunicationError() {
        this.commErrCnt.increment();
    }

    public void onTopologyChanged(long topVer) {
        this.topVer.value(topVer);
    }

    public String toString() {
        return S.toString(ZookeeperDiscoveryStatistics.class, (Object)this);
    }
}

