/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.metadata;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.processors.query.calcite.message.MarshalableMessage;
import org.apache.ignite.internal.processors.query.calcite.message.MarshallingContext;
import org.apache.ignite.internal.processors.query.calcite.message.MessageType;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.metadata.FragmentMapping;
import org.apache.ignite.internal.util.UUIDCollectionMessage;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class FragmentDescription
implements MarshalableMessage {
    private long fragmentId;
    private FragmentMapping mapping;
    private ColocationGroup target;
    @GridDirectTransient
    private Map<Long, List<UUID>> remoteSources;
    @GridDirectMap(keyType=Long.class, valueType=Message.class)
    private Map<Long, UUIDCollectionMessage> remoteSources0;

    public FragmentDescription() {
    }

    public FragmentDescription(long fragmentId, FragmentMapping mapping, ColocationGroup target, Map<Long, List<UUID>> remoteSources) {
        this.fragmentId = fragmentId;
        this.mapping = mapping;
        this.target = target;
        this.remoteSources = remoteSources;
    }

    public long fragmentId() {
        return this.fragmentId;
    }

    public List<UUID> nodeIds() {
        return this.mapping.nodeIds();
    }

    public ColocationGroup target() {
        return this.target;
    }

    public Map<Long, List<UUID>> remotes() {
        return this.remoteSources;
    }

    public FragmentMapping mapping() {
        return this.mapping;
    }

    @Override
    public MessageType type() {
        return MessageType.FRAGMENT_DESCRIPTION;
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeLong("fragmentId", this.fragmentId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("mapping", (Message)this.mapping)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeMap("remoteSources0", this.remoteSources0, MessageCollectionItemType.LONG, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeMessage("target", (Message)this.target)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.fragmentId = reader.readLong("fragmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.mapping = (FragmentMapping)reader.readMessage("mapping");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.remoteSources0 = reader.readMap("remoteSources0", MessageCollectionItemType.LONG, MessageCollectionItemType.MSG, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.target = (ColocationGroup)reader.readMessage("target");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FragmentDescription.class);
    }

    public byte fieldsCount() {
        return 4;
    }

    @Override
    public void prepareMarshal(MarshallingContext ctx) {
        if (this.mapping != null) {
            this.mapping.prepareMarshal(ctx);
        }
        if (this.target != null) {
            this.target.prepareMarshal(ctx);
        }
        if (this.remoteSources0 == null && this.remoteSources != null) {
            this.remoteSources0 = U.newHashMap((int)this.remoteSources.size());
            for (Map.Entry<Long, List<UUID>> e : this.remoteSources.entrySet()) {
                this.remoteSources0.put(e.getKey(), new UUIDCollectionMessage((Collection)e.getValue()));
            }
        }
    }

    @Override
    public void prepareUnmarshal(MarshallingContext ctx) {
        if (this.mapping != null) {
            this.mapping.prepareUnmarshal(ctx);
        }
        if (this.target != null) {
            this.target.prepareUnmarshal(ctx);
        }
        if (this.remoteSources == null && this.remoteSources0 != null) {
            this.remoteSources = U.newHashMap((int)this.remoteSources0.size());
            for (Map.Entry<Long, UUIDCollectionMessage> e : this.remoteSources0.entrySet()) {
                this.remoteSources.put(e.getKey(), new ArrayList(e.getValue().uuids()));
            }
        }
    }
}

