/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.tracker;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.MemoryTracker;

public class QueryMemoryTracker
implements MemoryTracker {
    private final MemoryTracker parent;
    private final long quota;
    private final AtomicLong allocated = new AtomicLong();

    public QueryMemoryTracker(MemoryTracker parent, long quota) {
        this.parent = parent;
        this.quota = quota;
    }

    @Override
    public void onMemoryAllocated(long size) {
        try {
            if (this.allocated.addAndGet(size) > this.quota && this.quota > 0L) {
                throw new IgniteException("Query quota exceeded [quota=" + this.quota + ']');
            }
            this.parent.onMemoryAllocated(size);
        }
        catch (Exception e) {
            this.release(size);
            throw e;
        }
    }

    @Override
    public void onMemoryReleased(long size) {
        long released = this.release(size);
        if (released > 0L) {
            this.parent.onMemoryReleased(released);
        }
    }

    private long release(long size) {
        long released;
        long wasAllocated;
        while (!this.allocated.compareAndSet(wasAllocated = this.allocated.get(), wasAllocated - (released = Math.min(size, wasAllocated)))) {
        }
        return released;
    }

    @Override
    public void reset() {
        long wasAllocated = this.allocated.getAndSet(0L);
        if (wasAllocated > 0L) {
            this.parent.onMemoryReleased(wasAllocated);
        }
    }

    @Override
    public long allocated() {
        return this.allocated.get();
    }
}

