/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.tracker;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.ToLongBiFunction;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.ignite.internal.binary.BinaryArray;
import org.apache.ignite.internal.binary.BinaryEnumArray;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectOffheapImpl;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.IterableAccumulator;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ObjectSizeCalculator<Row> {
    private static final Map<Class<?>, SizeCalculator<?>> SYS_CLS_SIZE = new IdentityHashMap();
    private static final long OBJ_HEADER_SIZE = GridUnsafe.objectFieldOffset((Field)U.findField(Dummy.class, (String)"field"));
    public static final long OBJ_REF_SIZE = GridUnsafe.arrayIndexScale(Object[].class);
    private static final long OBJ_ALIGN = ObjectSizeCalculator.calcAlign();
    public static final long HASH_MAP_ENTRY_SIZE = ClassInfo.access$000(ObjectSizeCalculator.classInfo(new HashMap(F.asMap((Object)0, (Object)0)).entrySet().iterator().next().getClass()));
    private final Map<Class<?>, ClassInfo> clsInfoCache = new IdentityHashMap();
    private final Map<Object, Object> processedObjs = new IdentityHashMap<Object, Object>();

    private static long calcAlign() {
        return OBJ_REF_SIZE == 8L ? 8L : (long)U.nearestPow2((int)Math.max(8, (int)(Runtime.getRuntime().maxMemory() >> 32)), (boolean)false);
    }

    private static <T> void addSysClsSize(Class<T> cls, @Nullable ToLongBiFunction<ObjectSizeCalculator<?>, T> extraSizeCalc) {
        SYS_CLS_SIZE.put(cls, new SizeCalculatorImpl(cls, extraSizeCalc));
    }

    private static ClassInfo classInfo(Class<?> cls) {
        long size = 0L;
        ArrayList<Field> refFields = new ArrayList<Field>();
        while (cls != null && cls != Object.class) {
            for (Field f : cls.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                size = Math.max(size, GridUnsafe.objectFieldOffset((Field)f) + ObjectSizeCalculator.fieldHolderSize(f));
                if (f.getDeclaringClass().isPrimitive()) continue;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                refFields.add(f);
            }
            cls = cls.getSuperclass();
        }
        return new ClassInfo(ObjectSizeCalculator.align(Math.max(size, OBJ_HEADER_SIZE)), refFields);
    }

    private static long fieldHolderSize(Field field) {
        Class<?> cls = field.getDeclaringClass();
        if (cls.isPrimitive()) {
            if (cls == Boolean.TYPE || cls == Byte.TYPE) {
                return 1L;
            }
            if (cls == Character.TYPE || cls == Short.TYPE) {
                return 2L;
            }
            if (cls == Integer.TYPE || cls == Float.TYPE) {
                return 4L;
            }
            if (cls == Long.TYPE || cls == Double.TYPE) {
                return 8L;
            }
        }
        return OBJ_REF_SIZE;
    }

    private static long align(long size) {
        return size + (OBJ_ALIGN - 1L) & -OBJ_ALIGN;
    }

    private ClassInfo cachedClassInfo(Class<?> cls) {
        ClassInfo clsInfo = this.clsInfoCache.get(cls);
        if (clsInfo == null) {
            clsInfo = ObjectSizeCalculator.classInfo(cls);
            this.clsInfoCache.put(cls, clsInfo);
        }
        return clsInfo;
    }

    public long sizeOf(Row row) {
        long res = this.sizeOf0(row, true);
        if (!this.processedObjs.isEmpty()) {
            this.processedObjs.clear();
        }
        return res;
    }

    private long sizeOf0(Object obj, boolean objNotReferred) {
        if (obj == null) {
            return 0L;
        }
        Class<?> cls = obj.getClass();
        SizeCalculator<?> sizeCalc = SYS_CLS_SIZE.get(cls);
        if (sizeCalc != null) {
            return sizeCalc.calcSize(this, obj);
        }
        if (cls.isEnum()) {
            return 0L;
        }
        if (!objNotReferred && this.processedObjs.put(obj, obj) != null) {
            return 0L;
        }
        if (cls.isArray()) {
            long base = GridUnsafe.arrayBaseOffset(cls);
            long scale = GridUnsafe.arrayIndexScale(cls);
            long size = ObjectSizeCalculator.align(base + scale * (long)Array.getLength(obj));
            if (!cls.getComponentType().isPrimitive()) {
                Object[] arr = (Object[])obj;
                for (int i = 0; i < arr.length; ++i) {
                    size += this.sizeOf0(arr[i], false);
                }
            }
            return size;
        }
        if (IterableAccumulator.class.isAssignableFrom(cls)) {
            long size = this.cachedClassInfo(cls).shallowSize;
            IterableAccumulator it = (IterableAccumulator)obj;
            for (Object row : it) {
                size += this.sizeOf0(row, true);
            }
            return size;
        }
        return this.reflectiveObjectSize(obj);
    }

    private long reflectiveObjectSize(Object obj) {
        Class<?> cls = obj.getClass();
        ClassInfo clsInfo = this.cachedClassInfo(cls);
        long size = clsInfo.shallowSize;
        for (Field f : clsInfo.refFields) {
            try {
                size += this.sizeOf0(f.get(obj), false);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return size;
    }

    static {
        ObjectSizeCalculator.addSysClsSize(Boolean.class, null);
        ObjectSizeCalculator.addSysClsSize(Byte.class, null);
        ObjectSizeCalculator.addSysClsSize(Character.class, null);
        ObjectSizeCalculator.addSysClsSize(Short.class, null);
        ObjectSizeCalculator.addSysClsSize(Integer.class, null);
        ObjectSizeCalculator.addSysClsSize(Float.class, null);
        ObjectSizeCalculator.addSysClsSize(Long.class, null);
        ObjectSizeCalculator.addSysClsSize(Double.class, null);
        long charArrOffset = GridUnsafe.arrayBaseOffset(char[].class);
        ObjectSizeCalculator.addSysClsSize(String.class, (c, s) -> ObjectSizeCalculator.align(charArrOffset + (long)s.length() * 2L));
        long byteArrOffset = GridUnsafe.arrayBaseOffset(byte[].class);
        ObjectSizeCalculator.addSysClsSize(ByteString.class, (c, s) -> ObjectSizeCalculator.align(byteArrOffset + (long)s.length()));
        ObjectSizeCalculator.addSysClsSize(java.util.Date.class, null);
        ObjectSizeCalculator.addSysClsSize(Date.class, null);
        ObjectSizeCalculator.addSysClsSize(Time.class, null);
        ObjectSizeCalculator.addSysClsSize(Timestamp.class, null);
        ObjectSizeCalculator.addSysClsSize(LocalDate.class, null);
        ObjectSizeCalculator.addSysClsSize(LocalTime.class, null);
        long locDateTimeExtraSize = ObjectSizeCalculator.classInfo(LocalDate.class).shallowSize + ObjectSizeCalculator.classInfo(LocalTime.class).shallowSize;
        ObjectSizeCalculator.addSysClsSize(LocalDateTime.class, (c, dt) -> locDateTimeExtraSize);
        ObjectSizeCalculator.addSysClsSize(Period.class, null);
        ObjectSizeCalculator.addSysClsSize(Duration.class, null);
        ObjectSizeCalculator.addSysClsSize(BinaryObjectImpl.class, (c, bo) -> ObjectSizeCalculator.align(byteArrOffset + (long)bo.array().length));
        ObjectSizeCalculator.addSysClsSize(BinaryObjectOffheapImpl.class, null);
        ObjectSizeCalculator.addSysClsSize(BinaryArray.class, (c, bo) -> c.sizeOf0(bo.array(), true));
        ObjectSizeCalculator.addSysClsSize(BinaryEnumArray.class, (c, bo) -> c.sizeOf0(bo.array(), true));
        ObjectSizeCalculator.addSysClsSize(BinaryEnumObjectImpl.class, (c, bo) -> bo.size());
        ObjectSizeCalculator.addSysClsSize(GroupKey.class, (c, k) -> c.sizeOf0(k.fields(), true));
        ObjectSizeCalculator.addSysClsSize(UUID.class, null);
        ObjectSizeCalculator.addSysClsSize(BigDecimal.class, (c, bd) -> c.sizeOf0(bd.unscaledValue(), true));
        long intArrOffset = GridUnsafe.arrayBaseOffset(int[].class);
        ObjectSizeCalculator.addSysClsSize(BigInteger.class, (c, bi) -> ObjectSizeCalculator.align(intArrOffset + (long)(bi.bitLength() + 31 >> 5) << 2));
        SYS_CLS_SIZE.put(Class.class, (c, v) -> 0L);
    }

    private static class ClassInfo {
        private final long shallowSize;
        private final List<Field> refFields;

        private ClassInfo(long shallowSize, List<Field> refFields) {
            this.shallowSize = shallowSize;
            this.refFields = refFields;
        }
    }

    private static class SizeCalculatorImpl<T>
    implements SizeCalculator<T> {
        private final long shallowSize;
        @Nullable
        private final ToLongBiFunction<ObjectSizeCalculator<?>, T> extraSizeCalc;

        private SizeCalculatorImpl(Class<T> cls, @Nullable ToLongBiFunction<ObjectSizeCalculator<?>, T> extraSizeCalc) {
            this.shallowSize = ObjectSizeCalculator.classInfo(cls).shallowSize;
            this.extraSizeCalc = extraSizeCalc;
        }

        @Override
        public long calcSize(ObjectSizeCalculator<?> calculator, T val) {
            return this.extraSizeCalc == null ? this.shallowSize : this.shallowSize + this.extraSizeCalc.applyAsLong(calculator, (ObjectSizeCalculator<?>)val);
        }
    }

    private static interface SizeCalculator<T> {
        public long calcSize(ObjectSizeCalculator<?> var1, T var2);
    }

    private static class Dummy {
        private byte field;

        private Dummy() {
        }
    }
}

