/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Node;
import org.apache.ignite.internal.util.lang.RunnableX;
import org.apache.ignite.internal.util.typedef.F;

public class CorrelatedNestedLoopJoinNode<Row>
extends AbstractNode<Row> {
    private final BiPredicate<Row, Row> cond;
    private final List<CorrelationId> correlationIds;
    private final JoinRelType joinType;
    private final RowHandler<Row> handler;
    private final int leftInBufferSize;
    private final int rightInBufferSize;
    private final BitSet leftMatched = new BitSet();
    private int requested;
    private int waitingLeft;
    private int waitingRight;
    private List<Row> leftInBuf;
    private List<Row> rightInBuf;
    private int leftIdx;
    private int rightIdx;
    private Row rightEmptyRow;
    private State state = State.INITIAL;

    public CorrelatedNestedLoopJoinNode(ExecutionContext<Row> ctx, RelDataType rowType, BiPredicate<Row, Row> cond, Set<CorrelationId> correlationIds, JoinRelType joinType) {
        super(ctx, rowType);
        assert (!F.isEmpty(correlationIds));
        this.cond = cond;
        this.correlationIds = new ArrayList<CorrelationId>(correlationIds);
        this.joinType = joinType;
        this.leftInBufferSize = correlationIds.size();
        this.rightInBufferSize = IN_BUFFER_SIZE;
        this.handler = ctx.rowHandler();
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!F.isEmpty(this.sources()) && this.sources().size() == 2);
        assert (rowsCnt > 0 && this.requested == 0);
        this.checkState();
        this.requested = rowsCnt;
        this.onRequest();
    }

    @Override
    protected void rewindInternal() {
        this.leftInBuf = null;
        this.rightInBuf = null;
        this.leftIdx = 0;
        this.rightIdx = 0;
        this.requested = 0;
        this.waitingLeft = 0;
        this.waitingRight = 0;
        this.state = State.INITIAL;
    }

    @Override
    protected Downstream<Row> requestDownstream(int idx) {
        if (idx == 0) {
            return new Downstream<Row>(){

                @Override
                public void push(Row row) throws Exception {
                    CorrelatedNestedLoopJoinNode.this.pushLeft(row);
                }

                @Override
                public void end() throws Exception {
                    CorrelatedNestedLoopJoinNode.this.endLeft();
                }

                @Override
                public void onError(Throwable e) {
                    CorrelatedNestedLoopJoinNode.this.onError(e);
                }
            };
        }
        if (idx == 1) {
            return new Downstream<Row>(){

                @Override
                public void push(Row row) throws Exception {
                    CorrelatedNestedLoopJoinNode.this.pushRight(row);
                }

                @Override
                public void end() throws Exception {
                    CorrelatedNestedLoopJoinNode.this.endRight();
                }

                @Override
                public void onError(Throwable e) {
                    CorrelatedNestedLoopJoinNode.this.onError(e);
                }
            };
        }
        throw new IndexOutOfBoundsException();
    }

    private void pushLeft(Row row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingLeft > 0);
        this.checkState();
        --this.waitingLeft;
        if (this.leftInBuf == null) {
            this.leftInBuf = new ArrayList<Row>(this.leftInBufferSize);
        }
        this.leftInBuf.add(row);
        this.onPushLeft();
    }

    private void pushRight(Row row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        this.checkState();
        --this.waitingRight;
        if (this.rightInBuf == null) {
            this.rightInBuf = new ArrayList<Row>(this.rightInBufferSize);
        }
        this.rightInBuf.add(row);
        this.onPushRight();
    }

    private void endLeft() throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingLeft > 0);
        this.checkState();
        this.waitingLeft = -1;
        if (this.leftInBuf == null) {
            this.leftInBuf = Collections.emptyList();
        }
        this.onEndLeft();
    }

    private void endRight() throws Exception {
        assert (this.downstream() != null);
        assert (this.waitingRight > 0);
        this.checkState();
        this.waitingRight = -1;
        if (this.rightInBuf == null) {
            this.rightInBuf = Collections.emptyList();
        }
        this.onEndRight();
    }

    private void onRequest() throws Exception {
        switch (this.state) {
            case IN_LOOP: 
            case FILLING_RIGHT: 
            case FILLING_LEFT: {
                break;
            }
            case INITIAL: {
                assert (this.waitingLeft == 0);
                assert (this.waitingRight == 0);
                assert (F.isEmpty(this.leftInBuf));
                assert (F.isEmpty(this.rightInBuf));
                this.context().execute((RunnableX & Serializable)() -> {
                    this.checkState();
                    this.state = State.FILLING_LEFT;
                    this.waitingLeft = this.leftInBufferSize;
                    this.leftSource().request(this.waitingLeft);
                }, this::onError);
                break;
            }
            case IDLE: {
                assert (this.rightInBuf != null);
                assert (this.leftInBuf != null);
                assert (this.waitingRight == -1 || this.waitingRight == 0 && this.rightInBuf.size() == this.rightInBufferSize);
                assert (this.waitingLeft == -1 || this.waitingLeft == 0 && this.leftInBuf.size() == this.leftInBufferSize);
                this.context().execute((RunnableX & Serializable)() -> {
                    this.checkState();
                    this.join();
                }, this::onError);
                break;
            }
            case END: {
                this.downstream().end();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected state:" + (Object)((Object)this.state)));
            }
        }
    }

    private void onPushLeft() throws Exception {
        assert (this.state == State.FILLING_LEFT) : "Unexpected state:" + (Object)((Object)this.state);
        assert (this.waitingRight == 0 || this.waitingRight == -1);
        assert (F.isEmpty(this.rightInBuf));
        if (this.leftInBuf.size() == this.leftInBufferSize) {
            assert (this.waitingLeft == 0);
            this.prepareCorrelations();
            if (this.waitingRight == -1) {
                this.rightSource().rewind();
            }
            this.state = State.FILLING_RIGHT;
            this.waitingRight = this.rightInBufferSize;
            this.rightSource().request(this.waitingRight);
        }
    }

    private void onPushRight() throws Exception {
        assert (this.state == State.FILLING_RIGHT) : "Unexpected state:" + (Object)((Object)this.state);
        assert (!F.isEmpty(this.leftInBuf));
        assert (this.waitingLeft == -1 || this.waitingLeft == 0 && this.leftInBuf.size() == this.leftInBufferSize);
        if (this.rightInBuf.size() == this.rightInBufferSize) {
            assert (this.waitingRight == 0);
            this.state = State.IDLE;
            this.join();
        }
    }

    private void onEndLeft() throws Exception {
        assert (this.state == State.FILLING_LEFT) : "Unexpected state:" + (Object)((Object)this.state);
        assert (this.waitingLeft == -1);
        assert (this.waitingRight == 0 || this.waitingRight == -1);
        assert (F.isEmpty(this.rightInBuf));
        if (F.isEmpty(this.leftInBuf)) {
            this.waitingRight = -1;
            this.state = State.END;
            if (this.requested > 0) {
                this.downstream().end();
            }
        } else {
            this.prepareCorrelations();
            if (this.waitingRight == -1) {
                this.rightSource().rewind();
            }
            this.state = State.FILLING_RIGHT;
            this.waitingRight = this.rightInBufferSize;
            this.rightSource().request(this.waitingRight);
        }
    }

    private void onEndRight() throws Exception {
        assert (this.state == State.FILLING_RIGHT) : "Unexpected state:" + (Object)((Object)this.state);
        assert (this.waitingRight == -1);
        assert (!F.isEmpty(this.leftInBuf));
        assert (this.waitingLeft == -1 || this.waitingLeft == 0 && this.leftInBuf.size() == this.leftInBufferSize);
        this.state = State.IDLE;
        this.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void join() throws Exception {
        assert (this.state == State.IDLE);
        this.state = State.IN_LOOP;
        try {
            while (this.requested > 0 && this.rightIdx < this.rightInBuf.size()) {
                if (this.leftIdx == this.leftInBuf.size()) {
                    this.leftIdx = 0;
                }
                while (this.requested > 0 && this.leftIdx < this.leftInBuf.size()) {
                    this.checkState();
                    Row left = this.leftInBuf.get(this.leftIdx);
                    Row right = this.rightInBuf.get(this.rightIdx);
                    if (this.cond.test(left, right)) {
                        this.leftMatched.set(this.leftIdx);
                        --this.requested;
                        Row row = this.handler.concat(left, right);
                        this.downstream().push(row);
                    }
                    ++this.leftIdx;
                }
                if (this.leftIdx != this.leftInBuf.size()) continue;
                this.rightInBuf.set(this.rightIdx++, null);
            }
        }
        finally {
            this.state = State.IDLE;
        }
        if (this.rightIdx == this.rightInBuf.size()) {
            this.leftIdx = 0;
            this.rightIdx = 0;
            if (this.waitingRight == 0) {
                this.rightInBuf = null;
                this.state = State.FILLING_RIGHT;
                this.waitingRight = this.rightInBufferSize;
                this.rightSource().request(this.waitingRight);
                return;
            }
            if (this.joinType == JoinRelType.LEFT && !F.isEmpty(this.leftInBuf)) {
                if (this.rightEmptyRow == null) {
                    this.rightEmptyRow = this.handler.factory(this.context().getTypeFactory(), this.rightSource().rowType()).create();
                }
                int notMatchedIdx = this.leftMatched.nextClearBit(0);
                while (this.requested > 0 && notMatchedIdx < this.leftInBuf.size()) {
                    this.downstream().push(this.handler.concat(this.leftInBuf.get(notMatchedIdx), this.rightEmptyRow));
                    --this.requested;
                    this.leftMatched.set(notMatchedIdx);
                    notMatchedIdx = this.leftMatched.nextClearBit(notMatchedIdx + 1);
                }
                if (this.requested == 0 && notMatchedIdx < this.leftInBuf.size()) {
                    return;
                }
            }
            if (this.waitingLeft == 0) {
                this.rightInBuf = null;
                this.leftInBuf = null;
                this.leftMatched.clear();
                this.state = State.FILLING_LEFT;
                this.waitingLeft = this.leftInBufferSize;
                this.leftSource().request(this.waitingLeft);
                return;
            }
            assert (this.waitingLeft == -1 && this.waitingRight == -1);
            if (this.requested > 0) {
                this.leftInBuf = null;
                this.rightInBuf = null;
                this.state = State.END;
                if (this.requested > 0) {
                    this.downstream().end();
                }
                return;
            }
            this.leftInBuf = Collections.emptyList();
            this.rightInBuf = Collections.emptyList();
        }
    }

    private Node<Row> leftSource() {
        return this.sources().get(0);
    }

    private Node<Row> rightSource() {
        return this.sources().get(1);
    }

    private void prepareCorrelations() {
        for (int i = 0; i < this.correlationIds.size(); ++i) {
            Object row = i < this.leftInBuf.size() ? this.leftInBuf.get(i) : F.first(this.leftInBuf);
            this.context().setCorrelated(row, this.correlationIds.get(i).getId());
        }
    }

    private static enum State {
        INITIAL,
        FILLING_LEFT,
        FILLING_RIGHT,
        IDLE,
        IN_LOOP,
        END;

    }
}

