/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.rel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.GroupKey;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Downstream;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.MemoryTrackingNode;
import org.apache.ignite.internal.util.typedef.F;

public abstract class AbstractSetOpNode<Row>
extends MemoryTrackingNode<Row> {
    private final AggregateType type;
    private final Grouping<Row> grouping;
    private int requested;
    private int waiting;
    private int curSrcIdx;
    private boolean inLoop;

    protected AbstractSetOpNode(ExecutionContext<Row> ctx, RelDataType rowType, AggregateType type, boolean all, RowHandler.RowFactory<Row> rowFactory, Grouping<Row> grouping) {
        super(ctx, rowType, HASH_MAP_ROW_OVERHEAD + (long)(grouping.countersSize() * 4));
        this.type = type;
        this.grouping = grouping;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!F.isEmpty(this.sources()));
        assert (rowsCnt > 0 && this.requested == 0);
        assert (this.waiting <= 0);
        this.checkState();
        this.requested = rowsCnt;
        if (this.waiting == 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.sources().get(this.curSrcIdx).request(this.waiting);
        } else if (!this.inLoop) {
            this.context().execute(this::flush, this::onError);
        }
    }

    public void push(Row row, int idx) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.checkState();
        --this.waiting;
        int size = ((Grouping)this.grouping).size();
        ((Grouping)this.grouping).add(row, idx);
        if (((Grouping)this.grouping).size() > size) {
            this.nodeMemoryTracker.onRowAdded(row);
        } else if (((Grouping)this.grouping).size() < size) {
            this.nodeMemoryTracker.onRowRemoved(row);
        }
        if (this.waiting == 0) {
            this.waiting = IN_BUFFER_SIZE;
            this.sources().get(this.curSrcIdx).request(this.waiting);
        }
    }

    public void end(int idx) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        assert (this.curSrcIdx == idx);
        this.checkState();
        this.grouping.endOfSet(idx);
        this.curSrcIdx = this.type == AggregateType.SINGLE && ((Grouping)this.grouping).isEmpty() ? this.sources().size() : ++this.curSrcIdx;
        if (this.curSrcIdx >= this.sources().size()) {
            this.waiting = -1;
            this.flush();
        } else {
            this.sources().get(this.curSrcIdx).request(this.waiting);
        }
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.curSrcIdx = 0;
        this.grouping.groups.clear();
        this.nodeMemoryTracker.reset();
    }

    @Override
    protected Downstream<Row> requestDownstream(final int idx) {
        return new Downstream<Row>(){

            @Override
            public void push(Row row) throws Exception {
                AbstractSetOpNode.this.push(row, idx);
            }

            @Override
            public void end() throws Exception {
                AbstractSetOpNode.this.end(idx);
            }

            @Override
            public void onError(Throwable e) {
                AbstractSetOpNode.this.onError(e);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws Exception {
        if (this.isClosed()) {
            return;
        }
        this.checkState();
        assert (this.waiting == -1);
        int processed = 0;
        this.inLoop = true;
        try {
            if (this.requested > 0 && !((Grouping)this.grouping).isEmpty()) {
                int toSnd = Math.min(this.requested, IN_BUFFER_SIZE - processed);
                int size = ((Grouping)this.grouping).size();
                List rows = ((Grouping)this.grouping).getRows(toSnd);
                int removed = size - ((Grouping)this.grouping).size();
                for (Object row : rows) {
                    --this.requested;
                    this.downstream().push(row);
                    if (processed < removed) {
                        this.nodeMemoryTracker.onRowRemoved(row);
                    }
                    ++processed;
                }
                if (processed >= IN_BUFFER_SIZE && this.requested > 0) {
                    this.context().execute(this::flush, this::onError);
                    return;
                }
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.requested > 0) {
            this.requested = 0;
            this.downstream().end();
        }
    }

    protected static abstract class Grouping<Row> {
        protected final Map<GroupKey, int[]> groups = new HashMap<GroupKey, int[]>();
        protected final RowHandler<Row> hnd;
        protected final AggregateType type;
        protected final boolean all;
        protected final RowHandler.RowFactory<Row> rowFactory;
        protected int rowsCnt = 0;

        protected Grouping(ExecutionContext<Row> ctx, RowHandler.RowFactory<Row> rowFactory, AggregateType type, boolean all) {
            this.hnd = ctx.rowHandler();
            this.type = type;
            this.all = all;
            this.rowFactory = rowFactory;
        }

        private void add(Row row, int setIdx) {
            if (this.type == AggregateType.REDUCE) {
                assert (setIdx == 0) : "Unexpected set index: " + setIdx;
                this.addOnReducer(row);
            } else if (this.type == AggregateType.MAP) {
                this.addOnMapper(row, setIdx);
            } else {
                this.addOnSingle(row, setIdx);
            }
            ++this.rowsCnt;
        }

        private List<Row> getRows(int cnt) {
            if (F.isEmpty(this.groups)) {
                return Collections.emptyList();
            }
            if (this.type == AggregateType.MAP) {
                return this.getOnMapper(cnt);
            }
            return this.getOnSingleOrReducer(cnt);
        }

        protected GroupKey key(Row row) {
            int size = this.hnd.columnCount(row);
            Object[] fields = new Object[size];
            for (int i = 0; i < size; ++i) {
                fields[i] = this.hnd.get(i, row);
            }
            return new GroupKey(fields);
        }

        protected void endOfSet(int setIdx) {
            this.rowsCnt = 0;
        }

        protected abstract void addOnSingle(Row var1, int var2);

        protected abstract void addOnMapper(Row var1, int var2);

        protected void addOnReducer(Row row) {
            GroupKey grpKey = (GroupKey)this.hnd.get(0, row);
            int[] cntrsMap = (int[])this.hnd.get(1, row);
            int[] cntrs = this.groups.computeIfAbsent(grpKey, k -> new int[cntrsMap.length]);
            assert (cntrs.length == cntrsMap.length);
            for (int i = 0; i < cntrsMap.length; ++i) {
                int n = i;
                cntrs[n] = cntrs[n] + cntrsMap[i];
            }
        }

        protected List<Row> getOnMapper(int cnt) {
            Iterator<Map.Entry<GroupKey, int[]>> it = this.groups.entrySet().iterator();
            int amount = Math.min(cnt, this.groups.size());
            ArrayList<Row> res = new ArrayList<Row>(amount);
            while (amount > 0 && it.hasNext()) {
                Map.Entry<GroupKey, int[]> entry = it.next();
                if (this.affectResult(entry.getValue())) {
                    res.add(this.rowFactory.create(entry.getKey(), entry.getValue()));
                    --amount;
                }
                it.remove();
            }
            return res;
        }

        protected List<Row> getOnSingleOrReducer(int cnt) {
            Iterator<Map.Entry<GroupKey, int[]>> it = this.groups.entrySet().iterator();
            ArrayList<Row> res = new ArrayList<Row>(cnt);
            while (it.hasNext() && cnt > 0) {
                Map.Entry<GroupKey, int[]> entry = it.next();
                GroupKey key = entry.getKey();
                Row row = this.rowFactory.create(key.fields());
                int[] cntrs = entry.getValue();
                int availableRows = this.availableRows(entry.getValue());
                if (availableRows <= cnt) {
                    it.remove();
                    if (availableRows == 0) continue;
                    cnt -= availableRows;
                } else {
                    availableRows = cnt;
                    this.decrementAvailableRows(cntrs, availableRows);
                    cnt = 0;
                }
                for (int i = 0; i < availableRows; ++i) {
                    res.add(row);
                }
            }
            return res;
        }

        protected abstract boolean affectResult(int[] var1);

        protected abstract int availableRows(int[] var1);

        protected abstract void decrementAvailableRows(int[] var1, int var2);

        private boolean isEmpty() {
            return this.groups.isEmpty();
        }

        private int size() {
            return this.groups.size();
        }

        protected abstract int countersSize();
    }
}

