/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.processors.query.calcite.exec.ExchangeService;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.MailboxRegistry;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.TableFunctionScan;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.ExpressionFactory;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.agg.AggregateType;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.AbstractSetOpNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.CollectNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.CorrelatedNestedLoopJoinNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.FilterNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.HashAggregateNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Inbox;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.IndexSpoolNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.IntersectNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.LimitNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.MergeJoinNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.MinusNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.ModifyNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.NestedLoopJoinNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Node;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Outbox;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.ProjectNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.ScanNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.ScanStorageNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SortAggregateNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.SortNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.TableSpoolNode;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.UnionAllNode;
import org.apache.ignite.internal.processors.query.calcite.metadata.AffinityService;
import org.apache.ignite.internal.processors.query.calcite.metadata.ColocationGroup;
import org.apache.ignite.internal.processors.query.calcite.prepare.bounds.SearchBounds;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteCollect;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteCorrelatedNestedLoopJoin;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteExchange;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteFilter;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteHashIndexSpool;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexBound;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexCount;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteLimit;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteMergeJoin;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteNestedLoopJoin;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteProject;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteReceiver;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRelVisitor;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSender;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSort;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSortedIndexSpool;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableFunctionScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableModify;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableSpool;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTrimExchange;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteUnionAll;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteValues;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteColocatedHashAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteColocatedSortAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteMapHashAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteMapSortAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteReduceHashAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.agg.IgniteReduceSortAggregate;
import org.apache.ignite.internal.processors.query.calcite.rel.set.IgniteSetOp;
import org.apache.ignite.internal.processors.query.calcite.rule.LogicalScanConverterRule;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteIndex;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.trait.Destination;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.processors.query.calcite.trait.TraitUtils;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;
import org.apache.ignite.internal.processors.query.calcite.util.RexUtils;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.typedef.F;

public class LogicalRelImplementor<Row>
implements IgniteRelVisitor<Node<Row>> {
    public static final String CNLJ_NOT_SUPPORTED_JOIN_ASSERTION_MSG = "only INNER and LEFT join supported by IgniteCorrelatedNestedLoop";
    private final ExecutionContext<Row> ctx;
    private final AffinityService affSrvc;
    private final ExchangeService exchangeSvc;
    private final MailboxRegistry mailboxRegistry;
    private final ExpressionFactory<Row> expressionFactory;

    public LogicalRelImplementor(ExecutionContext<Row> ctx, AffinityService affSrvc, MailboxRegistry mailboxRegistry, ExchangeService exchangeSvc, FailureProcessor failure) {
        this.affSrvc = affSrvc;
        this.mailboxRegistry = mailboxRegistry;
        this.exchangeSvc = exchangeSvc;
        this.ctx = ctx;
        this.expressionFactory = ctx.expressionFactory();
    }

    @Override
    public Node<Row> visit(IgniteSender rel) {
        IgniteDistribution distribution = rel.distribution();
        Destination<Row> dest = distribution.destination(this.ctx, this.affSrvc, this.ctx.target());
        Outbox<Row> outbox = new Outbox<Row>(this.ctx, rel.getRowType(), this.exchangeSvc, this.mailboxRegistry, rel.exchangeId(), rel.targetFragmentId(), dest);
        Node<Row> input = this.visit(rel.getInput());
        outbox.register(input);
        this.mailboxRegistry.register(outbox);
        return outbox;
    }

    @Override
    public Node<Row> visit(IgniteFilter rel) {
        Predicate<Row> pred = this.expressionFactory.predicate(rel.getCondition(), rel.getRowType());
        FilterNode<Row> node = new FilterNode<Row>(this.ctx, rel.getRowType(), pred);
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteTrimExchange rel) {
        assert (TraitUtils.distribution((RelNode)rel).getType() == RelDistribution.Type.HASH_DISTRIBUTED);
        IgniteDistribution distr = rel.distribution();
        Destination dest = distr.destination(this.ctx, this.affSrvc, this.ctx.group(rel.sourceId()));
        UUID localNodeId = this.ctx.localNodeId();
        FilterNode<Object> node = new FilterNode<Object>(this.ctx, rel.getRowType(), r -> Objects.equals(localNodeId, F.first(dest.targets(r))));
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteProject rel) {
        Function<Row, Row> prj = this.expressionFactory.project(rel.getProjects(), rel.getInput().getRowType());
        ProjectNode<Row> node = new ProjectNode<Row>(this.ctx, rel.getRowType(), prj);
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteNestedLoopJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        JoinRelType joinType = rel.getJoinType();
        RelDataType rowType = TypeUtils.combinedRowType(this.ctx.getTypeFactory(), leftType, rightType);
        BiPredicate<Row, Row> cond = this.expressionFactory.biPredicate(rel.getCondition(), rowType);
        NestedLoopJoinNode<Row> node = NestedLoopJoinNode.create(this.ctx, outType, leftType, rightType, joinType, cond);
        Node<Row> leftInput = this.visit(rel.getLeft());
        Node<Row> rightInput = this.visit(rel.getRight());
        node.register(F.asList((Object[])new Node[]{leftInput, rightInput}));
        return node;
    }

    @Override
    public Node<Row> visit(IgniteCorrelatedNestedLoopJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        RelDataType rowType = TypeUtils.combinedRowType(this.ctx.getTypeFactory(), leftType, rightType);
        BiPredicate<Row, Row> cond = this.expressionFactory.biPredicate(rel.getCondition(), rowType);
        assert (rel.getJoinType() == JoinRelType.INNER || rel.getJoinType() == JoinRelType.LEFT) : "only INNER and LEFT join supported by IgniteCorrelatedNestedLoop";
        CorrelatedNestedLoopJoinNode<Row> node = new CorrelatedNestedLoopJoinNode<Row>(this.ctx, outType, cond, rel.getVariablesSet(), rel.getJoinType());
        Node<Row> leftInput = this.visit(rel.getLeft());
        Node<Row> rightInput = this.visit(rel.getRight());
        node.register(F.asList((Object[])new Node[]{leftInput, rightInput}));
        return node;
    }

    @Override
    public Node<Row> visit(IgniteMergeJoin rel) {
        RelDataType outType = rel.getRowType();
        RelDataType leftType = rel.getLeft().getRowType();
        RelDataType rightType = rel.getRight().getRowType();
        JoinRelType joinType = rel.getJoinType();
        int pairsCnt = rel.analyzeCondition().pairs().size();
        Comparator<Row> comp = this.expressionFactory.comparator(rel.leftCollation().getFieldCollations().subList(0, pairsCnt), rel.rightCollation().getFieldCollations().subList(0, pairsCnt));
        MergeJoinNode<Row> node = MergeJoinNode.create(this.ctx, outType, leftType, rightType, joinType, comp, this.hasExchange((RelNode)rel));
        Node<Row> leftInput = this.visit(rel.getLeft());
        Node<Row> rightInput = this.visit(rel.getRight());
        node.register(F.asList((Object[])new Node[]{leftInput, rightInput}));
        return node;
    }

    private boolean hasExchange(RelNode rel) {
        if (rel instanceof IgniteReceiver) {
            return true;
        }
        for (RelNode in : rel.getInputs()) {
            if (!this.hasExchange(in)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Node<Row> visit(IgniteIndexScan rel) {
        boolean sortNodeRequired;
        RexNode condition = rel.condition();
        List<RexNode> projects = rel.projects();
        IgniteTable tbl = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        ImmutableBitSet requiredColumns = rel.requiredColumns();
        List<SearchBounds> searchBounds = rel.searchBounds();
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        Predicate<Row> filters = condition == null ? null : this.expressionFactory.predicate(condition, rowType);
        Function<Row, Row> prj = projects == null ? null : this.expressionFactory.project(projects, rowType);
        RangeIterable<Row> ranges = searchBounds == null ? null : this.expressionFactory.ranges(searchBounds, rel.collation(), tbl.getRowType((RelDataTypeFactory)typeFactory));
        ColocationGroup grp = this.ctx.group(rel.sourceId());
        IgniteIndex idx = tbl.getIndex(rel.indexName());
        if (idx != null && !tbl.isIndexRebuildInProgress()) {
            Iterable<Row> rowsIter = idx.scan(this.ctx, grp, ranges, requiredColumns);
            return new ScanStorageNode<Row>(idx.name(), this.ctx, rowType, rowsIter, filters, prj);
        }
        boolean filterHasCorrelation = condition != null && RexUtils.hasCorrelation(condition);
        boolean projectHasCorrelation = projects != null && RexUtils.hasCorrelation(projects);
        boolean spoolNodeRequired = projectHasCorrelation || filterHasCorrelation;
        boolean projNodeRequired = projects != null && spoolNodeRequired;
        Iterable<Row> rowsIter = tbl.scan(this.ctx, grp, requiredColumns);
        if (!spoolNodeRequired && projects != null) {
            rowType = rel.getRowType();
        }
        AbstractNode node = new ScanStorageNode<Row>(tbl.name(), this.ctx, rowType, rowsIter, filterHasCorrelation ? null : filters, projNodeRequired ? null : prj);
        RelCollation collation = rel.collation();
        if (!spoolNodeRequired && projects != null || requiredColumns != null) {
            collation = (RelCollation)collation.apply(LogicalScanConverterRule.createMapping(spoolNodeRequired ? null : projects, requiredColumns, tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount()));
        }
        boolean bl = sortNodeRequired = !collation.getFieldCollations().isEmpty();
        if (sortNodeRequired) {
            SortNode<Row> sortNode = new SortNode<Row>(this.ctx, rowType, this.expressionFactory.comparator(collation));
            sortNode.register(node);
            node = sortNode;
        }
        if (spoolNodeRequired) {
            if (searchBounds != null && requiredColumns != null) {
                ArrayList<SearchBounds> remappedSearchBounds = new ArrayList<SearchBounds>(requiredColumns.cardinality());
                int i = requiredColumns.nextSetBit(0);
                while (i != -1) {
                    remappedSearchBounds.add(searchBounds.get(i));
                    i = requiredColumns.nextSetBit(i + 1);
                }
                ranges = this.expressionFactory.ranges(remappedSearchBounds, collation, rowType);
            }
            IndexSpoolNode<Row> spoolNode = IndexSpoolNode.createTreeSpool(this.ctx, rowType, collation, this.expressionFactory.comparator(collation), filterHasCorrelation ? filters : null, ranges);
            spoolNode.register(node);
            node = spoolNode;
        }
        if (projNodeRequired) {
            ProjectNode<Row> projectNode = new ProjectNode<Row>(this.ctx, rel.getRowType(), prj);
            projectNode.register(node);
            node = projectNode;
        }
        return node;
    }

    @Override
    public Node<Row> visit(IgniteIndexCount rel) {
        IgniteTable tbl = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        IgniteIndex idx = tbl.getIndex(rel.indexName());
        if (idx != null && !tbl.isIndexRebuildInProgress()) {
            return new ScanStorageNode<Row>(idx.name() + "_COUNT", this.ctx, rel.getRowType(), () -> Collections.singletonList(this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rel.getRowType()).create(idx.count(this.ctx, this.ctx.group(rel.sourceId()), rel.notNull()))).iterator());
        }
        CollectNode<Row> replacement = CollectNode.createCountCollector(this.ctx);
        replacement.register(new ScanStorageNode<Row>(tbl.name(), this.ctx, rel.getTable().getRowType(), tbl.scan(this.ctx, this.ctx.group(rel.sourceId()), ImmutableBitSet.of((int[])new int[]{0}))));
        return replacement;
    }

    @Override
    public Node<Row> visit(IgniteIndexBound idxBndRel) {
        IgniteTable tbl = (IgniteTable)idxBndRel.getTable().unwrap(IgniteTable.class);
        IgniteIndex idx = tbl.getIndex(idxBndRel.indexName());
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        ColocationGroup grp = this.ctx.group(idxBndRel.sourceId());
        ImmutableBitSet requiredColumns = idxBndRel.requiredColumns();
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColumns);
        if (idx != null && !tbl.isIndexRebuildInProgress()) {
            return new ScanStorageNode<Row>(idx.name() + "_BOUND", this.ctx, rowType, idx.firstOrLast(idxBndRel.first(), this.ctx, grp, requiredColumns));
        }
        assert (requiredColumns.cardinality() == 1);
        Iterable<Row> rowsIter = tbl.scan(this.ctx, grp, idxBndRel.requiredColumns());
        ScanStorageNode<Object> scanNode = new ScanStorageNode<Object>(tbl.name(), this.ctx, rowType, rowsIter, r -> this.ctx.rowHandler().get(0, r) != null, null);
        RelCollation collation = (RelCollation)idx.collation().apply(LogicalScanConverterRule.createMapping(null, requiredColumns, tbl.getRowType((RelDataTypeFactory)typeFactory).getFieldCount()));
        Comparator<Row> cmp = this.expressionFactory.comparator(collation);
        assert (cmp != null);
        SortNode<Object> sortNode = new SortNode<Object>(this.ctx, rowType, idxBndRel.first() ? cmp : cmp.reversed(), null, () -> 1);
        sortNode.register(scanNode);
        return sortNode;
    }

    @Override
    public Node<Row> visit(IgniteTableScan rel) {
        RexNode condition = rel.condition();
        List<RexNode> projects = rel.projects();
        ImmutableBitSet requiredColunms = rel.requiredColumns();
        IgniteTable tbl = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        IgniteTypeFactory typeFactory = this.ctx.getTypeFactory();
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)typeFactory, requiredColunms);
        Predicate<Row> filters = condition == null ? null : this.expressionFactory.predicate(condition, rowType);
        Function<Row, Row> prj = projects == null ? null : this.expressionFactory.project(projects, rowType);
        ColocationGroup group = this.ctx.group(rel.sourceId());
        Iterable<Row> rowsIter = tbl.scan(this.ctx, group, requiredColunms);
        return new ScanStorageNode<Row>(tbl.name(), this.ctx, rowType, rowsIter, filters, prj);
    }

    @Override
    public Node<Row> visit(IgniteValues rel) {
        List vals = Commons.flat(Commons.cast(rel.getTuples()));
        RelDataType rowType = rel.getRowType();
        return new ScanNode<Row>(this.ctx, rowType, this.expressionFactory.values(vals, rowType));
    }

    @Override
    public Node<Row> visit(IgniteUnionAll rel) {
        UnionAllNode node = new UnionAllNode(this.ctx, rel.getRowType());
        List inputs = Commons.transform(rel.getInputs(), this::visit);
        node.register(inputs);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteLimit rel) {
        Supplier<Integer> offset = rel.offset() == null ? null : this.expressionFactory.execute(rel.offset());
        Supplier<Integer> fetch = rel.fetch() == null ? null : this.expressionFactory.execute(rel.fetch());
        LimitNode<Row> node = new LimitNode<Row>(this.ctx, rel.getRowType(), offset, fetch);
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteSort rel) {
        RelCollation collation = rel.getCollation();
        Supplier<Integer> offset = rel.offset == null ? null : this.expressionFactory.execute(rel.offset);
        Supplier<Integer> fetch = rel.fetch == null ? null : this.expressionFactory.execute(rel.fetch);
        SortNode<Row> node = new SortNode<Row>(this.ctx, rel.getRowType(), this.expressionFactory.comparator(collation), offset, fetch);
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteTableSpool rel) {
        TableSpoolNode<Row> node = new TableSpoolNode<Row>(this.ctx, rel.getRowType(), rel.readType == Spool.Type.LAZY);
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteSortedIndexSpool rel) {
        RelCollation collation = rel.collation();
        assert (rel.searchBounds() != null) : rel;
        Predicate<Row> filter = this.expressionFactory.predicate(rel.condition(), rel.getRowType());
        RangeIterable<Row> ranges = this.expressionFactory.ranges(rel.searchBounds(), collation, rel.getRowType());
        IndexSpoolNode<Row> node = IndexSpoolNode.createTreeSpool(this.ctx, rel.getRowType(), collation, this.expressionFactory.comparator(collation), filter, ranges);
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteHashIndexSpool rel) {
        Supplier<Row> searchRow = this.expressionFactory.rowSource(rel.searchRow());
        Predicate<Row> filter = this.expressionFactory.predicate(rel.condition(), rel.getRowType());
        IndexSpoolNode<Row> node = IndexSpoolNode.createHashSpool(this.ctx, rel.getRowType(), ImmutableBitSet.of((Iterable)rel.keys()), filter, searchRow, rel.allowNulls());
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteSetOp rel) {
        AbstractSetOpNode node;
        RelDataType rowType = rel.getRowType();
        RowHandler.RowFactory<Row> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        List inputs = Commons.transform(rel.getInputs(), this::visit);
        if (rel instanceof Minus) {
            node = new MinusNode(this.ctx, rowType, rel.aggregateType(), rel.all(), rowFactory);
        } else if (rel instanceof Intersect) {
            node = new IntersectNode<Row>(this.ctx, rowType, rel.aggregateType(), rel.all(), rowFactory, rel.getInputs().size());
        } else {
            throw new AssertionError();
        }
        node.register(inputs);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteTableFunctionScan rel) {
        Supplier<Iterable<Object[]>> dataSupplier = this.expressionFactory.execute(rel.getCall());
        RelDataType rowType = rel.getRowType();
        RowHandler.RowFactory<Row> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        return new ScanNode<Row>(this.ctx, rowType, new TableFunctionScan<Row>(dataSupplier, rowFactory));
    }

    @Override
    public Node<Row> visit(IgniteTableModify rel) {
        switch (rel.getOperation()) {
            case INSERT: 
            case UPDATE: 
            case DELETE: 
            case MERGE: {
                ModifyNode<Row> node = new ModifyNode<Row>(this.ctx, rel.getRowType(), (CacheTableDescriptor)rel.getTable().unwrap(CacheTableDescriptor.class), rel.getOperation(), rel.getUpdateColumnList());
                Node<Row> input = this.visit(rel.getInput());
                node.register(input);
                return node;
            }
        }
        throw new AssertionError();
    }

    @Override
    public Node<Row> visit(IgniteReceiver rel) {
        Inbox<?> inbox = this.mailboxRegistry.register(new Inbox<Row>(this.ctx, this.exchangeSvc, this.mailboxRegistry, rel.exchangeId(), rel.sourceFragmentId()));
        inbox.init(this.ctx, rel.getRowType(), this.ctx.remotes(rel.exchangeId()), this.expressionFactory.comparator(rel.collation()));
        return inbox;
    }

    @Override
    public Node<Row> visit(IgniteColocatedHashAggregate rel) {
        AggregateType type = AggregateType.SINGLE;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        Supplier<List<AccumulatorWrapper<Row>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType);
        RowHandler.RowFactory<Row> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        HashAggregateNode<Row> node = new HashAggregateNode<Row>(this.ctx, rowType, type, (List<ImmutableBitSet>)rel.getGroupSets(), accFactory, rowFactory);
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteMapHashAggregate rel) {
        AggregateType type = AggregateType.MAP;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        Supplier<List<AccumulatorWrapper<Row>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType);
        RowHandler.RowFactory<Row> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        HashAggregateNode<Row> node = new HashAggregateNode<Row>(this.ctx, rowType, type, (List<ImmutableBitSet>)rel.getGroupSets(), accFactory, rowFactory);
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteReduceHashAggregate rel) {
        AggregateType type = AggregateType.REDUCE;
        RelDataType rowType = rel.getRowType();
        Supplier<List<AccumulatorWrapper<Row>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggregateCalls(), null);
        RowHandler.RowFactory<Row> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        HashAggregateNode<Row> node = new HashAggregateNode<Row>(this.ctx, rowType, type, rel.getGroupSets(), accFactory, rowFactory);
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteColocatedSortAggregate rel) {
        AggregateType type = AggregateType.SINGLE;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        Supplier<List<AccumulatorWrapper<Row>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType);
        RowHandler.RowFactory<Row> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        SortAggregateNode<Row> node = new SortAggregateNode<Row>(this.ctx, rowType, type, rel.getGroupSet(), accFactory, rowFactory, this.expressionFactory.comparator(rel.collation()));
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteMapSortAggregate rel) {
        AggregateType type = AggregateType.MAP;
        RelDataType rowType = rel.getRowType();
        RelDataType inputType = rel.getInput().getRowType();
        Supplier<List<AccumulatorWrapper<Row>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggCallList(), inputType);
        RowHandler.RowFactory<Row> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        SortAggregateNode<Row> node = new SortAggregateNode<Row>(this.ctx, rowType, type, rel.getGroupSet(), accFactory, rowFactory, this.expressionFactory.comparator(rel.collation()));
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteReduceSortAggregate rel) {
        AggregateType type = AggregateType.REDUCE;
        RelDataType rowType = rel.getRowType();
        Supplier<List<AccumulatorWrapper<Row>>> accFactory = this.expressionFactory.accumulatorsFactory(type, rel.getAggregateCalls(), null);
        RowHandler.RowFactory<Row> rowFactory = this.ctx.rowHandler().factory(this.ctx.getTypeFactory(), rowType);
        SortAggregateNode<Row> node = new SortAggregateNode<Row>(this.ctx, rowType, type, rel.getGroupSet(), accFactory, rowFactory, this.expressionFactory.comparator(rel.collation()));
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteCollect rel) {
        RelDataType outType = rel.getRowType();
        CollectNode<Row> node = new CollectNode<Row>(this.ctx, outType);
        Node<Row> input = this.visit(rel.getInput());
        node.register(input);
        return node;
    }

    @Override
    public Node<Row> visit(IgniteRel rel) {
        return (Node)rel.accept(this);
    }

    @Override
    public Node<Row> visit(IgniteExchange rel) {
        throw new AssertionError();
    }

    private Node<Row> visit(RelNode rel) {
        return this.visit((IgniteRel)rel);
    }

    public <T extends Node<Row>> T go(IgniteRel rel) {
        return (T)this.visit(rel);
    }
}

