/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryEntityPatch;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.query.QueryEntityEx;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.QuerySchemaPatch;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.schema.message.SchemaFinishDiscoveryMessage;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAbstractOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAddQueryEntityOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAlterTableAddColumnOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAlterTableDropColumnOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaIndexCreateOperation;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaIndexDropOperation;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class QuerySchema
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final Collection<QueryEntity> entities = new LinkedList<QueryEntity>();
    private final Object mux = new Object();

    public QuerySchema() {
    }

    public QuerySchema(Collection<QueryEntity> entities) {
        assert (entities != null);
        for (QueryEntity qryEntity : entities) {
            this.entities.add(QueryUtils.copy(qryEntity));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuerySchema copy() {
        Object object = this.mux;
        synchronized (object) {
            QuerySchema res = new QuerySchema();
            for (QueryEntity qryEntity : this.entities) {
                res.entities.add(QueryUtils.copy(qryEntity));
            }
            return res;
        }
    }

    public QuerySchemaPatch makePatch(Collection<QueryEntity> target) {
        return this.makePatch(null, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuerySchemaPatch makePatch(CacheConfiguration<?, ?> targetCfg, Collection<QueryEntity> target) {
        Object object = this.mux;
        synchronized (object) {
            if (this.entities.isEmpty() && targetCfg != null) {
                SchemaAddQueryEntityOperation op = new SchemaAddQueryEntityOperation(UUID.randomUUID(), targetCfg.getName(), targetCfg.getSqlSchema(), target, targetCfg.getQueryParallelism(), targetCfg.isSqlEscapeAll());
                return new QuerySchemaPatch(Collections.singletonList(op), Collections.emptyList(), "");
            }
            HashMap<String, QueryEntity> localEntities = new HashMap<String, QueryEntity>();
            for (QueryEntity entity : this.entities) {
                if (localEntities.put(entity.getTableName(), entity) == null) continue;
                throw new IllegalStateException("Duplicate key");
            }
            ArrayList<SchemaAbstractOperation> patchOperations = new ArrayList<SchemaAbstractOperation>();
            ArrayList<QueryEntity> entityToAdd = new ArrayList<QueryEntity>();
            StringBuilder conflicts = new StringBuilder();
            for (QueryEntity queryEntity : target) {
                if (localEntities.containsKey(queryEntity.getTableName())) {
                    QueryEntity localEntity = (QueryEntity)localEntities.get(queryEntity.getTableName());
                    QueryEntityPatch entityPatch = localEntity.makePatch(queryEntity);
                    if (entityPatch.hasConflict()) {
                        if (conflicts.length() > 0) {
                            conflicts.append("\n");
                        }
                        conflicts.append(entityPatch.getConflictsMessage());
                    }
                    if (entityPatch.isEmpty()) continue;
                    patchOperations.addAll(entityPatch.getPatchOperations());
                    continue;
                }
                entityToAdd.add(QueryUtils.copy(queryEntity));
            }
            return new QuerySchemaPatch(patchOperations, entityToAdd, conflicts.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyPatch(QuerySchemaPatch patch) {
        Object object = this.mux;
        synchronized (object) {
            if (patch.hasConflicts()) {
                return false;
            }
            if (patch.isEmpty()) {
                return true;
            }
            for (SchemaAbstractOperation operation : patch.getPatchOperations()) {
                this.finish(operation);
            }
            this.entities.addAll(patch.getEntityToAdd());
            return true;
        }
    }

    public void finish(SchemaFinishDiscoveryMessage msg) {
        this.finish(msg.operation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(SchemaAbstractOperation op) {
        Object object = this.mux;
        synchronized (object) {
            if (op instanceof SchemaIndexCreateOperation) {
                SchemaIndexCreateOperation op0 = (SchemaIndexCreateOperation)op;
                for (QueryEntity entity : this.entities) {
                    String tblName = entity.getTableName();
                    if (!F.eq(tblName, op0.tableName())) continue;
                    boolean exists = false;
                    for (QueryIndex idx : entity.getIndexes()) {
                        if (!F.eq(idx.getName(), op0.indexName())) continue;
                        exists = true;
                        break;
                    }
                    if (exists) break;
                    ArrayList<QueryIndex> idxs = new ArrayList<QueryIndex>(entity.getIndexes());
                    idxs.add(op0.index());
                    entity.setIndexes(idxs);
                    break;
                }
            } else if (op instanceof SchemaIndexDropOperation) {
                SchemaIndexDropOperation op0 = (SchemaIndexDropOperation)op;
                for (QueryEntity entity : this.entities) {
                    Collection<QueryIndex> idxs = entity.getIndexes();
                    QueryIndex victim = null;
                    for (QueryIndex idx : idxs) {
                        if (!F.eq(idx.getName(), op0.indexName())) continue;
                        victim = idx;
                        break;
                    }
                    if (victim == null) continue;
                    ArrayList<QueryIndex> newIdxs = new ArrayList<QueryIndex>(entity.getIndexes());
                    newIdxs.remove(victim);
                    entity.setIndexes(newIdxs);
                    break;
                }
            } else if (op instanceof SchemaAlterTableAddColumnOperation) {
                SchemaAlterTableAddColumnOperation op0 = (SchemaAlterTableAddColumnOperation)op;
                int targetIdx = -1;
                for (int i = 0; i < this.entities.size(); ++i) {
                    QueryEntity entity = (QueryEntity)((List)this.entities).get(i);
                    if (!F.eq(entity.getTableName(), op0.tableName())) continue;
                    targetIdx = i;
                    break;
                }
                if (targetIdx == -1) {
                    return;
                }
                boolean replaceTarget = false;
                QueryEntity target = (QueryEntity)((List)this.entities).get(targetIdx);
                for (QueryField field : op0.columns()) {
                    QueryEntityEx target0;
                    Set<String> notNullFields;
                    target.addQueryField(field.name(), field.typeName(), field.alias());
                    if (field.isNullable()) continue;
                    if (!(target instanceof QueryEntityEx)) {
                        target = new QueryEntityEx(target);
                        replaceTarget = true;
                    }
                    if ((notNullFields = (target0 = (QueryEntityEx)target).getNotNullFields()) == null) {
                        notNullFields = new HashSet<String>();
                        target0.setNotNullFields(notNullFields);
                    }
                    notNullFields.add(field.name());
                }
                if (replaceTarget) {
                    ((List)this.entities).set(targetIdx, target);
                }
            } else if (op instanceof SchemaAlterTableDropColumnOperation) {
                SchemaAlterTableDropColumnOperation op0 = (SchemaAlterTableDropColumnOperation)op;
                int targetIdx = -1;
                for (int i = 0; i < this.entities.size(); ++i) {
                    QueryEntity entity = (QueryEntity)((List)this.entities).get(i);
                    if (!F.eq(entity.getTableName(), op0.tableName())) continue;
                    targetIdx = i;
                    break;
                }
                if (targetIdx == -1) {
                    return;
                }
                QueryEntity entity = (QueryEntity)((List)this.entities).get(targetIdx);
                for (String field : op0.columns()) {
                    boolean rmv = QueryUtils.removeFieldAndAlias(entity, field);
                    assert (rmv || op0.ifExists()) : "Invalid operation state [removed=" + rmv + ", ifExists=" + op0.ifExists() + ']';
                }
            } else {
                assert (op instanceof SchemaAddQueryEntityOperation) : "Unsupported schema operation [" + op.toString() + "]";
                assert (this.entities.isEmpty());
                for (QueryEntity opEntity : ((SchemaAddQueryEntityOperation)op).entities()) {
                    this.entities.add(QueryUtils.copy(opEntity));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QueryEntity> entities() {
        Object object = this.mux;
        synchronized (object) {
            return new ArrayList<QueryEntity>(this.entities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.mux;
        synchronized (object) {
            return this.entities.isEmpty();
        }
    }

    public String toString() {
        return S.toString(QuerySchema.class, this);
    }
}

