/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.binary.CacheObjectBinaryProcessorImpl;
import org.apache.ignite.internal.processors.platform.client.ClientBitmaskFeature;
import org.apache.ignite.internal.processors.platform.client.ClientProtocolContext;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCachePartitionMapping;
import org.jetbrains.annotations.Nullable;

class ClientCachePartitionAwarenessGroup {
    @Nullable
    private final ClientCachePartitionMapping mapping;
    private final boolean dfltAffinity;
    private final Map<Integer, CacheConfiguration<?, ?>> cacheCfgs = new HashMap();

    public ClientCachePartitionAwarenessGroup(@Nullable ClientCachePartitionMapping mapping, boolean dfltAffinity) {
        this.mapping = mapping;
        this.dfltAffinity = dfltAffinity;
    }

    public void write(CacheObjectBinaryProcessorImpl proc, BinaryRawWriter writer, ClientProtocolContext cpctx) {
        boolean isPartitionAwarenessApplicable = this.mapping != null;
        writer.writeBoolean(isPartitionAwarenessApplicable);
        writer.writeInt(this.cacheCfgs.size());
        if (isPartitionAwarenessApplicable) {
            for (Map.Entry<Integer, CacheConfiguration<?, ?>> entry : this.cacheCfgs.entrySet()) {
                writer.writeInt(entry.getKey());
                ClientCachePartitionAwarenessGroup.writeCacheKeyConfiguration(writer, proc, entry.getValue().getKeyConfiguration());
            }
            this.mapping.write(writer);
            if (cpctx.isFeatureSupported(ClientBitmaskFeature.ALL_AFFINITY_MAPPINGS)) {
                writer.writeBoolean(this.dfltAffinity);
            }
        } else {
            for (int cacheId : this.cacheCfgs.keySet()) {
                writer.writeInt(cacheId);
            }
        }
    }

    public void addAll(List<DynamicCacheDescriptor> descs) {
        for (DynamicCacheDescriptor desc : descs) {
            this.cacheCfgs.putIfAbsent(desc.cacheId(), desc.cacheConfiguration());
        }
    }

    private static void writeCacheKeyConfiguration(BinaryRawWriter writer, CacheObjectBinaryProcessorImpl binProc, CacheKeyConfiguration[] keyCfgs) {
        if (keyCfgs == null) {
            writer.writeInt(0);
            return;
        }
        writer.writeInt(keyCfgs.length);
        for (CacheKeyConfiguration keyCfg : keyCfgs) {
            int keyTypeId = binProc.typeId(keyCfg.getTypeName());
            int affinityKeyFieldId = binProc.binaryContext().fieldId(keyTypeId, keyCfg.getAffinityKeyFieldName());
            writer.writeInt(keyTypeId);
            writer.writeInt(affinityKeyFieldId);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientCachePartitionAwarenessGroup group = (ClientCachePartitionAwarenessGroup)o;
        return this.dfltAffinity == group.dfltAffinity && Objects.equals(this.mapping, group.mapping);
    }

    public int hashCode() {
        return Objects.hash(this.mapping, this.dfltAffinity);
    }
}

