/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot.dump;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.GridLocalConfigManager;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.AbstractCreateSnapshotFutureTask;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotFutureTaskResult;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotSender;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.Dump;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.DumpEntryChangeListener;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.DumpEntrySerializer;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.dump.WriteOnlyZipFileIOFactory;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.BasicRateLimiter;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.lang.GridCloseableIterator;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class CreateDumpFutureTask
extends AbstractCreateSnapshotFutureTask
implements DumpEntryChangeListener {
    public static final String DUMP_FILE_EXT = ".dump";
    private final File dumpDir;
    private final FileIOFactory ioFactory;
    private final boolean compress;
    private final BasicRateLimiter rateLimiter;
    private final AtomicLong processedSize = new AtomicLong();
    @Nullable
    private final Serializable encKey;
    private final Map<Long, PartitionDumpContext> dumpCtxs = new ConcurrentHashMap<Long, PartitionDumpContext>();
    private final Map<Integer, Set<Integer>> grpPrimaries = new ConcurrentHashMap<Integer, Set<Integer>>();
    private final ConcurrentMap<Long, ByteBuffer> thLocBufs = new ConcurrentHashMap<Long, ByteBuffer>();
    @Nullable
    private final ConcurrentMap<Long, ByteBuffer> encThLocBufs;

    public CreateDumpFutureTask(GridCacheSharedContext<?, ?> cctx, UUID srcNodeId, UUID reqId, String dumpName, File dumpDir, FileIOFactory ioFactory, BasicRateLimiter rateLimiter, SnapshotSender snpSndr, Map<Integer, Set<Integer>> parts, boolean compress, boolean encrypt) {
        super(cctx, srcNodeId, reqId, dumpName, snpSndr, parts);
        this.dumpDir = dumpDir;
        this.ioFactory = compress ? new WriteOnlyZipFileIOFactory() : ioFactory;
        this.compress = compress;
        this.rateLimiter = rateLimiter;
        this.encKey = encrypt ? cctx.gridConfig().getEncryptionSpi().create() : null;
        this.encThLocBufs = encrypt ? new ConcurrentHashMap() : null;
    }

    @Override
    public boolean start() {
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info("Start cache dump [name=" + this.snpName + ", grps=" + this.parts.keySet() + ']');
            }
            this.createDumpLock();
            this.processPartitions();
            this.prepare();
            this.saveSnapshotData();
        }
        catch (IOException | IgniteCheckedException e) {
            this.acceptException(e);
        }
        return false;
    }

    @Override
    protected void processPartitions() throws IgniteCheckedException {
        super.processPartitions();
        this.processed.values().forEach(parts -> parts.remove(65535));
    }

    private void prepare() throws IOException, IgniteCheckedException {
        for (Map.Entry e : this.processed.entrySet()) {
            int grp = (Integer)e.getKey();
            File grpDumpDir = this.groupDirectory(this.cctx.cache().cacheGroup(grp));
            if (!grpDumpDir.mkdirs()) {
                throw new IgniteCheckedException("Dump directory can't be created: " + grpDumpDir);
            }
            CacheGroupContext gctx = this.cctx.cache().cacheGroup(grp);
            for (GridCacheContext cctx : gctx.caches()) {
                cctx.dumpListener(this);
            }
            this.grpPrimaries.put(grp, gctx.affinity().primaryPartitions(gctx.shared().kernalContext().localNodeId(), gctx.affinity().lastVersion()));
        }
    }

    @Override
    protected List<CompletableFuture<Void>> saveCacheConfigs() {
        return this.processed.keySet().stream().map(grp -> this.runAsync(() -> {
            CacheGroupContext gctx = this.cctx.cache().cacheGroup((int)grp);
            File grpDir = this.groupDirectory(gctx);
            IgniteUtils.ensureDirectory(grpDir, "dump group directory", null);
            for (GridCacheContext cacheCtx : gctx.caches()) {
                DynamicCacheDescriptor desc = this.cctx.kernalContext().cache().cacheDescriptor(cacheCtx.cacheId());
                StoredCacheData cacheData = new StoredCacheData(new CacheConfiguration(desc.cacheConfiguration()));
                cacheData.queryEntities(desc.schema().entities());
                cacheData.sql(desc.sql());
                this.cctx.cache().configManager().writeCacheData(cacheData, new File(grpDir, GridLocalConfigManager.cacheDataFilename(cacheData.config())));
            }
        })).collect(Collectors.toList());
    }

    @Override
    protected List<CompletableFuture<Void>> saveGroup(int grp, Set<Integer> grpParts) {
        long start = System.currentTimeMillis();
        AtomicLong entriesCnt = new AtomicLong();
        AtomicLong writtenEntriesCnt = new AtomicLong();
        AtomicLong changedEntriesCnt = new AtomicLong();
        String name = this.cctx.cache().cacheGroup(grp).cacheOrGroupName();
        CacheGroupContext gctx = this.cctx.kernalContext().cache().cacheGroup(grp);
        if (this.log.isInfoEnabled()) {
            this.log.info("Start group dump [name=" + name + ", id=" + grp + ']');
        }
        List<CompletableFuture<Void>> futs = grpParts.stream().map(part -> this.runAsync(() -> {
            long entriesCnt0 = 0L;
            long writtenEntriesCnt0 = 0L;
            try (PartitionDumpContext dumpCtx = this.dumpContext(grp, (int)part);){
                try (GridCloseableIterator<CacheDataRow> rows = gctx.offheap().reservedIterator((int)part, dumpCtx.topVer);){
                    if (rows == null) {
                        throw new IgniteCheckedException("Partition missing [part=" + part + ']');
                    }
                    while (rows.hasNext()) {
                        int cache;
                        CacheDataRow row = (CacheDataRow)rows.next();
                        assert (row.partition() == part.intValue());
                        int n = cache = row.cacheId() == 0 ? grp : row.cacheId();
                        if (dumpCtx.writeForIterator(cache, row.expireTime(), row.key(), row.value(), row.version())) {
                            ++writtenEntriesCnt0;
                        }
                        ++entriesCnt0;
                    }
                }
                entriesCnt.addAndGet(entriesCnt0);
                writtenEntriesCnt.addAndGet(writtenEntriesCnt0);
                changedEntriesCnt.addAndGet(dumpCtx.changedCnt.intValue());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Finish group partition dump [name=" + name + ", id=" + grp + ", part=" + part + ", time=" + (System.currentTimeMillis() - start) + ", iterEntriesCnt=" + entriesCnt + ", writtenIterEntriesCnt=" + entriesCnt + ", changedEntriesCnt=" + changedEntriesCnt + ']');
                }
            }
        })).collect(Collectors.toList());
        int futsSize = futs.size();
        CompletableFuture.allOf(futs.toArray(new CompletableFuture[futsSize])).whenComplete((res, t) -> {
            this.clearDumpListener(gctx);
            if (this.log.isInfoEnabled()) {
                this.log.info("Finish group dump [name=" + name + ", id=" + grp + ", time=" + (System.currentTimeMillis() - start) + ", iterEntriesCnt=" + entriesCnt.get() + ", writtenIterEntriesCnt=" + writtenEntriesCnt.get() + ", changedEntriesCnt=" + changedEntriesCnt.get() + ']');
            }
        });
        return futs;
    }

    @Override
    public void beforeChange(GridCacheContext cctx, KeyCacheObject key, CacheObject val, long expireTime, GridCacheVersion ver) {
        try {
            int part = key.partition();
            int grp = cctx.groupId();
            assert (part != -1);
            if (!((Set)this.processed.get(grp)).contains(part)) {
                return;
            }
            this.dumpContext(grp, part).writeChanged(cctx.cacheId(), expireTime, key, val, ver);
        }
        catch (IgniteException e) {
            this.acceptException(e);
        }
    }

    @Override
    protected synchronized CompletableFuture<Void> closeAsync() {
        if (this.closeFut == null) {
            this.dumpCtxs.values().forEach(PartitionDumpContext::close);
            Throwable err0 = (Throwable)this.err.get();
            HashSet<GroupPartitionId> taken = new HashSet<GroupPartitionId>();
            for (Map.Entry e : this.processed.entrySet()) {
                int grp = (Integer)e.getKey();
                this.clearDumpListener(this.cctx.cache().cacheGroup(grp));
                for (Integer part : (Set)e.getValue()) {
                    taken.add(new GroupPartitionId(grp, part));
                }
            }
            this.closeFut = CompletableFuture.runAsync(() -> {
                this.thLocBufs.clear();
                if (this.encThLocBufs != null) {
                    this.encThLocBufs.clear();
                }
                this.onDone(new SnapshotFutureTaskResult(taken, null), err0);
            }, this.cctx.kernalContext().pools().getSystemExecutorService());
        }
        return this.closeFut;
    }

    public long processedSize() {
        return this.processedSize.get();
    }

    private void clearDumpListener(CacheGroupContext gctx) {
        for (GridCacheContext cctx : gctx.caches()) {
            cctx.dumpListener(null);
        }
    }

    private void createDumpLock() throws IgniteCheckedException, IOException {
        File nodeDumpDir = IgniteSnapshotManager.nodeDumpDirectory(this.dumpDir, this.cctx);
        if (!nodeDumpDir.mkdirs()) {
            throw new IgniteCheckedException("Can't create node dump directory: " + nodeDumpDir.getAbsolutePath());
        }
        File lock = new File(nodeDumpDir, "dump.lock");
        if (!lock.createNewFile()) {
            throw new IgniteCheckedException("Lock file can't be created or already exists: " + lock.getAbsolutePath());
        }
    }

    private PartitionDumpContext dumpContext(int grp, int part) {
        return this.dumpCtxs.computeIfAbsent(IgniteUtils.toLong(grp, part), key -> new PartitionDumpContext(this.cctx.kernalContext().cache().cacheGroup(grp), part));
    }

    private File groupDirectory(CacheGroupContext grpCtx) throws IgniteCheckedException {
        return new File(IgniteSnapshotManager.nodeDumpDirectory(this.dumpDir, this.cctx), (grpCtx.caches().size() > 1 ? "cacheGroup-" : "cache-") + grpCtx.cacheOrGroupName());
    }

    @Nullable
    public Serializable encryptionKey() {
        return this.encKey;
    }

    private class PartitionDumpContext
    implements Closeable {
        final int grp;
        final int part;
        final Map<Integer, Set<KeyCacheObject>> changed;
        LongAdder changedCnt = new LongAdder();
        final FileIO file;
        @Nullable
        final GridCacheVersion startVer;
        final GridCacheVersion isolatedStreamerVer;
        private final AffinityTopologyVersion topVer;
        private final DumpEntrySerializer serializer;
        volatile boolean closed;
        private final AtomicInteger writers = new AtomicInteger(1);

        public PartitionDumpContext(CacheGroupContext gctx, int part) {
            assert (gctx != null);
            try {
                this.part = part;
                this.grp = gctx.groupId();
                this.topVer = gctx.topology().lastTopologyChangeVersion();
                this.startVer = ((Set)CreateDumpFutureTask.this.grpPrimaries.get(gctx.groupId())).contains(part) ? gctx.shared().versions().last() : null;
                this.isolatedStreamerVer = CreateDumpFutureTask.this.cctx.versions().isolatedStreamerVersion();
                this.serializer = new DumpEntrySerializer(CreateDumpFutureTask.this.thLocBufs, CreateDumpFutureTask.this.encThLocBufs, CreateDumpFutureTask.this.encKey, CreateDumpFutureTask.this.cctx.gridConfig().getEncryptionSpi());
                this.changed = new HashMap<Integer, Set<KeyCacheObject>>();
                for (int cache : gctx.cacheIds()) {
                    this.changed.put(cache, new GridConcurrentHashSet());
                }
                File dumpFile = new File(CreateDumpFutureTask.this.groupDirectory(gctx), Dump.dumpPartFileName(part, CreateDumpFutureTask.this.compress));
                if (!dumpFile.createNewFile()) {
                    throw new IgniteException("Dump file can't be created: " + dumpFile);
                }
                this.file = CreateDumpFutureTask.this.ioFactory.create(dumpFile);
            }
            catch (IOException | IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeChanged(int cache, long expireTime, KeyCacheObject key, CacheObject val, GridCacheVersion ver) {
            String reasonToSkip = null;
            if (this.closed) {
                reasonToSkip = "partition already saved";
            } else {
                this.writers.getAndIncrement();
                try {
                    if (this.closed) {
                        reasonToSkip = "partition already saved";
                    } else if (this.isAfterStart(ver)) {
                        reasonToSkip = "greater version";
                    } else if (!this.changed.get(cache).add(key)) {
                        reasonToSkip = "changed several times";
                    } else if (val == null) {
                        reasonToSkip = "newly created or already removed";
                    } else {
                        this.write(cache, expireTime, key, val, ver);
                        this.changedCnt.increment();
                    }
                }
                finally {
                    this.writers.decrementAndGet();
                }
            }
            if (CreateDumpFutureTask.this.log.isTraceEnabled()) {
                CreateDumpFutureTask.this.log.trace("Listener [grp=" + this.grp + ", cache=" + cache + ", part=" + this.part + ", key=" + key + ", written=" + (reasonToSkip == null ? "true" : reasonToSkip) + ']');
            }
        }

        public boolean writeForIterator(int cache, long expireTime, KeyCacheObject key, CacheObject val, GridCacheVersion ver) {
            boolean written = true;
            if (this.isAfterStart(ver)) {
                written = false;
            } else if (this.changed.get(cache).contains(key)) {
                written = false;
            } else {
                this.write(cache, expireTime, key, val, ver);
            }
            if (CreateDumpFutureTask.this.log.isTraceEnabled()) {
                CreateDumpFutureTask.this.log.trace("Iterator [grp=" + this.grp + ", cache=" + cache + ", part=" + this.part + ", key=" + key + ", written=" + written + ", ver=" + ver + ']');
            }
            return written;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(int cache, long expireTime, KeyCacheObject key, CacheObject val, GridCacheVersion ver) {
            DumpEntrySerializer dumpEntrySerializer = this.serializer;
            synchronized (dumpEntrySerializer) {
                try {
                    ByteBuffer buf = this.serializer.writeToBuffer(cache, expireTime, key, val, ver, CreateDumpFutureTask.this.cctx.cacheObjectContext(cache));
                    CreateDumpFutureTask.this.rateLimiter.acquire(buf.limit());
                    if (this.file.writeFully(buf) != buf.limit()) {
                        throw new IgniteException("Can't write row");
                    }
                    CreateDumpFutureTask.this.processedSize.addAndGet(buf.limit());
                }
                catch (IOException | IgniteCheckedException e) {
                    throw new IgniteException(e);
                }
            }
        }

        private boolean isAfterStart(GridCacheVersion ver) {
            return this.startVer != null && ver.isGreater(this.startVer) && !this.isolatedStreamerVer.equals(ver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            PartitionDumpContext partitionDumpContext = this;
            synchronized (partitionDumpContext) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            this.writers.decrementAndGet();
            while (this.writers.get() > 0) {
                LockSupport.parkNanos(1000000L);
            }
            U.closeQuiet(this.file);
        }
    }
}

