/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.LongJVMPauseDetector;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointHistory;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointListener;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointMarkersStorage;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointPagesWriterFactory;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointReadWriteLock;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointStatus;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointTimeoutLock;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointWorkflow;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.Checkpointer;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryEx;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMemoryImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.failure.FailureProcessor;
import org.apache.ignite.internal.util.StripedExecutor;
import org.apache.ignite.internal.util.lang.IgniteThrowableBiPredicate;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.worker.WorkersRegistry;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class CheckpointManager {
    private volatile Checkpointer checkpointer;
    private final CheckpointWorkflow checkpointWorkflow;
    private final CheckpointMarkersStorage checkpointMarkersStorage;
    final CheckpointTimeoutLock checkpointTimeoutLock;
    private final CheckpointPagesWriterFactory checkpointPagesWriterFactory;
    private final Supplier<Checkpointer> checkpointerProvider;

    public CheckpointManager(Function<Class<?>, IgniteLogger> logger, String igniteInstanceName, String checkpointThreadName, IgniteWriteAheadLogManager wal, WorkersRegistry workersRegistry, final DataStorageConfiguration persistenceCfg, FilePageStoreManager pageStoreManager, IgniteThrowableBiPredicate<Long, Integer> checkpointInapplicableChecker, Supplier<Collection<DataRegion>> dataRegions, Supplier<Collection<CacheGroupContext>> cacheGroupContexts, IgniteThrowableFunction<Integer, PageMemoryEx> pageMemoryGroupResolver, PageMemoryImpl.ThrottlingPolicy throttlingPolicy, DataStorageMetricsImpl persStoreMetrics, LongJVMPauseDetector longJvmPauseDetector, FailureProcessor failureProcessor, GridCacheProcessor cacheProcessor, Supplier<Integer> cpFreqDeviation, Executor checkpointMapSnapshotExecutor) throws IgniteCheckedException {
        CheckpointHistory cpHistory = new CheckpointHistory(persistenceCfg, logger, wal, checkpointInapplicableChecker);
        FileIOFactory ioFactory = persistenceCfg.getFileIOFactory();
        CheckpointReadWriteLock lock = new CheckpointReadWriteLock(logger);
        this.checkpointMarkersStorage = new CheckpointMarkersStorage(igniteInstanceName, logger, cpHistory, ioFactory, pageStoreManager.workDir().getAbsolutePath(), lock, checkpointMapSnapshotExecutor);
        this.checkpointWorkflow = new CheckpointWorkflow(logger, wal, this.checkpointMarkersStorage, lock, persistenceCfg.getCheckpointWriteOrder(), dataRegions, cacheGroupContexts, persistenceCfg.getCheckpointThreads(), igniteInstanceName);
        ThreadLocal<ByteBuffer> threadBuf = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                ByteBuffer tmpWriteBuf = ByteBuffer.allocateDirect(persistenceCfg.getPageSize());
                tmpWriteBuf.order(ByteOrder.nativeOrder());
                return tmpWriteBuf;
            }
        };
        this.checkpointPagesWriterFactory = new CheckpointPagesWriterFactory(logger, (pageMemEx, fullPage, buf, tag) -> pageStoreManager.write(fullPage.groupId(), fullPage.pageId(), buf, tag, true), persStoreMetrics, throttlingPolicy, threadBuf, pageMemoryGroupResolver);
        this.checkpointerProvider = () -> new Checkpointer(igniteInstanceName, checkpointThreadName, workersRegistry, logger, longJvmPauseDetector, failureProcessor, persStoreMetrics, cacheProcessor, this.checkpointWorkflow, this.checkpointPagesWriterFactory, persistenceCfg.getCheckpointFrequency(), persistenceCfg.getCheckpointThreads(), cpFreqDeviation);
        this.checkpointer = this.checkpointerProvider.get();
        Long cfgCheckpointReadLockTimeout = persistenceCfg != null ? persistenceCfg.getCheckpointReadLockTimeout() : null;
        long checkpointReadLockTimeout = IgniteSystemProperties.getLong("IGNITE_CHECKPOINT_READ_LOCK_TIMEOUT", cfgCheckpointReadLockTimeout != null ? cfgCheckpointReadLockTimeout.longValue() : workersRegistry.getSystemWorkerBlockedTimeout());
        this.checkpointTimeoutLock = new CheckpointTimeoutLock(logger, failureProcessor, dataRegions, lock, this.checkpointer, checkpointReadLockTimeout);
    }

    public CheckpointTimeoutLock checkpointTimeoutLock() {
        return this.checkpointTimeoutLock;
    }

    public void threadBuf(ThreadLocal<ByteBuffer> threadBuf) {
        this.checkpointPagesWriterFactory.threadBuf(threadBuf);
    }

    public void addCheckpointListener(CheckpointListener lsnr, DataRegion dataRegion) {
        this.checkpointWorkflow.addCheckpointListener(lsnr, dataRegion);
    }

    public void removeCheckpointListener(CheckpointListener lsnr) {
        this.checkpointWorkflow.removeCheckpointListener(lsnr);
    }

    public void memoryRecoveryRecordPtr(WALPointer memoryRecoveryRecordPtr) {
        this.checkpointWorkflow.memoryRecoveryRecordPtr(memoryRecoveryRecordPtr);
    }

    public File checkpointDirectory() {
        return this.checkpointMarkersStorage.cpDir;
    }

    public CheckpointMarkersStorage checkpointMarkerStorage() {
        return this.checkpointMarkersStorage;
    }

    public CheckpointStatus readCheckpointStatus() throws IgniteCheckedException {
        return this.checkpointMarkersStorage.readCheckpointStatus();
    }

    public <R> CheckpointProgress forceCheckpoint(String reason, IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
        Checkpointer cp = this.checkpointer;
        if (cp == null) {
            return null;
        }
        return cp.scheduleCheckpoint(0L, reason, lsnr);
    }

    public CheckpointHistory checkpointHistory() {
        return this.checkpointMarkersStorage.history();
    }

    public void initializeStorage() throws IgniteCheckedException {
        this.checkpointMarkersStorage.initialize();
    }

    public void removeCheckpointsUntil(@Nullable WALPointer highBound) throws IgniteCheckedException {
        this.checkpointMarkersStorage.removeCheckpointsUntil(highBound);
    }

    public void cleanupTempCheckpointDirectory() throws IgniteCheckedException {
        this.checkpointMarkersStorage.cleanupTempCheckpointDirectory();
    }

    public void cleanupCheckpointDirectory() throws IgniteCheckedException {
        this.checkpointMarkersStorage.cleanupCheckpointDirectory();
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    public void schedulePartitionDestroy(@Nullable CacheGroupContext context, int groupId, int partId) {
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.schedulePartitionDestroy(context, groupId, partId);
        }
    }

    public IgniteInternalFuture<Void> enableCheckpoints(boolean enable) {
        return this.checkpointer.enableCheckpoints(enable);
    }

    public void finalizeCheckpointOnRecovery(long ts, UUID id, WALPointer ptr, StripedExecutor exec) throws IgniteCheckedException {
        assert (this.checkpointer != null) : "Checkpointer hasn't initialized yet";
        this.checkpointer.finalizeCheckpointOnRecovery(ts, id, ptr, exec);
    }

    public boolean cancelOrWaitPartitionDestroy(int grpId, int partId) throws IgniteCheckedException {
        Checkpointer cp = this.checkpointer;
        return cp != null && cp.cancelOrWaitPartitionDestroy(grpId, partId);
    }

    public void stop(boolean cancel) {
        this.checkpointTimeoutLock.stop();
        Checkpointer cp = this.checkpointer;
        if (cp != null) {
            cp.shutdownCheckpointer(cancel);
        }
        this.checkpointWorkflow.stop();
        this.checkpointer = null;
    }

    public void init() {
        if (this.checkpointer == null) {
            this.checkpointWorkflow.start();
            this.checkpointer = this.checkpointerProvider.get();
        }
    }

    public void start() {
        assert (this.checkpointer != null) : "Checkpointer can't be null during the start";
        this.checkpointer.start();
    }

    public void unblockCheckpointLock() {
        this.checkpointTimeoutLock.start();
    }
}

