/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import org.apache.ignite.cache.CacheMetrics;
import org.apache.ignite.internal.marshaller.optimized.OptimizedObjectOutputStream;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.util.typedef.internal.S;

@Deprecated
public class CacheMetricsSnapshot
implements CacheMetrics,
Externalizable {
    private static final long serialVersionUID = 0L;
    private long reads = 0L;
    private long puts = 0L;
    private long entryProcessorPuts = 0L;
    private long entryProcessorReadOnlyInvocations = 0L;
    private float entryProcessorAverageInvocationTime = 0.0f;
    private long entryProcessorInvocations = 0L;
    private long entryProcessorRemovals = 0L;
    private long entryProcessorMisses = 0L;
    private long entryProcessorHits = 0L;
    private float entryProcessorMissPercentage = 0.0f;
    private float entryProcessorHitPercentage = 0.0f;
    private float entryProcessorMaxInvocationTime = 0.0f;
    private float entryProcessorMinInvocationTime = 0.0f;
    private long hits = 0L;
    private long misses = 0L;
    private long txCommits = 0L;
    private long txRollbacks = 0L;
    private long evicts = 0L;
    private long removes = 0L;
    private float putAvgTimeNanos = 0.0f;
    private float getAvgTimeNanos = 0.0f;
    private float rmvAvgTimeNanos = 0.0f;
    private float commitAvgTimeNanos = 0.0f;
    private float rollbackAvgTimeNanos = 0.0f;
    private String cacheName;
    private long offHeapGets;
    private long offHeapPuts;
    private long offHeapRemoves;
    private long offHeapEvicts;
    private long offHeapHits;
    private long offHeapMisses;
    private long offHeapEntriesCnt;
    private long heapEntriesCnt;
    private long offHeapPrimaryEntriesCnt;
    private long offHeapBackupEntriesCnt;
    private long offHeapAllocatedSize;
    private int size;
    private long cacheSize;
    private int keySize;
    private boolean isEmpty;
    private int dhtEvictQueueCurrSize;
    private int txThreadMapSize;
    private int txXidMapSize;
    private int txCommitQueueSize;
    private int txPrepareQueueSize;
    private int txStartVerCountsSize;
    private int txCommittedVersionsSize;
    private int txRolledbackVersionsSize;
    private int txDhtThreadMapSize;
    private int txDhtXidMapSize;
    private int txDhtCommitQueueSize;
    private int txDhtPrepareQueueSize;
    private int txDhtStartVerCountsSize;
    private int txDhtCommittedVersionsSize;
    private int txDhtRolledbackVersionsSize;
    private boolean isWriteBehindEnabled;
    private int writeBehindFlushSize;
    private int writeBehindFlushThreadCnt;
    private long writeBehindFlushFreq;
    private int writeBehindStoreBatchSize;
    private int writeBehindTotalCriticalOverflowCnt;
    private int writeBehindCriticalOverflowCnt;
    private int writeBehindErrorRetryCnt;
    private int writeBehindBufSize;
    private int totalPartitionsCnt;
    private int rebalancingPartitionsCnt;
    private long rebalancedKeys;
    private long estimatedRebalancingKeys;
    private long keysToRebalanceLeft;
    private long rebalancingKeysRate;
    private long rebalancingBytesRate;
    private long rebalanceStartTime;
    private long rebalanceFinishTime;
    private long rebalanceClearingPartitionsLeft;
    private String keyType;
    private String valType;
    private boolean isStoreByVal;
    private boolean isStatisticsEnabled;
    private boolean isManagementEnabled;
    private boolean isReadThrough;
    private boolean isWriteThrough;
    private boolean isValidForReading;
    private boolean isValidForWriting;
    private boolean idxRebuildInProgress;
    private long idxRebuildKeyProcessed;

    public CacheMetricsSnapshot() {
    }

    public CacheMetricsSnapshot(CacheMetricsImpl m) {
        this.reads = m.getCacheGets();
        this.puts = m.getCachePuts();
        this.hits = m.getCacheHits();
        this.misses = m.getCacheMisses();
        this.txCommits = m.getCacheTxCommits();
        this.txRollbacks = m.getCacheTxRollbacks();
        this.evicts = m.getCacheEvictions();
        this.removes = m.getCacheRemovals();
        this.entryProcessorPuts = m.getEntryProcessorPuts();
        this.entryProcessorReadOnlyInvocations = m.getEntryProcessorReadOnlyInvocations();
        this.entryProcessorInvocations = m.getEntryProcessorInvocations();
        this.entryProcessorRemovals = m.getEntryProcessorRemovals();
        this.entryProcessorMisses = m.getEntryProcessorMisses();
        this.entryProcessorHits = m.getEntryProcessorHits();
        this.entryProcessorMissPercentage = m.getEntryProcessorMissPercentage();
        this.entryProcessorHitPercentage = m.getEntryProcessorHitPercentage();
        this.entryProcessorAverageInvocationTime = m.getEntryProcessorAverageInvocationTime();
        this.entryProcessorMaxInvocationTime = m.getEntryProcessorMaxInvocationTime();
        this.entryProcessorMinInvocationTime = m.getEntryProcessorMinInvocationTime();
        this.putAvgTimeNanos = m.getAveragePutTime();
        this.getAvgTimeNanos = m.getAverageGetTime();
        this.rmvAvgTimeNanos = m.getAverageRemoveTime();
        this.commitAvgTimeNanos = m.getAverageTxCommitTime();
        this.rollbackAvgTimeNanos = m.getAverageTxRollbackTime();
        this.cacheName = m.name();
        this.offHeapGets = m.getOffHeapGets();
        this.offHeapPuts = m.getOffHeapPuts();
        this.offHeapRemoves = m.getOffHeapRemovals();
        this.offHeapEvicts = m.getOffHeapEvictions();
        this.offHeapHits = m.getOffHeapHits();
        this.offHeapMisses = m.getOffHeapMisses();
        CacheMetricsImpl.EntriesStatMetrics entriesStat = m.getEntriesStat();
        this.offHeapEntriesCnt = entriesStat.offHeapEntriesCount();
        this.heapEntriesCnt = entriesStat.heapEntriesCount();
        this.offHeapPrimaryEntriesCnt = entriesStat.offHeapPrimaryEntriesCount();
        this.offHeapBackupEntriesCnt = entriesStat.offHeapBackupEntriesCount();
        this.offHeapAllocatedSize = m.getOffHeapAllocatedSize();
        this.cacheSize = entriesStat.cacheSize();
        this.keySize = entriesStat.keySize();
        this.size = entriesStat.size();
        this.isEmpty = entriesStat.isEmpty();
        this.dhtEvictQueueCurrSize = m.getDhtEvictQueueCurrentSize();
        this.txThreadMapSize = m.getTxThreadMapSize();
        this.txXidMapSize = m.getTxXidMapSize();
        this.txCommitQueueSize = m.getTxCommitQueueSize();
        this.txPrepareQueueSize = m.getTxPrepareQueueSize();
        this.txStartVerCountsSize = m.getTxStartVersionCountsSize();
        this.txCommittedVersionsSize = m.getTxCommittedVersionsSize();
        this.txRolledbackVersionsSize = m.getTxRolledbackVersionsSize();
        this.txDhtThreadMapSize = m.getTxDhtThreadMapSize();
        this.txDhtXidMapSize = m.getTxDhtXidMapSize();
        this.txDhtCommitQueueSize = m.getTxDhtCommitQueueSize();
        this.txDhtPrepareQueueSize = m.getTxDhtPrepareQueueSize();
        this.txDhtStartVerCountsSize = m.getTxDhtStartVersionCountsSize();
        this.txDhtCommittedVersionsSize = m.getTxDhtCommittedVersionsSize();
        this.txDhtRolledbackVersionsSize = m.getTxDhtRolledbackVersionsSize();
        this.isWriteBehindEnabled = m.isWriteBehindEnabled();
        this.writeBehindFlushSize = m.getWriteBehindFlushSize();
        this.writeBehindFlushThreadCnt = m.getWriteBehindFlushThreadCount();
        this.writeBehindFlushFreq = m.getWriteBehindFlushFrequency();
        this.writeBehindStoreBatchSize = m.getWriteBehindStoreBatchSize();
        this.writeBehindTotalCriticalOverflowCnt = m.getWriteBehindTotalCriticalOverflowCount();
        this.writeBehindCriticalOverflowCnt = m.getWriteBehindCriticalOverflowCount();
        this.writeBehindErrorRetryCnt = m.getWriteBehindErrorRetryCount();
        this.writeBehindBufSize = m.getWriteBehindBufferSize();
        this.keyType = m.getKeyType();
        this.valType = m.getValueType();
        this.isStoreByVal = m.isStoreByValue();
        this.isStatisticsEnabled = m.isStatisticsEnabled();
        this.isManagementEnabled = m.isManagementEnabled();
        this.isReadThrough = m.isReadThrough();
        this.isWriteThrough = m.isWriteThrough();
        this.isValidForReading = m.isValidForReading();
        this.isValidForWriting = m.isValidForWriting();
        this.totalPartitionsCnt = entriesStat.totalPartitionsCount();
        this.rebalancingPartitionsCnt = entriesStat.rebalancingPartitionsCount();
        this.rebalancedKeys = m.getRebalancedKeys();
        this.estimatedRebalancingKeys = m.getEstimatedRebalancingKeys();
        this.keysToRebalanceLeft = m.getKeysToRebalanceLeft();
        this.rebalancingBytesRate = m.getRebalancingBytesRate();
        this.rebalancingKeysRate = m.getRebalancingKeysRate();
        this.rebalanceStartTime = m.rebalancingStartTime();
        this.rebalanceFinishTime = m.estimateRebalancingFinishTime();
        this.rebalanceClearingPartitionsLeft = m.getRebalanceClearingPartitionsLeft();
        this.idxRebuildInProgress = m.isIndexRebuildInProgress();
        this.idxRebuildKeyProcessed = m.getIndexRebuildKeysProcessed();
    }

    public CacheMetricsSnapshot(CacheMetrics loc, Collection<CacheMetrics> metrics) {
        this.cacheName = loc.name();
        this.isEmpty = loc.isEmpty();
        this.isWriteBehindEnabled = loc.isWriteBehindEnabled();
        this.writeBehindFlushSize = loc.getWriteBehindFlushSize();
        this.writeBehindFlushThreadCnt = loc.getWriteBehindFlushThreadCount();
        this.writeBehindFlushFreq = loc.getWriteBehindFlushFrequency();
        this.writeBehindStoreBatchSize = loc.getWriteBehindStoreBatchSize();
        this.writeBehindBufSize = loc.getWriteBehindBufferSize();
        this.size = loc.getSize();
        this.cacheSize = loc.getCacheSize();
        this.keySize = loc.getKeySize();
        this.keyType = loc.getKeyType();
        this.valType = loc.getValueType();
        this.isStoreByVal = loc.isStoreByValue();
        this.isStatisticsEnabled = loc.isStatisticsEnabled();
        this.isManagementEnabled = loc.isManagementEnabled();
        this.isReadThrough = loc.isReadThrough();
        this.isWriteThrough = loc.isWriteThrough();
        this.isValidForReading = loc.isValidForReading();
        this.isValidForWriting = loc.isValidForWriting();
        for (CacheMetrics e : metrics) {
            this.reads += e.getCacheGets();
            this.puts += e.getCachePuts();
            this.hits += e.getCacheHits();
            this.misses += e.getCacheMisses();
            this.txCommits += e.getCacheTxCommits();
            this.txRollbacks += e.getCacheTxRollbacks();
            this.evicts += e.getCacheEvictions();
            this.removes += e.getCacheRemovals();
            this.entryProcessorPuts = e.getEntryProcessorPuts();
            this.entryProcessorReadOnlyInvocations = e.getEntryProcessorReadOnlyInvocations();
            this.entryProcessorInvocations = e.getEntryProcessorInvocations();
            this.entryProcessorRemovals = e.getEntryProcessorRemovals();
            this.entryProcessorMisses = e.getEntryProcessorMisses();
            this.entryProcessorHits = e.getEntryProcessorHits();
            this.entryProcessorMissPercentage = e.getEntryProcessorMissPercentage();
            this.entryProcessorHitPercentage = e.getEntryProcessorHitPercentage();
            this.entryProcessorAverageInvocationTime = e.getEntryProcessorAverageInvocationTime();
            this.entryProcessorMaxInvocationTime = e.getEntryProcessorMaxInvocationTime();
            this.entryProcessorMinInvocationTime = e.getEntryProcessorMinInvocationTime();
            this.putAvgTimeNanos += e.getAveragePutTime();
            this.getAvgTimeNanos += e.getAverageGetTime();
            this.rmvAvgTimeNanos += e.getAverageRemoveTime();
            this.commitAvgTimeNanos += e.getAverageTxCommitTime();
            this.rollbackAvgTimeNanos += e.getAverageTxRollbackTime();
            this.offHeapGets += e.getOffHeapGets();
            this.offHeapPuts += e.getOffHeapPuts();
            this.offHeapRemoves += e.getOffHeapRemovals();
            this.offHeapEvicts += e.getOffHeapEvictions();
            this.offHeapHits += e.getOffHeapHits();
            this.offHeapMisses += e.getOffHeapMisses();
            this.offHeapEntriesCnt += e.getOffHeapEntriesCount();
            this.heapEntriesCnt += e.getHeapEntriesCount();
            this.offHeapPrimaryEntriesCnt += e.getOffHeapPrimaryEntriesCount();
            this.offHeapBackupEntriesCnt += e.getOffHeapBackupEntriesCount();
            this.offHeapAllocatedSize += e.getOffHeapAllocatedSize();
            this.dhtEvictQueueCurrSize = e.getDhtEvictQueueCurrentSize() > -1 ? (this.dhtEvictQueueCurrSize += e.getDhtEvictQueueCurrentSize()) : -1;
            this.txThreadMapSize += e.getTxThreadMapSize();
            this.txXidMapSize += e.getTxXidMapSize();
            this.txCommitQueueSize += e.getTxCommitQueueSize();
            this.txPrepareQueueSize += e.getTxPrepareQueueSize();
            this.txStartVerCountsSize += e.getTxStartVersionCountsSize();
            this.txCommittedVersionsSize += e.getTxCommittedVersionsSize();
            this.txRolledbackVersionsSize += e.getTxRolledbackVersionsSize();
            this.txDhtThreadMapSize = e.getTxDhtThreadMapSize() > -1 ? (this.txDhtThreadMapSize += e.getTxDhtThreadMapSize()) : -1;
            this.txDhtXidMapSize = e.getTxDhtXidMapSize() > -1 ? (this.txDhtXidMapSize += e.getTxDhtXidMapSize()) : -1;
            this.txDhtCommitQueueSize = e.getTxDhtCommitQueueSize() > -1 ? (this.txDhtCommitQueueSize += e.getTxDhtCommitQueueSize()) : -1;
            this.txDhtPrepareQueueSize = e.getTxDhtPrepareQueueSize() > -1 ? (this.txDhtPrepareQueueSize += e.getTxDhtPrepareQueueSize()) : -1;
            this.txDhtStartVerCountsSize = e.getTxDhtStartVersionCountsSize() > -1 ? (this.txDhtStartVerCountsSize += e.getTxDhtStartVersionCountsSize()) : -1;
            this.txDhtCommittedVersionsSize = e.getTxDhtCommittedVersionsSize() > -1 ? (this.txDhtCommittedVersionsSize += e.getTxDhtCommittedVersionsSize()) : -1;
            this.txDhtRolledbackVersionsSize = e.getTxDhtRolledbackVersionsSize() > -1 ? (this.txDhtRolledbackVersionsSize += e.getTxDhtRolledbackVersionsSize()) : -1;
            this.writeBehindTotalCriticalOverflowCnt = e.getWriteBehindTotalCriticalOverflowCount() > -1 ? (this.writeBehindTotalCriticalOverflowCnt += e.getWriteBehindTotalCriticalOverflowCount()) : -1;
            this.writeBehindCriticalOverflowCnt = e.getWriteBehindCriticalOverflowCount() > -1 ? (this.writeBehindCriticalOverflowCnt += e.getWriteBehindCriticalOverflowCount()) : -1;
            this.writeBehindErrorRetryCnt = e.getWriteBehindErrorRetryCount() > -1 ? (this.writeBehindErrorRetryCnt += e.getWriteBehindErrorRetryCount()) : -1;
            this.rebalancedKeys += e.getRebalancedKeys();
            this.estimatedRebalancingKeys += e.getEstimatedRebalancingKeys();
            this.totalPartitionsCnt += e.getTotalPartitionsCount();
            this.rebalancingPartitionsCnt += e.getRebalancingPartitionsCount();
            this.keysToRebalanceLeft += e.getKeysToRebalanceLeft();
            this.rebalancingBytesRate += e.getRebalancingBytesRate();
            this.rebalancingKeysRate += e.getRebalancingKeysRate();
        }
        int size = metrics.size();
        if (size > 1) {
            this.putAvgTimeNanos /= (float)size;
            this.getAvgTimeNanos /= (float)size;
            this.rmvAvgTimeNanos /= (float)size;
            this.commitAvgTimeNanos /= (float)size;
            this.rollbackAvgTimeNanos /= (float)size;
        }
    }

    @Override
    public long getCacheHits() {
        return this.hits;
    }

    @Override
    public float getCacheHitPercentage() {
        if (this.hits == 0L || this.reads == 0L) {
            return 0.0f;
        }
        return (float)this.hits / (float)this.reads * 100.0f;
    }

    @Override
    public long getCacheMisses() {
        return this.misses;
    }

    @Override
    public float getCacheMissPercentage() {
        if (this.misses == 0L || this.reads == 0L) {
            return 0.0f;
        }
        return (float)this.misses / (float)this.reads * 100.0f;
    }

    @Override
    public long getCacheGets() {
        return this.reads;
    }

    @Override
    public long getCachePuts() {
        return this.puts;
    }

    @Override
    public long getEntryProcessorPuts() {
        return this.entryProcessorPuts;
    }

    @Override
    public long getEntryProcessorReadOnlyInvocations() {
        return this.entryProcessorReadOnlyInvocations;
    }

    @Override
    public long getEntryProcessorInvocations() {
        return this.entryProcessorInvocations;
    }

    @Override
    public long getEntryProcessorHits() {
        return this.entryProcessorHits;
    }

    @Override
    public float getEntryProcessorHitPercentage() {
        return this.entryProcessorHitPercentage;
    }

    @Override
    public float getEntryProcessorMissPercentage() {
        return this.entryProcessorMissPercentage;
    }

    @Override
    public long getEntryProcessorMisses() {
        return this.entryProcessorMisses;
    }

    @Override
    public long getEntryProcessorRemovals() {
        return this.entryProcessorRemovals;
    }

    @Override
    public float getEntryProcessorAverageInvocationTime() {
        return this.entryProcessorAverageInvocationTime;
    }

    @Override
    public float getEntryProcessorMinInvocationTime() {
        return this.entryProcessorMinInvocationTime;
    }

    @Override
    public float getEntryProcessorMaxInvocationTime() {
        return this.entryProcessorMaxInvocationTime;
    }

    @Override
    public long getCacheRemovals() {
        return this.removes;
    }

    @Override
    public long getCacheEvictions() {
        return this.evicts;
    }

    @Override
    public float getAverageGetTime() {
        return this.getAvgTimeNanos;
    }

    @Override
    public float getAveragePutTime() {
        return this.putAvgTimeNanos;
    }

    @Override
    public float getAverageRemoveTime() {
        return this.rmvAvgTimeNanos;
    }

    @Override
    public float getAverageTxCommitTime() {
        return this.commitAvgTimeNanos;
    }

    @Override
    public float getAverageTxRollbackTime() {
        return this.rollbackAvgTimeNanos;
    }

    @Override
    public long getCacheTxCommits() {
        return this.txCommits;
    }

    @Override
    public long getCacheTxRollbacks() {
        return this.txRollbacks;
    }

    @Override
    public String name() {
        return this.cacheName;
    }

    @Override
    public long getOffHeapGets() {
        return this.offHeapGets;
    }

    @Override
    public long getOffHeapPuts() {
        return this.offHeapPuts;
    }

    @Override
    public long getOffHeapRemovals() {
        return this.offHeapRemoves;
    }

    @Override
    public long getOffHeapEvictions() {
        return this.offHeapEvicts;
    }

    @Override
    public long getOffHeapHits() {
        return this.offHeapHits;
    }

    @Override
    public float getOffHeapHitPercentage() {
        if (this.offHeapHits == 0L || this.offHeapGets == 0L) {
            return 0.0f;
        }
        return (float)this.offHeapHits / (float)this.offHeapGets * 100.0f;
    }

    @Override
    public long getOffHeapMisses() {
        return this.offHeapMisses;
    }

    @Override
    public float getOffHeapMissPercentage() {
        if (this.offHeapMisses == 0L || this.offHeapGets == 0L) {
            return 0.0f;
        }
        return (float)this.offHeapMisses / (float)this.offHeapGets * 100.0f;
    }

    @Override
    public long getOffHeapEntriesCount() {
        return this.offHeapEntriesCnt;
    }

    @Override
    public long getHeapEntriesCount() {
        return this.heapEntriesCnt;
    }

    @Override
    public long getOffHeapPrimaryEntriesCount() {
        return this.offHeapPrimaryEntriesCnt;
    }

    @Override
    public long getOffHeapBackupEntriesCount() {
        return this.offHeapBackupEntriesCnt;
    }

    @Override
    public long getOffHeapAllocatedSize() {
        return this.offHeapAllocatedSize;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public int getKeySize() {
        return this.keySize;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public int getDhtEvictQueueCurrentSize() {
        return this.dhtEvictQueueCurrSize;
    }

    @Override
    public int getTxThreadMapSize() {
        return this.txThreadMapSize;
    }

    @Override
    public int getTxXidMapSize() {
        return this.txXidMapSize;
    }

    @Override
    public int getTxCommitQueueSize() {
        return this.txCommitQueueSize;
    }

    @Override
    public int getTxPrepareQueueSize() {
        return this.txPrepareQueueSize;
    }

    @Override
    public int getTxStartVersionCountsSize() {
        return this.txStartVerCountsSize;
    }

    @Override
    public int getTxCommittedVersionsSize() {
        return this.txCommittedVersionsSize;
    }

    @Override
    public int getTxRolledbackVersionsSize() {
        return this.txRolledbackVersionsSize;
    }

    @Override
    public int getTxDhtThreadMapSize() {
        return this.txDhtThreadMapSize;
    }

    @Override
    public int getTxDhtXidMapSize() {
        return this.txDhtXidMapSize;
    }

    @Override
    public int getTxDhtCommitQueueSize() {
        return this.txDhtCommitQueueSize;
    }

    @Override
    public int getTxDhtPrepareQueueSize() {
        return this.txDhtPrepareQueueSize;
    }

    @Override
    public int getTxDhtStartVersionCountsSize() {
        return this.txDhtStartVerCountsSize;
    }

    @Override
    public int getTxDhtCommittedVersionsSize() {
        return this.txDhtCommittedVersionsSize;
    }

    @Override
    public int getTxDhtRolledbackVersionsSize() {
        return this.txDhtRolledbackVersionsSize;
    }

    @Override
    public int getTotalPartitionsCount() {
        return this.totalPartitionsCnt;
    }

    @Override
    public long getRebalancedKeys() {
        return this.rebalancedKeys;
    }

    @Override
    public long getEstimatedRebalancingKeys() {
        return this.estimatedRebalancingKeys;
    }

    @Override
    public int getRebalancingPartitionsCount() {
        return this.rebalancingPartitionsCnt;
    }

    @Override
    public long getKeysToRebalanceLeft() {
        return this.keysToRebalanceLeft;
    }

    @Override
    public long getRebalancingKeysRate() {
        return this.rebalancingKeysRate;
    }

    @Override
    public long getRebalancingBytesRate() {
        return this.rebalancingBytesRate;
    }

    @Override
    public long estimateRebalancingFinishTime() {
        return this.rebalanceFinishTime;
    }

    @Override
    public long rebalancingStartTime() {
        return this.rebalanceStartTime;
    }

    @Override
    public long getEstimatedRebalancingFinishTime() {
        return this.rebalanceFinishTime;
    }

    @Override
    public long getRebalancingStartTime() {
        return this.rebalanceStartTime;
    }

    @Override
    public long getRebalanceClearingPartitionsLeft() {
        return this.rebalanceClearingPartitionsLeft;
    }

    @Override
    public boolean isWriteBehindEnabled() {
        return this.isWriteBehindEnabled;
    }

    @Override
    public int getWriteBehindFlushSize() {
        return this.writeBehindFlushSize;
    }

    @Override
    public int getWriteBehindFlushThreadCount() {
        return this.writeBehindFlushThreadCnt;
    }

    @Override
    public long getWriteBehindFlushFrequency() {
        return this.writeBehindFlushFreq;
    }

    @Override
    public int getWriteBehindStoreBatchSize() {
        return this.writeBehindStoreBatchSize;
    }

    @Override
    public int getWriteBehindTotalCriticalOverflowCount() {
        return this.writeBehindTotalCriticalOverflowCnt;
    }

    @Override
    public int getWriteBehindCriticalOverflowCount() {
        return this.writeBehindCriticalOverflowCnt;
    }

    @Override
    public int getWriteBehindErrorRetryCount() {
        return this.writeBehindErrorRetryCnt;
    }

    @Override
    public int getWriteBehindBufferSize() {
        return this.writeBehindBufSize;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public String getValueType() {
        return this.valType;
    }

    @Override
    public boolean isStoreByValue() {
        return this.isStoreByVal;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    @Override
    public boolean isManagementEnabled() {
        return this.isManagementEnabled;
    }

    @Override
    public boolean isReadThrough() {
        return this.isReadThrough;
    }

    @Override
    public boolean isWriteThrough() {
        return this.isWriteThrough;
    }

    @Override
    public boolean isValidForReading() {
        return this.isValidForReading;
    }

    @Override
    public boolean isValidForWriting() {
        return this.isValidForWriting;
    }

    @Override
    public String getTxKeyCollisions() {
        return "";
    }

    @Override
    public boolean isIndexRebuildInProgress() {
        return this.idxRebuildInProgress;
    }

    @Override
    public long getIndexRebuildKeysProcessed() {
        return this.idxRebuildKeyProcessed;
    }

    @Override
    public int getIndexBuildPartitionsLeftCount() {
        return 0;
    }

    public String toString() {
        return S.toString(CacheMetricsSnapshot.class, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.reads);
        out.writeLong(this.puts);
        out.writeLong(this.hits);
        out.writeLong(this.misses);
        out.writeLong(this.txCommits);
        out.writeLong(this.txRollbacks);
        out.writeLong(this.evicts);
        out.writeLong(this.removes);
        out.writeFloat(this.putAvgTimeNanos);
        out.writeFloat(this.getAvgTimeNanos);
        out.writeFloat(this.rmvAvgTimeNanos);
        out.writeFloat(this.commitAvgTimeNanos);
        out.writeFloat(this.rollbackAvgTimeNanos);
        out.writeLong(this.offHeapGets);
        out.writeLong(this.offHeapPuts);
        out.writeLong(this.offHeapRemoves);
        out.writeLong(this.offHeapEvicts);
        out.writeLong(this.offHeapHits);
        out.writeLong(this.offHeapMisses);
        out.writeLong(this.offHeapEntriesCnt);
        out.writeLong(this.heapEntriesCnt);
        out.writeLong(this.offHeapPrimaryEntriesCnt);
        out.writeLong(this.offHeapBackupEntriesCnt);
        out.writeLong(this.offHeapAllocatedSize);
        out.writeInt(this.dhtEvictQueueCurrSize);
        out.writeInt(this.txThreadMapSize);
        out.writeInt(this.txXidMapSize);
        out.writeInt(this.txCommitQueueSize);
        out.writeInt(this.txPrepareQueueSize);
        out.writeInt(this.txStartVerCountsSize);
        out.writeInt(this.txCommittedVersionsSize);
        out.writeInt(this.txRolledbackVersionsSize);
        out.writeInt(this.txDhtThreadMapSize);
        out.writeInt(this.txDhtXidMapSize);
        out.writeInt(this.txDhtCommitQueueSize);
        out.writeInt(this.txDhtPrepareQueueSize);
        out.writeInt(this.txDhtStartVerCountsSize);
        out.writeInt(this.txDhtCommittedVersionsSize);
        out.writeInt(this.txDhtRolledbackVersionsSize);
        out.writeInt(this.writeBehindTotalCriticalOverflowCnt);
        out.writeInt(this.writeBehindCriticalOverflowCnt);
        out.writeInt(this.writeBehindErrorRetryCnt);
        out.writeInt(this.totalPartitionsCnt);
        out.writeInt(this.rebalancingPartitionsCnt);
        out.writeLong(this.keysToRebalanceLeft);
        out.writeLong(this.rebalancingBytesRate);
        out.writeLong(this.rebalancingKeysRate);
        if (!(out instanceof OptimizedObjectOutputStream)) {
            out.writeLong(this.rebalancedKeys);
            out.writeLong(this.estimatedRebalancingKeys);
            out.writeLong(this.rebalanceStartTime);
            out.writeLong(this.rebalanceFinishTime);
            out.writeLong(this.rebalanceClearingPartitionsLeft);
            out.writeLong(this.entryProcessorPuts);
            out.writeFloat(this.entryProcessorAverageInvocationTime);
            out.writeLong(this.entryProcessorInvocations);
            out.writeFloat(this.entryProcessorMaxInvocationTime);
            out.writeFloat(this.entryProcessorMinInvocationTime);
            out.writeLong(this.entryProcessorReadOnlyInvocations);
            out.writeFloat(this.entryProcessorHitPercentage);
            out.writeLong(this.entryProcessorHits);
            out.writeLong(this.entryProcessorMisses);
            out.writeFloat(this.entryProcessorMissPercentage);
            out.writeLong(this.entryProcessorRemovals);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.reads = in.readLong();
        this.puts = in.readLong();
        this.hits = in.readLong();
        this.misses = in.readLong();
        this.txCommits = in.readLong();
        this.txRollbacks = in.readLong();
        this.evicts = in.readLong();
        this.removes = in.readLong();
        this.putAvgTimeNanos = in.readFloat();
        this.getAvgTimeNanos = in.readFloat();
        this.rmvAvgTimeNanos = in.readFloat();
        this.commitAvgTimeNanos = in.readFloat();
        this.rollbackAvgTimeNanos = in.readFloat();
        this.offHeapGets = in.readLong();
        this.offHeapPuts = in.readLong();
        this.offHeapRemoves = in.readLong();
        this.offHeapEvicts = in.readLong();
        this.offHeapHits = in.readLong();
        this.offHeapMisses = in.readLong();
        this.offHeapEntriesCnt = in.readLong();
        this.heapEntriesCnt = in.readLong();
        this.offHeapPrimaryEntriesCnt = in.readLong();
        this.offHeapBackupEntriesCnt = in.readLong();
        this.offHeapAllocatedSize = in.readLong();
        this.dhtEvictQueueCurrSize = in.readInt();
        this.txThreadMapSize = in.readInt();
        this.txXidMapSize = in.readInt();
        this.txCommitQueueSize = in.readInt();
        this.txPrepareQueueSize = in.readInt();
        this.txStartVerCountsSize = in.readInt();
        this.txCommittedVersionsSize = in.readInt();
        this.txRolledbackVersionsSize = in.readInt();
        this.txDhtThreadMapSize = in.readInt();
        this.txDhtXidMapSize = in.readInt();
        this.txDhtCommitQueueSize = in.readInt();
        this.txDhtPrepareQueueSize = in.readInt();
        this.txDhtStartVerCountsSize = in.readInt();
        this.txDhtCommittedVersionsSize = in.readInt();
        this.txDhtRolledbackVersionsSize = in.readInt();
        this.writeBehindTotalCriticalOverflowCnt = in.readInt();
        this.writeBehindCriticalOverflowCnt = in.readInt();
        this.writeBehindErrorRetryCnt = in.readInt();
        this.totalPartitionsCnt = in.readInt();
        this.rebalancingPartitionsCnt = in.readInt();
        this.keysToRebalanceLeft = in.readLong();
        this.rebalancingBytesRate = in.readLong();
        this.rebalancingKeysRate = in.readLong();
        if (in.available() >= 40) {
            this.rebalancedKeys = in.readLong();
            this.estimatedRebalancingKeys = in.readLong();
            this.rebalanceStartTime = in.readLong();
            this.rebalanceFinishTime = in.readLong();
            this.rebalanceClearingPartitionsLeft = in.readLong();
        }
        if (in.available() >= 68) {
            this.entryProcessorPuts = in.readLong();
            this.entryProcessorAverageInvocationTime = in.readFloat();
            this.entryProcessorInvocations = in.readLong();
            this.entryProcessorMaxInvocationTime = in.readFloat();
            this.entryProcessorMinInvocationTime = in.readFloat();
            this.entryProcessorReadOnlyInvocations = in.readLong();
            this.entryProcessorHitPercentage = in.readFloat();
            this.entryProcessorHits = in.readLong();
            this.entryProcessorMisses = in.readLong();
            this.entryProcessorMissPercentage = in.readFloat();
            this.entryProcessorRemovals = in.readLong();
        }
    }
}

