/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.diagnostic;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.cluster.NodeOrderComparator;
import org.apache.ignite.internal.management.diagnostic.DiagnosticPagelocksCommandArg;
import org.apache.ignite.internal.management.diagnostic.PageLocksResult;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageLockTrackerManager;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.dumpprocessors.ToStringDumpHelper;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class PageLocksTask
extends VisorMultiNodeTask<DiagnosticPagelocksCommandArg, Map<ClusterNode, PageLocksResult>, PageLocksResult> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<DiagnosticPagelocksCommandArg, PageLocksResult> job(DiagnosticPagelocksCommandArg arg) {
        return new PageLocksTrackerJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Map<ClusterNode, PageLocksResult> reduce0(List<ComputeJobResult> results) throws IgniteException {
        TreeMap<ClusterNode, PageLocksResult> mapRes = new TreeMap<ClusterNode, PageLocksResult>(NodeOrderComparator.getInstance());
        results.forEach(j -> {
            if (j.getException() == null) {
                mapRes.put(j.getNode(), (PageLocksResult)j.getData());
            } else if (j.getException() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                j.getException().printStackTrace(pw);
                mapRes.put(j.getNode(), new PageLocksResult(sw.toString()));
            }
        });
        return mapRes;
    }

    private static class PageLocksTrackerJob
    extends VisorJob<DiagnosticPagelocksCommandArg, PageLocksResult> {
        private static final long serialVersionUID = 0L;

        private PageLocksTrackerJob(DiagnosticPagelocksCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected PageLocksResult run(DiagnosticPagelocksCommandArg arg) {
            String result;
            PageLockTrackerManager lockTrackerMgr = this.ignite.context().cache().context().diagnostic().pageLockTracker();
            switch (arg.operation()) {
                case DUMP_LOG: {
                    lockTrackerMgr.dumpLocksToLog();
                    result = "Page locks dump was printed to console " + ToStringDumpHelper.DATE_FMT.format(Instant.now());
                    break;
                }
                case DUMP: {
                    String filePath = arg.path() != null ? lockTrackerMgr.dumpLocksToFile(arg.path()) : lockTrackerMgr.dumpLocksToFile();
                    result = "Page locks dump was writtern to file " + filePath;
                    break;
                }
                default: {
                    result = "Unsupported operation: " + (Object)((Object)arg.operation());
                }
            }
            return new PageLocksResult(result);
        }

        public String toString() {
            return S.toString(PageLocksTrackerJob.class, this);
        }
    }
}

