/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.internal.management.SystemViewCommand;
import org.apache.ignite.internal.management.SystemViewTask;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.cache.CacheScanCommandArg;
import org.apache.ignite.internal.management.cache.CacheScanTask;
import org.apache.ignite.internal.management.cache.CacheScanTaskResult;

public class CacheScanCommand
implements ComputeCommand<CacheScanCommandArg, CacheScanTaskResult> {
    @Override
    public String description() {
        return "Show cache content";
    }

    @Override
    public Class<CacheScanCommandArg> argClass() {
        return CacheScanCommandArg.class;
    }

    @Override
    public Class<CacheScanTask> taskClass() {
        return CacheScanTask.class;
    }

    @Override
    public void printResult(CacheScanCommandArg arg, CacheScanTaskResult res, Consumer<String> printer) {
        List<SystemViewTask.SimpleType> types = res.titles().stream().map(x -> SystemViewTask.SimpleType.STRING).collect(Collectors.toList());
        SystemViewCommand.printTable(res.titles(), types, res.entries(), printer);
        if (res.entries().size() == arg.limit()) {
            printer.accept("Result limited to " + arg.limit() + " rows. Limit can be changed with '--limit' argument.");
        }
    }
}

