/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ignite.internal.util.collection.IntMap;

public class IntHashMap<V>
implements IntMap<V> {
    public static final int INITIAL_CAPACITY = 8;
    public static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final int MAGIC_HASH_MIXER = -1640531527;
    private static final float SCALE_LOAD_FACTOR = 0.7f;
    private static final float COMPACT_LOAD_FACTOR = 0.2f;
    private int scaleThreshold;
    private int compactThreshold;
    private Entry<V>[] entries;
    private int size;

    static int tableSize(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 8 ? 8 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public IntHashMap() {
        this.entries = new Entry[8];
    }

    public IntHashMap(int cap) {
        int entriesSize = IntHashMap.tableSize(cap);
        this.compactThreshold = (int)(0.2f * (float)(entriesSize >> 1));
        this.scaleThreshold = (int)((float)entriesSize * 0.7f);
        this.entries = new Entry[entriesSize];
    }

    public IntHashMap(IntMap<? extends V> other) {
        this(other.size());
        other.forEach(this::put);
    }

    @Override
    public V get(int key) {
        int idx = this.find(key);
        return idx < 0 ? null : (V)this.entries[idx].val;
    }

    @Override
    public V put(int key, V val) {
        return this.put0(new Entry<V>(key, val));
    }

    @Override
    public V remove(int key) {
        int idx;
        if (this.entries.length != 8 && this.compactThreshold > this.size) {
            this.resize(false);
        }
        if ((idx = this.find(key)) < 0) {
            return null;
        }
        --this.size;
        Object tmp = this.entries[idx].val;
        for (int i = 0; i < this.entries.length; ++i) {
            int curIdx = idx + i & this.entries.length - 1;
            int nextIdx = idx + i + 1 & this.entries.length - 1;
            Entry<V> nextEntry = this.entries[nextIdx];
            if (nextEntry == null || this.distance(nextIdx, nextEntry.key) == 0) {
                this.entries[curIdx] = null;
                return tmp;
            }
            this.entries[curIdx] = nextEntry;
        }
        throw new IllegalStateException("Unreachable state exception. Backward shift has a problem. Removing key: " + key + " map state: " + this.toString());
    }

    @Override
    public V putIfAbsent(int key, V val) {
        int idx = this.find(key);
        if (idx < 0) {
            this.put(key, val);
            return null;
        }
        return this.entries[idx].val;
    }

    @Override
    public <E extends Throwable> void forEach(IntMap.EntryConsumer<V, E> act) throws E {
        for (Entry<V> entry : this.entries) {
            if (entry == null) continue;
            act.accept(entry.key, entry.val);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int[] keys() {
        int[] keys = new int[this.size];
        int idx = 0;
        for (Entry<V> entry : this.entries) {
            if (entry == null) continue;
            keys[idx++] = entry.key;
        }
        return keys;
    }

    @Override
    public Collection<V> values() {
        ArrayList vals = new ArrayList(this.size);
        for (Entry<V> entry : this.entries) {
            if (entry == null) continue;
            vals.add(entry.val);
        }
        return vals;
    }

    @Override
    public boolean containsKey(int key) {
        return this.find(key) >= 0;
    }

    @Override
    public boolean containsValue(V val) {
        return Arrays.stream(this.entries).filter(Objects::nonNull).anyMatch(entry -> Objects.equals(val, entry.val));
    }

    @Override
    public void clear() {
        this.entries = new Entry[8];
        this.compactThreshold = 0;
        this.scaleThreshold = 0;
        this.size = 0;
    }

    public String toString() {
        String strEntries = Arrays.stream(this.entries).filter(Objects::nonNull).map(Entry::toString).collect(Collectors.joining(","));
        return "IntHashMap{size=" + this.size + ", entries=[" + strEntries + "]}";
    }

    protected int distance(int curIdx, int key) {
        int keyIdx = this.index(key);
        return curIdx >= keyIdx ? curIdx - keyIdx : this.entries.length - keyIdx + curIdx;
    }

    protected int index(int key) {
        return this.entries.length - 1 & (key ^ key >>> 16) * -1640531527;
    }

    private V put0(Entry<V> entry) {
        if (this.size >= this.scaleThreshold) {
            this.resize(true);
        }
        Entry<V> savedEntry = entry;
        int startKey = savedEntry.key;
        for (int i = 0; i < this.entries.length; ++i) {
            int savedDist;
            int idx = this.index(startKey) + i & this.entries.length - 1;
            Entry<V> curEntry = this.entries[idx];
            if (curEntry == null) {
                this.entries[idx] = savedEntry;
                ++this.size;
                return null;
            }
            if (curEntry.key == savedEntry.key) {
                this.entries[idx] = savedEntry;
                return curEntry.val;
            }
            int curDist = this.distance(idx, curEntry.key);
            if (curDist >= (savedDist = this.distance(idx, savedEntry.key))) continue;
            this.entries[idx] = savedEntry;
            savedEntry = curEntry;
        }
        throw new IllegalStateException("Unreachable state exception. Insertion position not found. Entry: " + entry + " map state: " + this.toString());
    }

    private int find(int key) {
        int idx = this.index(key);
        for (int keyDist = 0; keyDist < this.entries.length; ++keyDist) {
            int curIdx = idx + keyDist & this.entries.length - 1;
            Entry<V> entry = this.entries[curIdx];
            if (entry == null) {
                return -1;
            }
            if (entry.key == key) {
                return curIdx;
            }
            int entryDist = this.distance(curIdx, entry.key);
            if (keyDist <= entryDist) continue;
            return -1;
        }
        return -1;
    }

    private void resize(boolean increase) {
        if (0x40000000 == this.entries.length) {
            throw new IllegalStateException("Maximum capacity: 1073741824 is reached.");
        }
        Entry<V>[] oldEntries = this.entries;
        int newCap = increase ? this.entries.length << 1 : this.entries.length >> 1;
        this.entries = new Entry[newCap];
        this.compactThreshold = (int)(0.2f * (float)(this.entries.length >> 1));
        this.scaleThreshold = (int)((float)this.entries.length * 0.7f);
        this.size = 0;
        for (Entry<V> entry : oldEntries) {
            if (entry == null) continue;
            this.put0(entry);
        }
    }

    private static class Entry<V> {
        public final int key;
        public final V val;

        Entry(int key, V val) {
            this.key = key;
            this.val = val;
        }

        public String toString() {
            return "{key=" + this.key + ", val=" + this.val + '}';
        }
    }
}

