/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteIllegalStateException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.cache.query.index.IndexQueryResultMeta;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.query.GridCacheDistributedQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryBean;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryFutureAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryRequest;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.cache.query.reducer.IndexQueryReducer;
import org.apache.ignite.internal.processors.cache.query.reducer.NodePageStream;
import org.apache.ignite.internal.processors.cache.query.reducer.TextQueryReducer;
import org.apache.ignite.internal.processors.cache.query.reducer.UnsortedCacheQueryReducer;
import org.apache.ignite.internal.processors.performancestatistics.PerformanceStatisticsProcessor;
import org.apache.ignite.internal.util.lang.GridPlainCallable;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridCacheDistributedQueryFuture<K, V, R>
extends GridCacheQueryFutureAdapter<K, V, R> {
    private final long reqId;
    private final GridCacheDistributedQueryManager<K, V> qryMgr;
    private final Map<UUID, NodePageStream<R>> streams;
    private final AtomicInteger noRemotePagesStreamsCnt = new AtomicInteger();
    private final CountDownLatch firstPageLatch = new CountDownLatch(1);
    private Set<UUID> rcvdFirstPage = ConcurrentHashMap.newKeySet();
    private final CompletableFuture<IndexQueryResultMeta> idxQryMetaFut;
    private final long startTimeNanos;

    protected GridCacheDistributedQueryFuture(GridCacheContext<K, V> ctx, long reqId, GridCacheQueryBean qry, Collection<ClusterNode> nodes) {
        super(ctx, qry, false);
        assert (reqId > 0L);
        this.reqId = reqId;
        this.qryMgr = (GridCacheDistributedQueryManager)ctx.queries();
        if (qry.query().partition() != null) {
            nodes = Collections.singletonList(this.node(nodes));
        }
        this.streams = new ConcurrentHashMap<UUID, NodePageStream<R>>(nodes.size());
        for (ClusterNode node : nodes) {
            this.streams.computeIfAbsent(node.id(), nodeId -> new NodePageStream((UUID)nodeId, () -> this.requestPages((UUID)nodeId), () -> this.cancelPages((UUID)nodeId)));
        }
        Map<UUID, NodePageStream<R>> streamsMap = Collections.unmodifiableMap(this.streams);
        if (qry.query().type() == GridCacheQueryType.INDEX) {
            this.idxQryMetaFut = new CompletableFuture();
            this.reducer = new IndexQueryReducer<R>(qry.query().idxQryDesc().valType(), streamsMap, this.cctx, this.idxQryMetaFut);
        } else {
            this.idxQryMetaFut = null;
            this.reducer = qry.query().type() == GridCacheQueryType.TEXT ? new TextQueryReducer<R>(streamsMap) : new UnsortedCacheQueryReducer<R>(streamsMap);
        }
        this.startTimeNanos = ctx.kernalContext().performanceStatistics().enabled() ? System.nanoTime() : 0L;
    }

    private ClusterNode node(Collection<ClusterNode> nodes) {
        ClusterNode rmtNode = null;
        for (ClusterNode node : nodes) {
            if (node.isLocal()) {
                return node;
            }
            rmtNode = node;
        }
        return rmtNode;
    }

    @Override
    protected void cancelQuery(Throwable err) {
        this.firstPageLatch.countDown();
        for (NodePageStream<R> s : this.streams.values()) {
            s.cancel(err);
        }
        this.cctx.queries().onQueryFutureCanceled(this.reqId);
        this.clear();
    }

    @Override
    protected void onNodeLeft(UUID nodeId) {
        NodePageStream<R> stream = this.streams.get(nodeId);
        if (stream != null && stream.hasRemotePages()) {
            this.onError(new ClusterTopologyCheckedException("Remote node has left topology: " + nodeId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onPage(UUID nodeId, Collection<R> data, boolean last) {
        CountDownLatch countDownLatch = this.firstPageLatch;
        synchronized (countDownLatch) {
            if (this.rcvdFirstPage != null) {
                this.rcvdFirstPage.add(nodeId);
                if (this.rcvdFirstPage.size() == this.streams.size()) {
                    this.firstPageLatch.countDown();
                    this.rcvdFirstPage.clear();
                    this.rcvdFirstPage = null;
                }
            }
        }
        NodePageStream<R> stream = this.streams.get(nodeId);
        if (stream == null) {
            return;
        }
        stream.addPage(data, last);
        if (last) {
            int cnt;
            while (!this.noRemotePagesStreamsCnt.compareAndSet(cnt = this.noRemotePagesStreamsCnt.get(), cnt + 1)) {
            }
            if (cnt + 1 >= this.streams.size()) {
                this.onDone();
            }
        }
    }

    @Override
    protected void onMeta(IndexQueryResultMeta metaData) {
        if (metaData != null) {
            this.idxQryMetaFut.complete(metaData);
        }
    }

    @Override
    public void awaitFirstItemAvailable() throws IgniteCheckedException {
        U.await(this.firstPageLatch);
        if (this.isDone() && this.error() != null) {
            super.get();
        }
    }

    @Override
    public Collection<R> get() throws IgniteCheckedException {
        return this.get0();
    }

    @Override
    public Collection<R> get(long timeout, TimeUnit unit) throws IgniteCheckedException {
        return this.get0();
    }

    @Override
    public Collection<R> getUninterruptibly() throws IgniteCheckedException {
        return this.get0();
    }

    private Collection<R> get0() {
        throw new IgniteIllegalStateException("Unexpected lock on iterator over distributed cache query result.");
    }

    @Override
    void clear() {
        assert (this.isDone()) : this;
        GridCacheDistributedQueryManager qryMgr = (GridCacheDistributedQueryManager)this.cctx.queries();
        if (qryMgr != null) {
            qryMgr.removeQueryFuture(this.reqId);
        }
    }

    long requestId() {
        return this.reqId;
    }

    public void startQuery() {
        try {
            GridCacheQueryRequest req = GridCacheQueryRequest.startQueryRequest(this.cctx, this.reqId, this);
            this.qryMgr.sendRequest(this, req, this.streams.keySet());
        }
        catch (IgniteCheckedException e) {
            this.onError(e);
        }
    }

    private void requestPages(UUID nodeId) {
        try {
            GridCacheQueryRequest req = GridCacheQueryRequest.pageRequest(this.cctx, this.reqId, this.query().query(), this.fields());
            this.qryMgr.sendRequest(this, req, Collections.singletonList(nodeId));
        }
        catch (IgniteCheckedException e) {
            this.onError(e);
        }
    }

    private void cancelPages(UUID nodeId) {
        block7: {
            try {
                final GridCacheQueryRequest req = GridCacheQueryRequest.cancelRequest(this.cctx, this.reqId, this.fields());
                if (nodeId.equals(this.cctx.localNodeId())) {
                    this.cctx.closures().callLocalSafe(new GridPlainCallable<Object>(){

                        @Override
                        public Object call() {
                            GridCacheDistributedQueryFuture.this.qryMgr.processQueryRequest(GridCacheDistributedQueryFuture.this.cctx.localNodeId(), req);
                            return null;
                        }
                    });
                    break block7;
                }
                try {
                    this.cctx.io().send(nodeId, (GridCacheMessage)req, this.cctx.ioPolicy());
                }
                catch (IgniteCheckedException e) {
                    if (this.cctx.io().checkNodeLeft(nodeId, e, false)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to send cancel request, node failed: " + nodeId);
                        }
                        break block7;
                    }
                    U.error(log, "Failed to send cancel request [node=" + nodeId + ']', e);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(this.logger(), "Failed to send cancel request (will cancel query in any case).", e);
            }
        }
    }

    @Override
    protected void onError(Throwable err) {
        if (this.onDone(err)) {
            this.streams.values().forEach(s -> s.cancel(err));
            if (this.idxQryMetaFut != null && !this.idxQryMetaFut.isDone()) {
                this.idxQryMetaFut.completeExceptionally(err);
            }
            this.firstPageLatch.countDown();
        }
    }

    @Override
    public boolean onDone(Collection<R> res, Throwable err) {
        if (this.cctx.kernalContext().performanceStatistics().enabled() && this.startTimeNanos > 0L) {
            GridCacheQueryType type = this.qry.query().type();
            String text = type == GridCacheQueryType.INDEX ? PerformanceStatisticsProcessor.indexQueryText(this.cctx.name(), this.qry.query().idxQryDesc()) : this.cctx.name();
            this.cctx.kernalContext().performanceStatistics().query(type, text, this.reqId, this.startTimeNanos, System.nanoTime() - this.startTimeNanos, err == null);
        }
        return super.onDone(res, err);
    }
}

